---
generated_at: 2026-01-08 10:39:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-调度日志.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全項目が根拠付きで確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java` (65-74行目)
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` (@Excelアノテーション定義)
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` (exportExcelメソッド)
- E-04: `ruoyi-quartz/src/main/resources/mapper/quartz/SysJobLogMapper.xml` (selectJobLogList SQL)
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` (帳票一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エクスポート機能はSysJobLogController.exportメソッドで実装 | E-01 | ○ |
| C-02 | 権限チェックはmonitor:job:exportで行われる | E-01 (66行目) | ○ |
| C-03 | @Logアノテーションで操作ログを記録 | E-01 (65行目) | ○ |
| C-04 | jobLogService.selectJobLogListでデータ取得 | E-01 (71行目) | ○ |
| C-05 | ExcelUtil<SysJobLog>でExcel出力を実行 | E-01 (72-73行目) | ○ |
| C-06 | シート名は「调度日志」 | E-01 (73行目) | ○ |
| C-07 | job_log_idは「日志序号」として出力 | E-02 (19行目) | ○ |
| C-08 | job_nameは「任务名称」として出力 | E-02 (23行目) | ○ |
| C-09 | job_groupは「任务组名」として出力 | E-02 (27行目) | ○ |
| C-10 | invoke_targetは「调用目标字符串」として出力 | E-02 (31行目) | ○ |
| C-11 | job_messageは「日志信息」として出力 | E-02 (35行目) | ○ |
| C-12 | statusは0=正常,1=失败に変換される | E-02 (39行目) | ○ |
| C-13 | exception_infoは「异常信息」として出力 | E-02 (43行目) | ○ |
| C-14 | Excel出力形式はxlsx | E-03 (SXSSFWorkbook使用) | ○ |
| C-15 | sys_job_logテーブルから取得 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力項目とデータ型の定義（コードで明確に定義）
- 0: 低リスク - 権限制御の実装（アノテーションで明確）
- 0: 低リスク - 実行状態の変換ルール（正常/失敗が定義済み）
- 1: 中リスク - 例外情報にスタックトレースが含まれる可能性（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] @Excelアノテーションの出力項目がSysJobLog.javaの定義と一致しているか
- [ ] readConverterExpのstatus変換ルール（正常/失敗）が正しいか
- [ ] 権限設定（monitor:job:export）が適切か
- [ ] 例外情報に機密情報が含まれていないか確認
