---
generated_at: 2026-01-08 15:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-用户数据（デモ）帳票設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間**：具体的な性能計測結果の根拠がない（推測値）
  2. **セキュリティ考慮事項のCSVインジェクション対策**：実装は確認済みだが、設計意図の明文化された根拠は未確認
  3. **同時出力数上限**：制限の有無についての明示的な設計ドキュメントなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoOperateController.java`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoTableController.java`
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/domain/UserOperateModel.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java`
- E-05: `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Excel.java`
- E-06: `ruoyi-admin/src/main/resources/templates/demo/operate/table.html`
- E-07: `ruoyi-admin/src/main/resources/templates/demo/table/export.html`
- E-08: `ruoyi-admin/src/main/resources/templates/demo/table/exportSelected.html`
- E-09: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 帳票名は「用户数据（デモ）」である | E-09（帳票一覧.csv行12） | ○ |
| C-02 | DemoOperateController.export()がエクスポート処理を担当 | E-01（行191-198） | ○ |
| C-03 | DemoTableController.exportData()が選択エクスポートを担当 | E-02（行194-218） | ○ |
| C-04 | 出力形式はExcel(.xlsx) | E-04（行1490-1491: encodingFilename） | ○ |
| C-05 | シート名は「用户数据」 | E-01（行197）、E-02（行217） | ○ |
| C-06 | 静的データは26件のユーザー情報を含む | E-01（行39-66）、E-02（行39-67） | ○ |
| C-07 | UserOperateModelに@Excelアノテーションが定義されている | E-03（行15-37） | ○ |
| C-08 | 用户编号フィールドはuserCodeに対応 | E-03（行15-16） | ○ |
| C-09 | 用户姓名フィールドはuserNameに対応 | E-03（行18-19） | ○ |
| C-10 | 用户性别は「0=男,1=女,2=未知」で変換される | E-03（行21-22: readConverterExp） | ○ |
| C-11 | 用户状态は「0=正常,1=停用」で変換される | E-03（行33-34: readConverterExp） | ○ |
| C-12 | 创建时间は「yyyy-MM-dd HH:mm:ss」形式で出力 | E-03（行36-37: dateFormat） | ○ |
| C-13 | 创建时间はエクスポートのみ（type=EXPORT） | E-03（行36: type = Type.EXPORT） | ○ |
| C-14 | ExcelUtilがApache POIを使用してExcel生成 | E-04（行1-87: importステートメント） | ○ |
| C-15 | SXSSFWorkbookを使用（ストリーミング方式） | E-04（行1681: new SXSSFWorkbook(500)） | ○ |
| C-16 | 最大行数は65536行/シート | E-04（行112-113: sheetSize = 65536） | ○ |
| C-17 | CSVインジェクション対策が実装されている | E-04（行1022-1025: FORMULA_STRチェック） | ○ |
| C-18 | 画面URL「/demo/operate/table」から出力可能 | E-01（行33, 71-75）、E-06 | ○ |
| C-19 | 画面URL「/demo/table/export」から出力可能 | E-02（行176-180）、E-07 | ○ |
| C-20 | 画面URL「/demo/table/exportSelected」から出力可能 | E-02（行185-189）、E-08 | ○ |
| C-21 | 導出ボタンでエクスポートを実行 | E-06（行22-23）、E-08（行26-28） | ○ |
| C-22 | userIdsパラメータで選択行の絞り込みが可能 | E-02（行196, 202-215）、E-08（行100-106） | ○ |
| C-23 | ファイル名形式は{UUID}_用户数据.xlsx | E-04（行1488-1491: encodingFilename） | ○ |
| C-24 | エラー時は「导出Excel失败，请联系网站管理员！」表示 | E-04（行674: throw new UtilException） | ○ |
| C-25 | インポート時空データエラーは「导入用户数据不能为空！」 | E-01（行268-269: throw ServiceException） | ○ |
| C-26 | UserTableModelは別の@Excel定義を持つ | E-02（行689-832: 内部クラス定義） | ○ |
| C-27 | 目標出力時間は1秒以内 | **根拠なし** | △ |
| C-28 | 想定データ件数は26件 | E-01（行39-66）、E-02（行39-67） | ○ |

## 4) 不足情報（Unknown / Missing）
- **目標出力時間（C-27）**：具体的な性能要件の根拠となるドキュメントが存在しない。26件程度のデータであれば1秒以内は妥当な推測だが、明示的な設計根拠はない。
  - 候補：性能要件定義書 / 性能テスト結果 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - データ構造・エクスポートフィールド定義（C-07〜C-13）
  - ソースコードから直接確認可能で、誤りの可能性が低い
- **0: 低リスク** - 処理フロー・呼び出し関係（C-02, C-03, C-14〜C-16）
  - ソースコードの実装と一致しており、信頼性が高い
- **1: 中リスク** - パフォーマンス要件（C-27, C-28）
  - 目標出力時間は推測値であり、実測値との乖離の可能性あり
- **0: 低リスク** - セキュリティ対策（C-17）
  - 実装は確認済みだが、全ての攻撃ベクトルをカバーしているかは別途検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] @Excelアノテーションの定義と設計書の項目定義が一致しているか確認
- [ ] readConverterExpの変換値（0=男,1=女,2=未知など）が実データと整合しているか確認
- [ ] DemoOperateControllerとDemoTableControllerのエクスポート項目の差異が正しく記載されているか確認
- [ ] 画面URL・操作方法が実際のシステム動作と一致するか確認
- [ ] パフォーマンス要件（1秒以内）が実運用で問題ないか確認（必要に応じて実測）
- [ ] CSVインジェクション対策の実装が十分かセキュリティ観点で確認
