---
generated_at: 2026-01-08 10:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-岗位数据.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全項目が根拠付きで確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` (54-63行目)
- E-02: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` (@Excelアノテーション定義)
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` (exportExcelメソッド)
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysPostMapper.xml` (selectPostList SQL)
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` (帳票一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エクスポート機能はSysPostController.exportメソッドで実装 | E-01 | ○ |
| C-02 | 権限チェックはsystem:post:exportで行われる | E-01 (55行目) | ○ |
| C-03 | @Logアノテーションで操作ログを記録 | E-01 (54行目) | ○ |
| C-04 | postService.selectPostListでデータ取得 | E-01 (60行目) | ○ |
| C-05 | ExcelUtil<SysPost>でExcel出力を実行 | E-01 (61-62行目) | ○ |
| C-06 | シート名は「岗位数据」 | E-01 (62行目) | ○ |
| C-07 | post_idは「岗位序号」として出力 | E-02 (20行目) | ○ |
| C-08 | post_codeは「岗位编码」として出力 | E-02 (24行目) | ○ |
| C-09 | post_nameは「岗位名称」として出力 | E-02 (28行目) | ○ |
| C-10 | post_sortは「岗位排序」として出力 | E-02 (32行目) | ○ |
| C-11 | statusは0=正常,1=停用に変換される | E-02 (36行目) | ○ |
| C-12 | Excel出力形式はxlsx | E-03 (SXSSFWorkbook使用) | ○ |
| C-13 | sys_postテーブルから取得 | E-04 | ○ |
| C-14 | ファイル名形式は「岗位数据_{日時}.xlsx」 | E-03 | ○ |
| C-15 | 出力方法はダウンロード | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力項目とデータ型の定義（コードで明確に定義）
- 0: 低リスク - 権限制御の実装（アノテーションで明確）
- 0: 低リスク - 状態の変換ルール（2種類が定義済み）

## 6) レビュアーチェックリスト（最小）
- [ ] @Excelアノテーションの出力項目がSysPost.javaの定義と一致しているか
- [ ] readConverterExpのstatus変換ルールが正しいか
- [ ] 権限設定（system:post:export）が適切か
