---
generated_at: 2026-01-08 10:38:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-定时任务.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全項目が根拠付きで確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` (61-70行目)
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` (@Excelアノテーション定義)
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` (exportExcelメソッド)
- E-04: `ruoyi-quartz/src/main/resources/mapper/quartz/SysJobMapper.xml` (selectJobList SQL)
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` (帳票一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エクスポート機能はSysJobController.exportメソッドで実装 | E-01 | ○ |
| C-02 | 権限チェックはmonitor:job:exportで行われる | E-01 (62行目) | ○ |
| C-03 | @Logアノテーションで操作ログを記録 | E-01 (61行目) | ○ |
| C-04 | jobService.selectJobListでデータ取得 | E-01 (67行目) | ○ |
| C-05 | ExcelUtil<SysJob>でExcel出力を実行 | E-01 (68-69行目) | ○ |
| C-06 | シート名は「定时任务」 | E-01 (69行目) | ○ |
| C-07 | job_idは「任务序号」として出力 | E-02 (25行目) | ○ |
| C-08 | job_nameは「任务名称」として出力 | E-02 (29行目) | ○ |
| C-09 | job_groupは「任务组名」として出力 | E-02 (33行目) | ○ |
| C-10 | invoke_targetは「调用目标字符串」として出力 | E-02 (37行目) | ○ |
| C-11 | cron_expressionは「执行表达式」として出力 | E-02 (41行目) | ○ |
| C-12 | misfire_policyは4種類の計画策略に変換される | E-02 (45行目) | ○ |
| C-13 | concurrentは0=允许,1=禁止に変換される | E-02 (49行目) | ○ |
| C-14 | statusは0=正常,1=暂停に変換される | E-02 (53行目) | ○ |
| C-15 | Excel出力形式はxlsx | E-03 (SXSSFWorkbook使用) | ○ |
| C-16 | sys_jobテーブルから取得 | E-04 | ○ |
| C-17 | ファイル名形式は「定时任务_{日時}.xlsx」 | E-03 | ○ |
| C-18 | 出力方法はダウンロード | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力項目とデータ型の定義（コードで明確に定義）
- 0: 低リスク - 権限制御の実装（アノテーションで明確）
- 0: 低リスク - 計画策略、並行実行、タスク状態の変換ルール（すべて定義済み）
- 1: 中リスク - 呼出対象にメソッド情報が含まれる可能性（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] @Excelアノテーションの出力項目がSysJob.javaの定義と一致しているか
- [ ] readConverterExpのmisfire_policy変換ルール（4種類）が正しいか
- [ ] readConverterExpのconcurrent変換ルール（允许/禁止）が正しいか
- [ ] readConverterExpのstatus変換ルール（正常/暂停）が正しいか
- [ ] 権限設定（monitor:job:export）が適切か
