---
generated_at: 2026-01-08 16:00:00
metrics:
  claims_total: 90
  claims_with_evidence: 88
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：88 / 90、根拠なし：2
- 優先レビュー（高）
  1. **BR-074 Cron式検証**：クライアント側バリデーションの詳細仕様が不明確
  2. **BR-084 ローカルコード生成**：上書き設定の詳細仕様が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-04: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java`
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java`
- E-06: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java`
- E-07: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-08: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java`
- E-09: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-10: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java`
- E-11: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java`
- E-12: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java`
- E-13: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java`
- E-14: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java`
- E-15: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-16: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-17: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java`
- E-18: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java`
- E-19: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysRegisterService.java`
- E-20: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 ユーザーログイン | E-05 | ○ |
| C-02 | BR-002 ユーザー登録 | E-06, E-19 | ○ |
| C-03 | BR-003 パスワード検証 | E-20 | ○ |
| C-04 | BR-004 アカウント解除 | E-12, E-20 | ○ |
| C-05 | BR-005 セッション管理 | E-14 | ○ |
| C-06 | BR-006 ユーザー一覧表示 | E-01 | ○ |
| C-07 | BR-007 ユーザー新規作成 | E-01, E-17 | ○ |
| C-08 | BR-008 ユーザー情報更新 | E-01, E-17 | ○ |
| C-09 | BR-009 ユーザー削除 | E-01 | ○ |
| C-10 | BR-010 パスワードリセット | E-01, E-20 | ○ |
| C-11 | BR-011 ユーザー状態変更 | E-01 | ○ |
| C-12 | BR-012 ユーザーインポート | E-01 | ○ |
| C-13 | BR-013 ユーザーエクスポート | E-01 | ○ |
| C-14 | BR-014 ユーザーロール授与 | E-01 | ○ |
| C-15 | BR-015 個人情報表示 | E-11 | ○ |
| C-16 | BR-016 個人情報更新 | E-11 | ○ |
| C-17 | BR-017 パスワード変更 | E-11, E-20 | ○ |
| C-18 | BR-018 アバター変更 | E-11 | ○ |
| C-19 | BR-019 ロール一覧表示 | E-02 | ○ |
| C-20 | BR-020 ロール新規作成 | E-02, E-18 | ○ |
| C-21 | BR-021 ロール情報更新 | E-02, E-18 | ○ |
| C-22 | BR-022 ロール削除 | E-02 | ○ |
| C-23 | BR-023 ロール状態変更 | E-02 | ○ |
| C-24 | BR-024 データ権限設定 | E-02 | ○ |
| C-25 | BR-025 ロールユーザー管理 | E-02 | ○ |
| C-26 | BR-026 ロールエクスポート | E-02 | ○ |
| C-27 | BR-027 メニュー一覧表示 | E-03 | ○ |
| C-28 | BR-028 メニュー新規作成 | E-03 | ○ |
| C-29 | BR-029 メニュー情報更新 | E-03 | ○ |
| C-30 | BR-030 メニュー削除 | E-03 | ○ |
| C-31 | BR-031 メニュー並び替え | E-03 | ○ |
| C-32 | BR-032 部門一覧表示 | E-04 | ○ |
| C-33 | BR-033 部門新規作成 | E-04 | ○ |
| C-34 | BR-034 部門情報更新 | E-04 | ○ |
| C-35 | BR-035 部門削除 | E-04 | ○ |
| C-36 | BR-036 役職一覧表示 | E-10 | ○ |
| C-37 | BR-037 役職新規作成 | E-10 | ○ |
| C-38 | BR-038 役職情報更新 | E-10 | ○ |
| C-39 | BR-039 役職削除 | E-10 | ○ |
| C-40 | BR-040 役職エクスポート | E-10 | ○ |
| C-41 | BR-041 辞書タイプ一覧表示 | E-08 | ○ |
| C-42 | BR-042 辞書タイプ新規作成 | E-08 | ○ |
| C-43 | BR-043 辞書タイプ更新 | E-08 | ○ |
| C-44 | BR-044 辞書タイプ削除 | E-08 | ○ |
| C-45 | BR-045 辞書キャッシュリフレッシュ | E-08 | ○ |
| C-46 | BR-046 辞書タイプエクスポート | E-08 | ○ |
| C-47 | BR-047 システム設定一覧表示 | E-07 | ○ |
| C-48 | BR-048 システム設定新規作成 | E-07 | ○ |
| C-49 | BR-049 システム設定更新 | E-07 | ○ |
| C-50 | BR-050 システム設定削除 | E-07 | ○ |
| C-51 | BR-051 設定キャッシュリフレッシュ | E-07 | ○ |
| C-52 | BR-052 設定エクスポート | E-07 | ○ |
| C-53 | BR-053 通知公告一覧表示 | E-09 | ○ |
| C-54 | BR-054 通知公告新規作成 | E-09 | ○ |
| C-55 | BR-055 通知公告更新 | E-09 | ○ |
| C-56 | BR-056 通知公告削除 | E-09 | ○ |
| C-57 | BR-057 通知公告詳細表示 | E-09 | ○ |
| C-58 | BR-058 ログイン履歴一覧表示 | E-12 | ○ |
| C-59 | BR-059 ログイン履歴削除 | E-12 | ○ |
| C-60 | BR-060 ログイン履歴クリア | E-12 | ○ |
| C-61 | BR-061 ログイン履歴エクスポート | E-12 | ○ |
| C-62 | BR-062 操作ログ一覧表示 | E-13 | ○ |
| C-63 | BR-063 操作ログ詳細表示 | E-13 | ○ |
| C-64 | BR-064 操作ログ削除 | E-13 | ○ |
| C-65 | BR-065 操作ログクリア | E-13 | ○ |
| C-66 | BR-066 操作ログエクスポート | E-13 | ○ |
| C-67 | BR-067 オンラインユーザー一覧 | E-14 | ○ |
| C-68 | BR-068 定時タスク一覧表示 | E-15 | ○ |
| C-69 | BR-069 定時タスク新規作成 | E-15 | ○ |
| C-70 | BR-070 定時タスク更新 | E-15 | ○ |
| C-71 | BR-071 定時タスク削除 | E-15 | ○ |
| C-72 | BR-072 定時タスク状態変更 | E-15 | ○ |
| C-73 | BR-073 定時タスク即時実行 | E-15 | ○ |
| C-74 | BR-074 Cron式検証 | **根拠不足** | △ |
| C-75 | BR-075 定時タスクエクスポート | E-15 | ○ |
| C-76 | BR-076 テーブル一覧表示 | E-16 | ○ |
| C-77 | BR-077 データベーステーブル取得 | E-16 | ○ |
| C-78 | BR-078 テーブルインポート | E-16 | ○ |
| C-79 | BR-079 テーブル作成 | E-16 | ○ |
| C-80 | BR-080 コード生成設定更新 | E-16 | ○ |
| C-81 | BR-081 コードプレビュー | E-16 | ○ |
| C-82 | BR-082 コードダウンロード | E-16 | ○ |
| C-83 | BR-083 コード一括生成 | E-16 | ○ |
| C-84 | BR-084 ローカルコード生成 | **根拠不足** | △ |
| C-85 | BR-085 データベース同期 | E-16 | ○ |
| C-86 | BR-086 ログイン名一意性検証 | E-17 | ○ |
| C-87 | BR-087 電話番号一意性検証 | E-17 | ○ |
| C-88 | BR-088 メールアドレス一意性検証 | E-17 | ○ |
| C-89 | BR-089 データ権限スコープ検証 | E-17 | ○ |
| C-90 | BR-090 操作権限検証 | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-074 Cron式検証**：コード内でCronUtils.isValid()の呼び出しは確認できるが、クライアント側でどのように使用されるかの詳細仕様書が見つからない
  - 候補：フロントエンドJavaScript / API仕様書 / ユーザーガイド
- **BR-084 ローカルコード生成**：GenConfig.isAllowOverwrite()の設定ファイルと動作の詳細仕様が不明
  - 候補：application.yml / GenConfig.java / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：認証・認可関連（BR-001〜BR-005）- ソースコードで明確に実装確認
- **0（低リスク）**：ユーザー管理関連（BR-006〜BR-014）- CRUD操作が明確に定義
- **0（低リスク）**：ロール管理関連（BR-019〜BR-026）- 権限制御が明確に実装
- **0（低リスク）**：ログ管理関連（BR-058〜BR-066）- 監査機能が適切に実装
- **1（中リスク）**：コード生成関連（BR-076〜BR-085）- 一部設定の詳細が不明確
- **1（中リスク）**：スケジュール関連（BR-068〜BR-075）- セキュリティ制約の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BR-074：Cron式検証のクライアント側バリデーション仕様を確認
- [ ] BR-084：ローカルコード生成の上書き設定（GenConfig.isAllowOverwrite）の設定ファイルを確認
- [ ] 認証・認可関連の要件が実際のセキュリティポリシーと整合しているか確認
- [ ] データ権限スコープ（BR-089）の部門ベース権限制御が業務要件と一致しているか確認
- [ ] パスワードポリシー（BR-003, BR-017）の設定値（maxRetryCount等）が運用ポリシーと一致しているか確認
