---
generated_at: 2026-01-08 13:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての機能がソースコードのControllerクラスから直接抽出されており、根拠不足の項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-04: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java`
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java`
- E-06: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-07: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-08: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java`
- E-09: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java`
- E-10: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java`
- E-11: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java`
- E-12: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java`
- E-13: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/ServerController.java`
- E-14: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/CacheController.java`
- E-15: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/DruidController.java`
- E-16: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-17: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java`
- E-18: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-19: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java`
- E-20: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java`
- E-21: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysCaptchaController.java`
- E-22: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java`
- E-23: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/common/CommonController.java`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザー管理：一覧表示、新規登録、編集、削除、パスワードリセット、ロール割当、Excel出入力、ステータス変更 | E-01 | ○ |
| C-02 | ロール管理：一覧表示、新規登録、編集、削除、データ権限設定、ユーザー割当、Excel出力、ステータス変更 | E-02 | ○ |
| C-03 | メニュー管理：一覧表示、新規登録、編集、削除、ツリー表示、アイコン選択、ソート更新 | E-03 | ○ |
| C-04 | 部門管理：一覧表示、新規登録、編集、削除、ツリー表示 | E-04 | ○ |
| C-05 | 役職管理：一覧表示、新規登録、編集、削除、Excel出力 | E-05 | ○ |
| C-06 | 通知公告：一覧表示、新規登録、編集、削除、詳細表示 | E-06 | ○ |
| C-07 | パラメータ設定：一覧表示、新規登録、編集、削除、キャッシュ更新、Excel出力 | E-07 | ○ |
| C-08 | 辞書タイプ管理：一覧表示、新規登録、編集、削除、キャッシュ更新、ツリー表示、Excel出力 | E-08 | ○ |
| C-09 | 辞書データ管理：一覧表示、新規登録、編集、削除、Excel出力 | E-09 | ○ |
| C-10 | 操作ログ：一覧表示、詳細表示、削除、クリア、Excel出力 | E-10 | ○ |
| C-11 | ログインログ：一覧表示、削除、クリア、アカウントロック解除、Excel出力 | E-11 | ○ |
| C-12 | オンラインユーザー：一覧表示、強制ログアウト | E-12 | ○ |
| C-13 | サーバー監視：CPU、メモリ、JVM、ディスク等のシステム情報表示 | E-13 | ○ |
| C-14 | キャッシュ監視：一覧表示、キー取得、値取得、キャッシュクリア | E-14 | ○ |
| C-15 | データ監視：Druidデータソース監視画面へのリダイレクト | E-15 | ○ |
| C-16 | 定期タスク管理：一覧表示、新規登録、編集、削除、ステータス変更、即時実行、Cron式検証、Excel出力 | E-16 | ○ |
| C-17 | タスク実行ログ：一覧表示、詳細表示、削除、クリア、Excel出力 | E-17 | ○ |
| C-18 | コード生成：テーブル一覧表示、テーブルインポート、テーブル作成、コード生成、コードプレビュー、DB同期 | E-18 | ○ |
| C-19 | ログイン：ユーザーログイン認証、記憶機能、未認証エラー処理 | E-19 | ○ |
| C-20 | ユーザー登録：新規ユーザー登録機能 | E-20 | ○ |
| C-21 | キャプチャ生成：ログイン用の画像認証コード生成 | E-21 | ○ |
| C-22 | プロファイル管理：個人情報の表示、編集、パスワード変更、アバター更新 | E-22 | ○ |
| C-23 | ファイルアップロード：単一ファイル・複数ファイルのアップロード | E-23 | ○ |
| C-24 | ファイルダウンロード：一般ファイル・リソースファイルのダウンロード | E-23 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての機能はソースコードから直接抽出されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能がControllerクラスのソースコードから直接抽出されており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 各機能の説明が実際のControllerメソッドと一致しているか確認
- [ ] カテゴリ分類が適切かどうか確認
- [ ] 抜け漏れている機能がないか、他のControllerファイルを確認
- [ ] デモ用コントローラー（DemoDialogController等）が除外されているか確認
- [ ] ツール系コントローラー（BuildController、SwaggerController、TestController）が除外されているか確認
