# 機能設計書 10-操作ログ

## 概要

本ドキュメントは、RuoYiシステムにおける操作ログ機能の設計仕様を記載する。操作ログ機能は、システム内で実行された操作の履歴を記録・照会・管理するための機能である。

### 本機能の処理概要

操作ログ機能は、システム管理者が操作ログの照会・削除・エクスポートを行うための機能を提供する。操作ログは@Logアノテーションを付与したコントローラーメソッドの実行時に自動的に記録される。

**業務上の目的・背景**：システムの監査・セキュリティ・トラブルシューティングのため、ユーザーが実行した操作の履歴を記録・保持する必要がある。本機能により、管理者は「誰が」「いつ」「どの画面で」「何をしたか」を追跡できる。

**機能の利用シーン**：
- セキュリティ監査時
- トラブルシューティング時
- ユーザー操作の追跡時
- 操作ログ一覧の出力時（Excel出力）
- 古いログの削除時

**主要な処理内容**：
1. 操作ログ一覧の検索・表示
2. 操作ログの詳細表示
3. 操作ログの削除
4. 操作ログの全件削除（クリア）
5. Excelファイルによる操作ログデータのエクスポート

**関連システム・外部連携**：本機能は単独で動作し、外部システムとの直接連携はない。ログ記録は@Logアノテーションを通じてAOPで自動実行される。

**権限による制御**：
- `monitor:operlog:view` - 操作ログ一覧画面の表示権限
- `monitor:operlog:list` - 操作ログ一覧の取得権限
- `monitor:operlog:detail` - 操作ログ詳細表示権限
- `monitor:operlog:remove` - 操作ログ削除権限
- `monitor:operlog:export` - 操作ログエクスポート権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 58 | 操作ログ一覧 | 主画面 | 操作ログ一覧の検索、表示、削除処理 |
| 59 | 操作ログ詳細 | 主画面 | 操作ログの詳細表示処理 |

## 機能種別

参照（Read） / 削除（Delete） / データ連携（Excel出力）

## 入力仕様

### 入力パラメータ

#### 操作ログ検索条件

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | String | No | 操作モジュール（部分一致） | - |
| operName | String | No | 操作者（部分一致） | - |
| businessType | Integer | No | 業務タイプ | 0:その他, 1:新増, 2:修改, 3:删除, 4:授权, 5:导出, 6:导入, 7:强退, 8:生成代码, 9:清空数据 |
| businessTypes | Integer[] | No | 業務タイプ（複数指定） | - |
| status | Integer | No | 操作状態 | 0:正常, 1:異常 |
| beginTime | String | No | 操作開始時間 | 日付形式 |
| endTime | String | No | 操作終了時間 | 日付形式 |

### 入力データソース

- 画面入力：管理者による検索条件入力
- 自動記録：@Logアノテーションによる自動ログ記録

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| operId | Long | 操作ID |
| title | String | 操作モジュール |
| businessType | Integer | 業務タイプ |
| method | String | リクエストメソッド |
| requestMethod | String | リクエスト方式（GET/POST等） |
| operatorType | Integer | 操作者種別（0:その他, 1:バックエンドユーザー, 2:モバイルユーザー） |
| operName | String | 操作者 |
| deptName | String | 部門名 |
| operUrl | String | リクエストURL |
| operIp | String | 操作IPアドレス |
| operLocation | String | 操作場所 |
| operParam | String | リクエストパラメータ |
| jsonResult | String | 戻り値 |
| status | Integer | 操作状態 |
| errorMsg | String | エラーメッセージ |
| operTime | Date | 操作時間 |
| costTime | Long | 消費時間（ミリ秒） |

### 出力先

- 画面表示：操作ログ一覧、詳細画面
- Excelファイル：エクスポート機能

## 処理フロー

### 処理シーケンス

```
1. 操作ログ一覧取得
   └─ 検索条件を受け取り、操作ログ一覧を取得
   └─ ページング処理

2. 操作ログ詳細表示
   └─ 操作IDから操作ログ詳細を取得

3. 操作ログ削除
   └─ 指定されたIDの操作ログを削除

4. 操作ログクリア
   └─ 全操作ログを削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧取得| C[検索条件取得]
    C --> D[ページング設定]
    D --> E[操作ログ一覧取得]
    E --> Z[終了]

    B -->|詳細表示| F[操作ID取得]
    F --> G[操作ログ詳細取得]
    G --> Z

    B -->|削除| H[対象ID取得]
    H --> I[操作ログ削除]
    I --> Z

    B -->|クリア| J[全操作ログ削除]
    J --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 自動記録 | @Logアノテーション付きメソッド実行時に自動的にログを記録 | コントローラーメソッド実行時 |
| BR-002 | 業務タイプ分類 | 操作内容を業務タイプで分類して記録 | ログ記録時 |
| BR-003 | エラー記録 | 例外発生時はエラーメッセージと異常ステータスを記録 | 例外発生時 |
| BR-004 | 消費時間記録 | メソッドの実行時間を記録 | ログ記録時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 操作ログ一覧取得 | sys_oper_log | SELECT | 条件に合致する操作ログ一覧を取得 |
| 操作ログ詳細取得 | sys_oper_log | SELECT | 指定IDの操作ログを取得 |
| 操作ログ削除 | sys_oper_log | DELETE | 指定IDの操作ログを削除 |
| 操作ログクリア | sys_oper_log | TRUNCATE | 全操作ログを削除 |

### テーブル別操作詳細

#### sys_oper_log

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | oper_id | 自動採番 | 主キー |
| INSERT | title | @Logのtitle属性 | 操作モジュール |
| INSERT | business_type | @LogのbusinessType属性 | 業務タイプ |
| INSERT | method | メソッド名 | リクエストメソッド |
| INSERT | request_method | GET/POST等 | リクエスト方式 |
| INSERT | operator_type | @LogのoperatorType属性 | 操作者種別 |
| INSERT | oper_name | ログインユーザー名 | 操作者 |
| INSERT | dept_name | ログインユーザーの部門名 | 部門名 |
| INSERT | oper_url | リクエストURL | リクエストURL |
| INSERT | oper_ip | クライアントIP | 操作IP |
| INSERT | oper_location | IP位置情報 | 操作場所 |
| INSERT | oper_param | リクエストパラメータ | 入力パラメータ |
| INSERT | json_result | 戻り値JSON | 戻り値 |
| INSERT | status | 0:正常, 1:異常 | 操作状態 |
| INSERT | error_msg | 例外メッセージ | エラーメッセージ |
| INSERT | oper_time | sysdate() | 操作時間 |
| INSERT | cost_time | 実行時間 | 消費時間 |
| DELETE | oper_id | 対象操作ID | 物理削除 |
| TRUNCATE | - | - | 全件削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 該当なし | 操作ログ機能自体でのエラーは基本的に発生しない | - |

### リトライ仕様

特になし。

## トランザクション仕様

- 操作ログ記録：非同期処理（別スレッド）で実行
- 操作ログ削除：単一DELETE処理
- 操作ログクリア：単一TRUNCATE処理

## パフォーマンス要件

- 操作ログ一覧取得：ページング処理により1ページあたり適切な件数を取得
- ログ記録：非同期処理により本来の処理に影響を与えない

## セキュリティ考慮事項

1. **権限制御**：Apache Shiroによるメソッドレベルの権限チェック
2. **監査目的**：本機能自体が監査ログ機能として動作

## 備考

- 操作ログ削除は物理削除となる
- クリア処理（cleanOperLog）はTRUNCATEを使用して全件削除を実行
- ログ記録はAOP（アスペクト指向プログラミング）により自動実行
- 敏感なパラメータはマスキング処理される場合がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysOperLog.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` | 操作ログエンティティ、Excelアノテーションを確認 |

**読解のコツ**: `@Excel`アノテーション（20-21, 24-25, 28, 35-36, 39-40, 43-44, 47-48, 51-52, 55-56, 59-60, 63-64, 67-68, 71-72, 75, 79-80, 83-84, 87-88行目）でExcel出力設定。`businessType`（27-29行目）で業務タイプの分類を定義。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysOperlogController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` | 各エンドポイント、権限アノテーションを確認 |

**主要処理フロー**:
- **43-51行目**: 操作ログ一覧取得（ページング）
- **53-62行目**: Excelエクスポート
- **64-71行目**: 削除処理
- **73-79行目**: 詳細表示
- **81-89行目**: クリア処理

#### Step 3: ビジネスロジック層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysOperLogServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysOperLogServiceImpl.java` | シンプルなCRUD処理を確認 |

**キーポイント**:
- **28-31行目**: ログ記録（非同期で呼び出される）
- **52-55行目**: 削除処理
- **69-76行目**: クリア処理

### プログラム呼び出し階層図

```
SysOperlogController
    │
    ├─ list() [操作ログ一覧取得]
    │      └─ ISysOperLogService.selectOperLogList()
    │
    ├─ export() [Excelエクスポート]
    │      └─ ISysOperLogService.selectOperLogList()
    │      └─ ExcelUtil.exportExcel()
    │
    ├─ detail() [操作ログ詳細表示]
    │      └─ ISysOperLogService.selectOperLogById()
    │
    ├─ remove() [操作ログ削除]
    │      └─ ISysOperLogService.deleteOperLogByIds()
    │
    └─ clean() [操作ログクリア]
           └─ ISysOperLogService.cleanOperLog()

--- ログ記録（自動）---

@Log アノテーション付きメソッド
    │
    └─ LogAspect（AOP）
           └─ AsyncManager.execute()
                  └─ ISysOperLogService.insertOperlog()
```

### データフロー図

```mermaid
flowchart LR
    subgraph Controller
        A[SysOperlogController]
    end

    subgraph Service
        B[SysOperLogServiceImpl]
    end

    subgraph Mapper
        C[SysOperLogMapper]
    end

    subgraph Database
        D[(sys_oper_log)]
    end

    subgraph AOP
        E[LogAspect]
    end

    subgraph Async
        F[AsyncManager]
    end

    A --> B
    B --> C
    C --> D
    E --> F
    F --> B
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysOperlogController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` | Controller | リクエスト受付 |
| SysOperLog.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` | Entity | 操作ログエンティティ |
| SysOperLogServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysOperLogServiceImpl.java` | Service | ビジネスロジック |
| SysOperLogMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysOperLogMapper.java` | Mapper | データアクセス |
| Log.java | `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Log.java` | Annotation | ログ記録アノテーション |
| LogAspect.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java` | AOP | ログ記録アスペクト |
