# 機能設計書 11-ログインログ

## 概要

本ドキュメントは、RuoYiシステムにおけるログインログ機能の詳細設計を記述する。ログインログ機能は、システムへのすべてのログイン試行を記録・管理し、セキュリティ監査とトラブルシューティングを支援する。

### 本機能の処理概要

ログインログ機能は、システムへのログイン試行（成功・失敗問わず）を記録し、管理者がこれらのログを検索、閲覧、エクスポート、削除できる機能を提供する。

**業務上の目的・背景**：企業システムにおいて、誰がいつどこからシステムにアクセスしたかを把握することはセキュリティ管理の基本である。不正アクセスの検知、ユーザー行動の監査、コンプライアンス対応のため、ログイン履歴を正確に記録・保管する必要がある。また、アカウントロック状態の解除機能により、パスワード入力ミスによるロックアウトからの迅速な復旧を可能にする。

**機能の利用シーン**：
- セキュリティ担当者が不正ログイン試行を調査する際
- 監査時にユーザーのアクセス履歴を確認する際
- ヘルプデスクがユーザーのログイン問題をトラブルシューティングする際
- アカウントロックされたユーザーの解除を行う際

**主要な処理内容**：
1. ログインログ一覧の検索・表示（IPアドレス、ユーザー名、ステータス、日時範囲での絞り込み）
2. ログインログのExcelエクスポート
3. 選択したログの削除
4. 全ログのクリア
5. ロックされたアカウントの解除

**関連システム・外部連携**：Shiroフレームワークのキャッシュマネージャと連携し、ログイン失敗回数のキャッシュを管理する。

**権限による制御**：
- `monitor:logininfor:view` - ログインログ画面の閲覧
- `monitor:logininfor:list` - ログインログ一覧の取得
- `monitor:logininfor:export` - Excelエクスポート
- `monitor:logininfor:remove` - ログの削除・クリア
- `monitor:logininfor:unlock` - アカウントロック解除

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | ログインログ一覧 | 主画面 | ログイン履歴一覧の検索、表示、削除、アカウントロック解除処理 |

## 機能種別

CRUD操作 / データ検索 / Excelエクスポート / キャッシュ操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| loginName | String | No | 検索対象のユーザー名 | 部分一致検索 |
| ipaddr | String | No | 検索対象のIPアドレス | 部分一致検索 |
| status | String | No | ログイン結果（0:成功、1:失敗） | 0または1 |
| params.beginTime | String | No | 検索開始日時 | yyyy-MM-dd HH:mm:ss形式 |
| params.endTime | String | No | 検索終了日時 | yyyy-MM-dd HH:mm:ss形式 |
| ids | String | No | 削除対象のID（カンマ区切り） | 数値のカンマ区切り文字列 |

### 入力データソース

- 画面入力（検索条件）
- DBテーブル sys_logininfor

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| infoId | Long | ログID |
| loginName | String | ユーザー名 |
| status | String | ログイン結果（0:成功、1:失敗） |
| ipaddr | String | IPアドレス |
| loginLocation | String | ログイン地点 |
| browser | String | ブラウザ種類 |
| os | String | OS種類 |
| msg | String | メッセージ |
| loginTime | Date | ログイン日時 |

### 出力先

- 画面表示（TableDataInfo形式）
- Excelファイル（エクスポート時）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ ユーザーが検索条件を入力し、一覧取得リクエストを送信
   └─ Controllerが検索条件を受け取り、Serviceに委譲
   └─ ServiceがMapperを呼び出し、DBから条件に合致するログを取得
   └─ ページネーション情報と共に結果を返却

2. Excelエクスポート
   └─ 検索条件に基づきログを取得
   └─ ExcelUtilを使用してExcelファイルを生成
   └─ ファイルをダウンロード用に返却

3. ログ削除
   └─ 削除対象のIDリストを受け取る
   └─ IDリストを配列に変換し、Mapperで一括削除

4. 全ログクリア
   └─ TRUNCATE TABLEでテーブルを空にする

5. アカウントロック解除
   └─ 対象ユーザー名を受け取る
   └─ SysPasswordServiceのキャッシュからログイン失敗回数を削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[検索条件受付]
    C --> D[DB検索実行]
    D --> E[結果返却]

    B -->|エクスポート| F[検索条件受付]
    F --> G[DB検索実行]
    G --> H[Excel生成]
    H --> I[ファイルダウンロード]

    B -->|削除| J[ID受付]
    J --> K[DB削除実行]
    K --> L[結果返却]

    B -->|クリア| M[TRUNCATE実行]
    M --> N[結果返却]

    B -->|ロック解除| O[ユーザー名受付]
    O --> P[キャッシュ削除]
    P --> Q[結果返却]

    E --> R[終了]
    I --> R
    L --> R
    N --> R
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-11-01 | ログ記録タイミング | ログイン成功・失敗時に自動的にログが記録される | ログイン処理実行時 |
| BR-11-02 | 削除権限 | ログ削除には`monitor:logininfor:remove`権限が必要 | 削除・クリア操作時 |
| BR-11-03 | ロック解除権限 | アカウントロック解除には`monitor:logininfor:unlock`権限が必要 | ロック解除操作時 |
| BR-11-04 | 検索の部分一致 | ユーザー名とIPアドレスは部分一致検索 | 検索実行時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | sys_logininfor | SELECT | 条件に合致するログを取得 |
| エクスポート | sys_logininfor | SELECT | 条件に合致するログを取得 |
| 削除 | sys_logininfor | DELETE | 指定IDのログを削除 |
| クリア | sys_logininfor | TRUNCATE | 全ログを削除 |

### テーブル別操作詳細

#### sys_logininfor

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | info_id, login_name, ipaddr, login_location, browser, os, status, msg, login_time | WHERE条件で絞り込み | 一覧取得 |
| DELETE | - | WHERE info_id IN (指定ID) | 選択削除 |
| TRUNCATE | - | - | 全件削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 必要な権限がない場合 | 適切な権限を付与 |
| - | DB接続エラー | データベース接続失敗時 | DB接続を確認 |

### リトライ仕様

特になし

## トランザクション仕様

- 削除操作は単一トランザクション内で実行
- クリア操作はTRUNCATEのため自動コミット

## パフォーマンス要件

- 一覧表示：1秒以内にレスポンス
- エクスポート：データ量に応じて可変（10000件で5秒以内目安）

## セキュリティ考慮事項

- Apache Shiroによる権限制御
- 操作ログの記録（@Logアノテーション）
- SQLインジェクション対策（MyBatisパラメータバインディング）

## 備考

- ログイン時のログ記録はAsyncFactory.recordLogininforを通じて非同期で実行される
- アカウントロック解除は、EhCacheに保存されたログイン失敗回数キャッシュを削除することで実現

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ログインログのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ログインログのエンティティクラス。@Excelアノテーションでエクスポート設定を確認 |

**読解のコツ**: `@Excel`アノテーションはPOI Excelエクスポートの設定を示す。`cellType`、`readConverterExp`などの属性に注目。

#### Step 2: エントリーポイントを理解する

コントローラーが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysLogininforController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java` | 各エンドポイントの定義と権限設定 |

**主要処理フロー**:
1. **38-43行目**: 画面表示処理（GET /monitor/logininfor）
2. **45-53行目**: 一覧取得処理（POST /monitor/logininfor/list）
3. **55-64行目**: Excelエクスポート処理
4. **66-73行目**: 削除処理
5. **75-83行目**: クリア処理
6. **85-93行目**: アカウントロック解除処理

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysLogininforService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysLogininforService.java` | サービスインターフェース定義 |
| 3-2 | SysLogininforServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysLogininforServiceImpl.java` | サービス実装 |

**主要処理フロー**:
- **41-44行目**: selectLogininforList - ログ一覧取得
- **53-56行目**: deleteLogininforByIds - ID指定削除（Convert.toStrArrayで文字列配列に変換）
- **62-65行目**: cleanLogininfor - 全ログクリア

#### Step 4: データアクセス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysLogininforMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysLogininforMapper.java` | Mapperインターフェース |
| 4-2 | SysLogininforMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysLogininforMapper.xml` | SQL定義 |

**主要処理フロー**:
- **24-43行目**: selectLogininforList - 動的SQLで検索条件を構築
- **45-50行目**: deleteLogininforByIds - foreach句で複数ID削除
- **52-54行目**: cleanLogininfor - TRUNCATE TABLE実行

#### Step 5: パスワードサービス（ロック解除）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | ログイン失敗回数キャッシュ管理 |

**主要処理フロー**:
- **76-79行目**: clearLoginRecordCache - ログイン失敗回数キャッシュを削除してロック解除

### プログラム呼び出し階層図

```
SysLogininforController
    │
    ├─ list()
    │      └─ ISysLogininforService.selectLogininforList()
    │             └─ SysLogininforMapper.selectLogininforList()
    │
    ├─ export()
    │      └─ ISysLogininforService.selectLogininforList()
    │      └─ ExcelUtil.exportExcel()
    │
    ├─ remove()
    │      └─ ISysLogininforService.deleteLogininforByIds()
    │             └─ SysLogininforMapper.deleteLogininforByIds()
    │
    ├─ clean()
    │      └─ ISysLogininforService.cleanLogininfor()
    │             └─ SysLogininforMapper.cleanLogininfor()
    │
    └─ unlock()
           └─ SysPasswordService.clearLoginRecordCache()
                  └─ loginRecordCache.remove()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件     ───▶ Controller         ───▶ TableDataInfo
(loginName,       ↓                        (rows, total)
 ipaddr,          Service
 status,          ↓
 日時範囲)        Mapper
                  ↓
                  sys_logininfor

削除ID      ───▶ Controller         ───▶ AjaxResult
                  ↓                        (成功/失敗)
                  Service
                  ↓
                  Mapper (DELETE)

ユーザー名   ───▶ Controller         ───▶ AjaxResult
                  ↓                        (成功)
                  SysPasswordService
                  ↓
                  loginRecordCache
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysLogininforController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/` | コントローラー | HTTPリクエストのハンドリング |
| SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/` | エンティティ | ログインログのデータモデル |
| ISysLogininforService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/` | インターフェース | サービス層の契約定義 |
| SysLogininforServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/` | サービス実装 | ビジネスロジック |
| SysLogininforMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/` | Mapper | データアクセス層インターフェース |
| SysLogininforMapper.xml | `ruoyi-system/src/main/resources/mapper/system/` | MyBatis XML | SQL定義 |
| SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/` | サービス | パスワード検証・キャッシュ管理 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/` | ユーティリティ | Excelエクスポート処理 |
