# 機能設計書 13-サーバー監視

## 概要

本ドキュメントは、RuoYiシステムにおけるサーバー監視機能の詳細設計を記述する。サーバー監視機能は、アプリケーションが稼働しているサーバーのハードウェア・ソフトウェアリソース情報をリアルタイムで取得・表示する機能を提供する。

### 本機能の処理概要

サーバー監視機能は、OSHIライブラリを使用してサーバーのCPU、メモリ、JVM、ディスク、およびシステム情報を収集し、管理者向けのダッシュボードに表示する機能を提供する。

**業務上の目的・背景**：システム運用において、サーバーリソースの監視は安定稼働を維持するための重要な業務である。CPU使用率やメモリ使用量の急激な上昇を早期に検知することで、システム障害を未然に防ぐことができる。また、JVMのヒープメモリ使用状況を把握することで、Javaアプリケーションのメモリリークやパフォーマンス問題を特定できる。

**機能の利用シーン**：
- システム管理者が日常的にサーバー状態を確認する際
- パフォーマンス問題の調査・分析時
- 容量計画（キャパシティプランニング）のためのリソース使用状況確認時
- システム障害発生時の原因調査時

**主要な処理内容**：
1. CPU情報の取得（コア数、使用率、システム使用率、ユーザー使用率、アイドル率）
2. メモリ情報の取得（総容量、使用量、空き容量、使用率）
3. JVM情報の取得（総メモリ、最大メモリ、空きメモリ、Javaバージョン、Javaホームパス）
4. システム情報の取得（コンピュータ名、IP、OS名、アーキテクチャ、作業ディレクトリ）
5. ディスク情報の取得（各マウントポイントの総容量、使用量、空き容量、使用率）

**関連システム・外部連携**：OSHIライブラリ（Operating System and Hardware Information）を使用してOS・ハードウェア情報を取得する。

**権限による制御**：
- `monitor:server:view` - サーバー監視画面の閲覧

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | サーバー監視 | 主画面 | CPU、メモリ、JVM、ディスク情報の表示処理 |

## 機能種別

システム情報取得 / 表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | パラメータなし | - |

### 入力データソース

- OSHIライブラリ経由でOSから取得
- Java Runtime経由でJVM情報を取得
- System.getProperties()経由でシステムプロパティを取得

## 出力仕様

### 出力データ

#### CPU情報（Cpu）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cpuNum | int | CPU論理コア数 |
| total | long | CPU総時間 |
| sys | long | システム使用時間 |
| used | long | ユーザー使用時間 |
| wait | long | IO待ち時間 |
| free | long | アイドル時間 |

#### メモリ情報（Mem）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| total | long | 総メモリ容量（バイト） |
| used | long | 使用中メモリ容量（バイト） |
| free | long | 空きメモリ容量（バイト） |

#### JVM情報（Jvm）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| total | long | JVM総メモリ（バイト） |
| max | long | JVM最大メモリ（バイト） |
| free | long | JVM空きメモリ（バイト） |
| version | String | Javaバージョン |
| home | String | Javaホームパス |

#### システム情報（Sys）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| computerName | String | コンピュータ名 |
| computerIp | String | IPアドレス |
| osName | String | OS名 |
| osArch | String | アーキテクチャ |
| userDir | String | 作業ディレクトリ |

#### ディスク情報（SysFile）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| dirName | String | マウントポイント |
| sysTypeName | String | ファイルシステムタイプ |
| typeName | String | ボリューム名 |
| total | String | 総容量（フォーマット済み） |
| free | String | 空き容量（フォーマット済み） |
| used | String | 使用量（フォーマット済み） |
| usage | double | 使用率（パーセント） |

### 出力先

- 画面表示（ModelMapにserverオブジェクトとして設定）

## 処理フロー

### 処理シーケンス

```
1. 画面表示リクエスト
   └─ ユーザーがサーバー監視画面にアクセス

2. サーバー情報収集
   └─ Serverオブジェクトを生成
   └─ copyTo()メソッドを呼び出し
      └─ OSHI SystemInfoを初期化
      └─ CPU情報を収集（1秒間のサンプリング）
      └─ メモリ情報を収集
      └─ システム情報を収集
      └─ JVM情報を収集
      └─ ディスク情報を収集

3. 結果返却
   └─ ModelMapにserverオブジェクトを設定
   └─ ビューテンプレートを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[画面アクセス]
    B --> C[Serverオブジェクト生成]
    C --> D[OSHI SystemInfo初期化]
    D --> E[CPU情報収集]
    E --> F[1秒待機]
    F --> G[CPU使用率計算]
    G --> H[メモリ情報収集]
    H --> I[システム情報収集]
    I --> J[JVM情報収集]
    J --> K[ディスク情報収集]
    K --> L[ModelMapに設定]
    L --> M[ビュー返却]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-13-01 | CPUサンプリング | CPU使用率は1秒間のサンプリングで算出 | CPU情報収集時 |
| BR-13-02 | 容量フォーマット | ファイルサイズはGB/MB/KB/Bに自動変換 | ディスク情報表示時 |
| BR-13-03 | 小数精度 | 使用率は小数第4位まで計算、100倍してパーセント表示 | 使用率計算時 |

### 計算ロジック

#### CPU使用率計算
```
使用率 = (user + nice + sys + irq + softirq + steal) / (user + nice + sys + idle + iowait + irq + softirq + steal) * 100
```

#### メモリ使用率計算
```
使用量 = 総容量 - 空き容量
使用率 = 使用量 / 総容量 * 100
```

#### ディスク使用率計算
```
使用量 = 総容量 - 空き容量
使用率 = (使用量 / 総容量) * 100（小数第4位まで）
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | サーバー情報取得失敗時 | エラーページ表示 |
| - | 権限エラー | 必要な権限がない場合 | 適切な権限を付与 |

### リトライ仕様

特になし（画面リフレッシュで再取得可能）

## トランザクション仕様

本機能はデータベースを使用しないため、トランザクション管理は不要。

## パフォーマンス要件

- 画面表示：2秒以内にレスポンス（CPU情報収集に1秒のサンプリング時間を含む）
- OSHI_WAIT_SECOND = 1000ms（CPU使用率算出のための待機時間）

## セキュリティ考慮事項

- Apache Shiroによる権限制御
- サーバー内部情報の表示のため、管理者権限を持つユーザーのみアクセス可能とする

## 備考

- OSHIライブラリは、oshi-core依存関係として追加されている
- CPU情報収集時に1秒間の待機が発生するため、画面表示に若干の遅延がある
- ディスク情報は全マウントポイントの情報を取得する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、サーバー情報のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Server.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java` | メインのサーバー情報クラス。CPU、メモリ、JVM、システム、ディスク情報を保持 |
| 1-2 | Cpu.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Cpu.java` | CPU情報のデータモデル |
| 1-3 | Mem.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Mem.java` | メモリ情報のデータモデル |
| 1-4 | Jvm.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Jvm.java` | JVM情報のデータモデル |
| 1-5 | Sys.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Sys.java` | システム情報のデータモデル |
| 1-6 | SysFile.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/SysFile.java` | ディスク情報のデータモデル |

**読解のコツ**: `Server.java`の`copyTo()`メソッドがすべての情報収集ロジックを含む。OSHIライブラリの使用方法に注目。

#### Step 2: エントリーポイントを理解する

コントローラーが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ServerController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/ServerController.java` | 非常にシンプルなコントローラー。Serverオブジェクト生成と情報収集を行う |

**主要処理フロー**:
1. **22-30行目**: 画面表示処理（GET /monitor/server）
2. **26-27行目**: Serverオブジェクト生成とcopyTo()呼び出し
3. **28行目**: ModelMapにserverオブジェクトを設定

#### Step 3: 情報収集ロジックを理解する

Server.javaのcopyTo()メソッドを詳細に理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Server.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java` | copyTo()メソッドとprivateメソッド群 |

**主要処理フロー**:
- **109-123行目**: copyTo() - メイン情報収集処理
- **128-149行目**: setCpuInfo() - CPU情報収集（1秒サンプリング）
- **154-159行目**: setMemInfo() - メモリ情報収集
- **164-172行目**: setSysInfo() - システム情報収集
- **177-185行目**: setJvmInfo() - JVM情報収集
- **190-209行目**: setSysFiles() - ディスク情報収集

### プログラム呼び出し階層図

```
ServerController
    │
    └─ server()
           ├─ new Server()
           │
           └─ Server.copyTo()
                  ├─ OSHI SystemInfo
                  │      ├─ getHardware()
                  │      │      ├─ getProcessor()
                  │      │      └─ getMemory()
                  │      │
                  │      └─ getOperatingSystem()
                  │             └─ getFileSystem()
                  │
                  ├─ setCpuInfo()
                  │      └─ processor.getSystemCpuLoadTicks()
                  │
                  ├─ setMemInfo()
                  │      └─ memory.getTotal(), memory.getAvailable()
                  │
                  ├─ setSysInfo()
                  │      └─ System.getProperties()
                  │      └─ IpUtils.getHostName(), getHostIp()
                  │
                  ├─ setJvmInfo()
                  │      └─ Runtime.getRuntime()
                  │      └─ System.getProperties()
                  │
                  └─ setSysFiles()
                         └─ fileSystem.getFileStores()
```

### データフロー図

```
[入力]               [処理]                    [出力]

画面アクセス  ───▶ Controller         ───▶ ModelMap
                   ↓                        (server)
                   new Server()
                   ↓
                   copyTo()
                   ↓
              ┌────┴────┐
              ↓    ↓    ↓
         OSHI  JVM  System
              ↓    ↓    ↓
              └────┬────┘
                   ↓
              Server Object
                   │
                   ├─ Cpu (cpuNum, usage...)
                   ├─ Mem (total, used, free)
                   ├─ Jvm (total, max, free, version)
                   ├─ Sys (computerName, ip, os)
                   └─ List<SysFile> (mount, size, usage)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ServerController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/` | コントローラー | HTTPリクエストのハンドリング |
| Server.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/` | ドメイン | サーバー情報の収集・保持 |
| Cpu.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/` | ドメイン | CPU情報モデル |
| Mem.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/` | ドメイン | メモリ情報モデル |
| Jvm.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/` | ドメイン | JVM情報モデル |
| Sys.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/` | ドメイン | システム情報モデル |
| SysFile.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/` | ドメイン | ディスク情報モデル |
| IpUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/` | ユーティリティ | ホスト名・IP取得 |
| Arith.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/` | ユーティリティ | 精密計算（使用率計算） |
