# 機能設計書 14-キャッシュ監視

## 概要

本ドキュメントは、RuoYiシステムにおけるキャッシュ監視機能の詳細設計を記述する。キャッシュ監視機能は、EhCacheで管理されているキャッシュの一覧表示、キー取得、値確認、およびキャッシュクリア機能を提供する。

### 本機能の処理概要

キャッシュ監視機能は、システム内で使用されているEhCacheのキャッシュ領域を可視化し、管理者がキャッシュの状態を確認・操作できる機能を提供する。

**業務上の目的・背景**：Webアプリケーションにおいてキャッシュはパフォーマンス向上に不可欠であるが、適切に管理されないとデータの不整合や古いデータの参照が発生する。本機能により、管理者はキャッシュの状態を把握し、必要に応じて特定のキャッシュをクリアすることで、データの整合性を維持できる。また、トラブルシューティング時にキャッシュの内容を確認することで、問題の原因特定を効率化できる。

**機能の利用シーン**：
- システム設定変更後にキャッシュをクリアする際
- キャッシュに起因するデータ不整合問題を調査する際
- キャッシュの使用状況を確認する際
- 全キャッシュをクリアしてシステムをリフレッシュする際

**主要な処理内容**：
1. キャッシュ名一覧の取得・表示
2. 指定キャッシュのキー一覧取得
3. 指定キャッシュ・キーの値取得
4. 指定キャッシュの全クリア
5. 指定キャッシュ・キーの個別クリア
6. 全キャッシュの一括クリア

**関連システム・外部連携**：EhCacheフレームワークと連携してキャッシュ操作を行う。

**権限による制御**：
- `monitor:cache:view` - キャッシュ監視画面のすべての操作（閲覧、キー取得、値取得、クリア）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | キャッシュ監視 | 主画面 | キャッシュ一覧表示、キー取得、値取得、クリア処理 |

## 機能種別

キャッシュ操作 / データ表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| cacheName | String | Yes（キー取得/値取得/クリア時） | キャッシュ名 | 存在するキャッシュ名 |
| cacheKey | String | Yes（値取得/キークリア時） | キャッシュキー | 存在するキー |

### 入力データソース

- EhCacheマネージャ

## 出力仕様

### 出力データ

#### キャッシュ名一覧

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cacheNames | String[] | キャッシュ名の配列（SYS_AUTH_CACHEを除く） |

#### キー一覧

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cacheName | String | キャッシュ名 |
| cacheKeys | Set<String> | キー一覧（ソート済み） |

#### キャッシュ値

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cacheName | String | キャッシュ名 |
| cacheKey | String | キャッシュキー |
| cacheValue | Object | キャッシュ値 |

### 出力先

- 画面表示（Thymeleafフラグメント）

## 処理フロー

### 処理シーケンス

```
1. 初期表示
   └─ 画面アクセス時にキャッシュ名一覧を取得
   └─ SYS_AUTH_CACHEを除外してModelMapに設定
   └─ 画面を表示

2. キー一覧取得
   └─ キャッシュ名を受け取る
   └─ CacheUtils経由で該当キャッシュを取得
   └─ キー一覧をTreeSetでソートして返却
   └─ フラグメントHTMLを返却

3. 値取得
   └─ キャッシュ名とキーを受け取る
   └─ CacheUtils.get()で値を取得
   └─ フラグメントHTMLを返却

4. キャッシュクリア（名前指定）
   └─ キャッシュ名を受け取る
   └─ CacheUtils.removeAll()で全キーを削除
   └─ 成功レスポンスを返却

5. キャッシュクリア（キー指定）
   └─ キャッシュ名とキーを受け取る
   └─ CacheUtils.remove()で特定キーを削除
   └─ 成功レスポンスを返却

6. 全キャッシュクリア
   └─ キャッシュ名一覧を取得
   └─ 各キャッシュに対してremoveAll()を実行
   └─ 成功レスポンスを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|初期表示| C[キャッシュ名一覧取得]
    C --> D[SYS_AUTH_CACHE除外]
    D --> E[画面表示]

    B -->|キー一覧取得| F[キャッシュ名受付]
    F --> G[Cache.keys取得]
    G --> H[TreeSetでソート]
    H --> I[フラグメント返却]

    B -->|値取得| J[キャッシュ名/キー受付]
    J --> K[CacheUtils.get]
    K --> L[フラグメント返却]

    B -->|名前クリア| M[キャッシュ名受付]
    M --> N[CacheUtils.removeAll]
    N --> O[成功返却]

    B -->|キークリア| P[キャッシュ名/キー受付]
    P --> Q[CacheUtils.remove]
    Q --> R[成功返却]

    B -->|全クリア| S[キャッシュ名一覧取得]
    S --> T[各キャッシュremoveAll]
    T --> U[成功返却]

    E --> V[終了]
    I --> V
    L --> V
    O --> V
    R --> V
    U --> V
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-14-01 | 認証キャッシュ除外 | SYS_AUTH_CACHEは一覧から除外する | キャッシュ名一覧取得時 |
| BR-14-02 | キーソート | キー一覧はTreeSetでアルファベット順にソート | キー一覧取得時 |
| BR-14-03 | 単一権限 | すべての操作がmonitor:cache:view権限で可能 | 全操作 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを直接操作しない。ただし、キャッシュクリアによって間接的にDB再読み込みが発生する可能性がある。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 必要な権限がない場合 | 適切な権限を付与 |
| - | NullPointerException | 存在しないキャッシュ名/キーを指定した場合 | 画面をリフレッシュ |

### リトライ仕様

特になし

## トランザクション仕様

本機能はデータベースを使用しないため、トランザクション管理は不要。

## パフォーマンス要件

- キャッシュ名一覧取得：100ms以内
- キー一覧取得：キー数に応じて可変（1000キーで1秒以内目安）
- 値取得：100ms以内
- キャッシュクリア：100ms以内

## セキュリティ考慮事項

- Apache Shiroによる権限制御
- SYS_AUTH_CACHEの除外により、認証情報への直接アクセスを防止
- キャッシュ値の表示により機密情報が露出する可能性があるため、アクセス制限が重要

## 備考

- CacheUtilsクラスを通じてEhCacheを操作する
- 画面更新はThymeleafフラグメントを使用した部分更新
- キャッシュクリア後は関連するデータの再読み込みが発生する可能性がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ユーティリティクラスを理解する

まず、キャッシュ操作の基盤となるユーティリティクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CacheUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/CacheUtils.java` | EhCacheへのアクセスを提供するユーティリティ。getCacheNames, getCache, get, remove, removeAllメソッド |

**読解のコツ**: CacheUtilsはSpringUtilsを通じてEhCacheManagerを取得し、静的メソッドでキャッシュ操作を提供する。

#### Step 2: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CacheService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/CacheService.java` | キャッシュ操作のサービスクラス |

**主要処理フロー**:
- **23-27行目**: getCacheNames() - キャッシュ名一覧取得（SYS_AUTH_CACHE除外）
- **35-38行目**: getCacheKeys() - キー一覧取得（TreeSetでソート）
- **47-50行目**: getCacheValue() - 値取得
- **57-60行目**: clearCacheName() - キャッシュ全クリア
- **68-71行目**: clearCacheKey() - キー個別クリア
- **76-83行目**: clearAll() - 全キャッシュクリア

#### Step 3: エントリーポイントを理解する

コントローラーが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CacheController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/CacheController.java` | 各エンドポイントの定義と権限設定 |

**主要処理フロー**:
- **29-35行目**: cache() - 初期表示（GET /monitor/cache）
- **37-43行目**: getCacheNames() - キャッシュ名一覧フラグメント返却
- **45-52行目**: getCacheKeys() - キー一覧フラグメント返却
- **54-62行目**: getCacheValue() - 値表示フラグメント返却
- **64-71行目**: clearCacheName() - キャッシュ名指定クリア
- **73-80行目**: clearCacheKey() - キー指定クリア
- **82-89行目**: clearAll() - 全クリア

### プログラム呼び出し階層図

```
CacheController
    │
    ├─ cache()
    │      └─ CacheService.getCacheNames()
    │             └─ CacheUtils.getCacheNames()
    │                    └─ EhCacheManager.getCacheNames()
    │
    ├─ getCacheNames()
    │      └─ CacheService.getCacheNames()
    │
    ├─ getCacheKeys()
    │      └─ CacheService.getCacheKeys()
    │             └─ CacheUtils.getCache()
    │                    └─ Cache.keys()
    │
    ├─ getCacheValue()
    │      └─ CacheService.getCacheValue()
    │             └─ CacheUtils.get()
    │
    ├─ clearCacheName()
    │      └─ CacheService.clearCacheName()
    │             └─ CacheUtils.removeAll()
    │
    ├─ clearCacheKey()
    │      └─ CacheService.clearCacheKey()
    │             └─ CacheUtils.remove()
    │
    └─ clearAll()
           └─ CacheService.clearAll()
                  └─ [各キャッシュに対して]
                         └─ CacheUtils.removeAll()
```

### データフロー図

```
[入力]               [処理]                    [出力]

画面アクセス  ───▶ Controller         ───▶ ModelMap
                   ↓                        (cacheNames)
                   CacheService
                   ↓
                   CacheUtils
                   ↓
                   EhCacheManager

キャッシュ名  ───▶ Controller         ───▶ Fragment HTML
                   ↓                        (cacheKeys)
                   CacheService.getCacheKeys
                   ↓
                   Cache.keys()
                   ↓
                   TreeSet (ソート)

キャッシュ名  ───▶ Controller         ───▶ AjaxResult
+ キー             ↓                        (success)
                   CacheService.clearCacheKey
                   ↓
                   CacheUtils.remove
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CacheController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/` | コントローラー | HTTPリクエストのハンドリング |
| CacheService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/` | サービス | キャッシュ操作ロジック |
| CacheUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/` | ユーティリティ | EhCacheへのアクセス |
| Constants.java | `ruoyi-common/src/main/java/com/ruoyi/common/constant/` | 定数 | SYS_AUTH_CACHE定義 |
