# 機能設計書 15-データ監視

## 概要

本ドキュメントは、RuoYiシステムにおけるデータ監視機能の詳細設計を記述する。データ監視機能は、Druidデータソース監視画面へのリダイレクト機能を提供し、データベース接続プールの状態を可視化する。

### 本機能の処理概要

データ監視機能は、Alibaba Druidのビルトイン監視機能へのアクセスを提供するシンプルなリダイレクト機能である。Druidの監視画面では、SQLの実行状況、接続プールの状態、スロークエリなどを確認できる。

**業務上の目的・背景**：データベースはWebアプリケーションの重要なボトルネックポイントである。Druidの監視機能を活用することで、SQLの実行時間、実行回数、接続プールの使用状況などを把握し、パフォーマンス問題の早期発見と対処が可能になる。スロークエリの特定やSQL最適化のための情報収集に役立つ。

**機能の利用シーン**：
- データベースパフォーマンス問題の調査時
- スロークエリの特定と分析時
- 接続プールの使用状況確認時
- SQL実行統計の確認時

**主要な処理内容**：
1. Druid監視画面（/druid/index.html）へのリダイレクト

**関連システム・外部連携**：Alibaba Druidデータソースの監視機能と連携。

**権限による制御**：
- `monitor:data:view` - データ監視画面の閲覧

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | データ監視 | 主画面 | Druid監視画面へのリダイレクト |

## 機能種別

リダイレクト処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | パラメータなし | - |

### 入力データソース

特になし

## 出力仕様

### 出力データ

特になし（リダイレクト処理のみ）

### 出力先

- /druid/index.html へのリダイレクト

## 処理フロー

### 処理シーケンス

```
1. 画面アクセス
   └─ ユーザーがデータ監視画面にアクセス
   └─ 権限チェック（monitor:data:view）
   └─ /druid/index.htmlへリダイレクト
   └─ Druidビルトイン監視画面が表示される
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[/monitor/dataアクセス]
    B --> C{権限チェック}
    C -->|権限なし| D[権限エラー]
    C -->|権限あり| E[/druid/index.htmlへリダイレクト]
    E --> F[Druid監視画面表示]
    D --> G[終了]
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-15-01 | リダイレクト先 | Druidの/druid/index.htmlにリダイレクト | 画面アクセス時 |
| BR-15-02 | 権限必須 | monitor:data:view権限がないとアクセス不可 | 画面アクセス時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを直接操作しない。Druid監視画面でDBの統計情報を表示する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 必要な権限がない場合 | 適切な権限を付与 |

### リトライ仕様

特になし

## トランザクション仕様

本機能はデータベースを使用しないため、トランザクション管理は不要。

## パフォーマンス要件

- リダイレクト処理：即時（100ms以内）

## セキュリティ考慮事項

- Apache Shiroによる権限制御
- Druid監視画面はSQL統計などの機密情報を含むため、管理者権限を持つユーザーのみアクセス可能とする
- Druid自体の認証設定（DruidConfig）も確認が必要

## 備考

- Druidの監視機能は別途DruidConfigで設定されている
- Druidの監視画面では、SQL実行統計、WebURI統計、Session統計、Spring統計などが確認可能
- /druidパスへのアクセス制御はDruidConfig内のStatViewServletで設定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラーが処理の起点となる。非常にシンプルな構造。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DruidController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/DruidController.java` | リダイレクト処理のみを行うシンプルなコントローラー |

**主要処理フロー**:
- **20-25行目**: index() - /druid/index.htmlへのリダイレクト
- **18行目**: prefix = "/druid" - リダイレクト先のベースパス

#### Step 2: Druid設定を理解する

Druidデータソースの設定と監視機能の設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DruidConfig.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/config/DruidConfig.java` | Druidデータソースの設定。StatViewServletとWebStatFilterの設定 |
| 2-2 | DruidProperties.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/config/properties/DruidProperties.java` | Druidプロパティの設定クラス |

### プログラム呼び出し階層図

```
DruidController
    │
    └─ index()
           └─ redirect("/druid/index.html")
                  │
                  └─ Druid StatViewServlet
                         ├─ SQL統計
                         ├─ WebURI統計
                         ├─ Session統計
                         └─ 接続プール統計
```

### データフロー図

```
[入力]               [処理]                    [出力]

画面アクセス  ───▶ Controller         ───▶ リダイレクト
/monitor/data        ↓                        /druid/index.html
                   redirect()
                     ↓
                   Druid StatViewServlet
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DruidController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/` | コントローラー | リダイレクト処理 |
| DruidConfig.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/config/` | 設定 | Druidデータソース設定 |
| DruidProperties.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/config/properties/` | 設定 | Druidプロパティ |
