# 機能設計書 17-タスク実行ログ

## 概要

本ドキュメントは、RuoYiシステムにおけるタスク実行ログ機能の詳細設計を記述する。タスク実行ログ機能は、定期タスク（Quartzジョブ）の実行履歴を記録・表示し、実行結果の確認と問題分析を支援する。

### 本機能の処理概要

タスク実行ログ機能は、定期タスクの各実行結果（成功/失敗）、実行時間、例外情報などを記録し、管理者がタスクの実行状況を確認・分析できる機能を提供する。

**業務上の目的・背景**：定期タスクの実行状況を把握することは、システムの安定稼働を維持するために不可欠である。タスクの実行失敗を早期に検知し、原因を特定することで、迅速な対応が可能になる。また、実行時間の推移を確認することで、パフォーマンス劣化の兆候を把握できる。

**機能の利用シーン**：
- 定期タスクの実行結果を確認する際
- タスク実行失敗の原因を調査する際
- タスクの実行パフォーマンスを分析する際
- 古い実行ログをクリアする際

**主要な処理内容**：
1. タスク実行ログ一覧の表示・検索
2. 実行ログの詳細表示（例外情報含む）
3. 選択したログの削除
4. 全ログのクリア
5. ログのExcelエクスポート

**関連システム・外部連携**：Quartzジョブ実行時にAbstractQuartzJobクラスから自動的にログが記録される。

**権限による制御**：
- `monitor:job:view` - タスク実行ログ画面の閲覧
- `monitor:job:list` - ログ一覧の取得
- `monitor:job:detail` - ログ詳細の閲覧
- `monitor:job:remove` - ログの削除・クリア
- `monitor:job:export` - Excelエクスポート

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | 定時任務ログ | 主画面 | タスク実行ログ一覧表示、検索、削除処理 |

## 機能種別

CRUD操作 / Excelエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| jobName | String | No | 検索対象のタスク名 | 部分一致検索 |
| jobGroup | String | No | 検索対象のタスクグループ | 部分一致検索 |
| status | String | No | 実行結果（0:成功、1:失敗） | 0または1 |
| invokeTarget | String | No | 呼び出し先 | 部分一致検索 |
| params.beginTime | String | No | 検索開始日時 | 日時形式 |
| params.endTime | String | No | 検索終了日時 | 日時形式 |
| ids | String | No | 削除対象のID（カンマ区切り） | 数値のカンマ区切り文字列 |
| jobId | Long | No | 特定タスクのログ絞り込み | タスクID |

### 入力データソース

- 画面入力（検索条件）
- DBテーブル sys_job_log

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| jobLogId | Long | ログID |
| jobName | String | タスク名 |
| jobGroup | String | タスクグループ |
| invokeTarget | String | 呼び出し先 |
| jobMessage | String | ログメッセージ |
| status | String | 実行結果（0:成功、1:失敗） |
| exceptionInfo | String | 例外情報 |
| startTime | Date | 開始時刻 |
| endTime | Date | 終了時刻 |

### 出力先

- 画面表示（TableDataInfo形式）
- Excelファイル（エクスポート時）

## 処理フロー

### 処理シーケンス

```
1. ログ一覧表示
   └─ 検索条件を受け取る
   └─ jobIdが指定されている場合、該当タスクのログに絞り込み
   └─ DBから条件に合致するログを取得
   └─ ページネーション適用
   └─ 結果を返却

2. ログ詳細表示
   └─ ログIDを受け取る
   └─ DBからログ詳細を取得
   └─ 詳細画面に表示

3. ログ削除
   └─ 削除対象のIDリストを受け取る
   └─ IDリストを配列に変換し、Mapperで一括削除

4. 全ログクリア
   └─ TRUNCATE TABLEでテーブルを空にする

5. Excelエクスポート
   └─ 検索条件に基づきログを取得
   └─ ExcelUtilを使用してExcelファイルを生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[検索条件受付]
    C --> D{jobId指定?}
    D -->|Yes| E[タスク情報取得]
    E --> F[DB検索]
    D -->|No| F
    F --> G[結果返却]

    B -->|詳細表示| H[ログID受付]
    H --> I[DB検索]
    I --> J[詳細表示]

    B -->|削除| K[ID受付]
    K --> L[DB削除]
    L --> M[結果返却]

    B -->|クリア| N[TRUNCATE実行]
    N --> O[結果返却]

    B -->|エクスポート| P[検索条件受付]
    P --> Q[DB検索]
    Q --> R[Excel生成]
    R --> S[ダウンロード]

    G --> T[終了]
    J --> T
    M --> T
    O --> T
    S --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | 自動ログ記録 | タスク実行時に自動的にログが記録される | タスク実行時 |
| BR-17-02 | 例外情報記録 | タスク実行失敗時は例外情報を記録 | 実行失敗時 |
| BR-17-03 | 実行時間記録 | 開始時刻と終了時刻を記録 | タスク実行時 |
| BR-17-04 | タスク連携 | ログ画面からタスク詳細を参照可能 | ログ一覧表示時 |

### 計算ロジック

#### 実行時間の算出

```
実行時間 = endTime - startTime
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | sys_job_log | SELECT | 条件に合致するログを取得 |
| 詳細取得 | sys_job_log | SELECT | ID指定でログを取得 |
| エクスポート | sys_job_log | SELECT | 条件に合致するログを取得 |
| 削除 | sys_job_log | DELETE | 指定IDのログを削除 |
| クリア | sys_job_log | TRUNCATE | 全ログを削除 |
| 連携取得 | sys_job | SELECT | タスク情報を取得（jobId指定時） |

### テーブル別操作詳細

#### sys_job_log

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | job_log_id, job_name, job_group, invoke_target, job_message, status, exception_info, start_time, end_time, create_time | WHERE条件で絞り込み | 一覧取得 |
| DELETE | - | WHERE job_log_id IN (指定ID) | 選択削除 |
| TRUNCATE | - | - | 全件削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 必要な権限がない場合 | 適切な権限を付与 |
| - | DB接続エラー | データベース接続失敗時 | DB接続を確認 |

### リトライ仕様

特になし

## トランザクション仕様

- 削除操作は単一トランザクション内で実行
- クリア操作はTRUNCATEのため自動コミット

## パフォーマンス要件

- 一覧表示：1秒以内にレスポンス
- 詳細表示：500ms以内にレスポンス
- エクスポート：データ量に応じて可変

## セキュリティ考慮事項

- Apache Shiroによる権限制御
- 操作ログの記録（@Logアノテーション）
- 例外情報にはセンシティブな情報が含まれる可能性があるため、アクセス制限が重要

## 備考

- ログはAbstractQuartzJob.execute()内で自動的に記録される
- 実行ログはタスク管理画面（定期タスク管理）からも参照可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、タスク実行ログのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysJobLog.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` | タスク実行ログのエンティティクラス。@Excelアノテーションでエクスポート設定を確認 |

**読解のコツ**: startTime、endTimeで実行時間を計算可能。exceptionInfoは実行失敗時の例外スタックトレースを保持。

#### Step 2: エントリーポイントを理解する

コントローラーが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysJobLogController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java` | 各エンドポイントの定義と権限設定 |

**主要処理フロー**:
- **43-53行目**: jobLog() - ログ一覧画面表示（jobId指定時はタスク情報も取得）
- **55-63行目**: list() - ログ一覧取得
- **65-74行目**: export() - Excelエクスポート
- **76-83行目**: remove() - ログ削除
- **85-92行目**: detail() - ログ詳細表示
- **94-102行目**: clean() - 全ログクリア

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysJobLogService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobLogService.java` | サービスインターフェース定義 |
| 3-2 | SysJobLogServiceImpl.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobLogServiceImpl.java` | サービス実装 |

**主要処理フロー**:
- **29-32行目**: selectJobLogList - ログ一覧取得
- **41-44行目**: selectJobLogById - ID指定取得
- **51-54行目**: addJobLog - ログ追加（タスク実行時に呼ばれる）
- **64-67行目**: deleteJobLogByIds - ID指定削除
- **84-87行目**: cleanJobLog - 全クリア

#### Step 4: ログ記録処理を理解する

タスク実行時にログがどのように記録されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AbstractQuartzJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/AbstractQuartzJob.java` | タスク実行時のログ記録ロジック |

### プログラム呼び出し階層図

```
SysJobLogController
    │
    ├─ jobLog()
    │      ├─ ISysJobService.selectJobById() [jobId指定時]
    │      └─ 画面遷移（monitor/job/jobLog）
    │
    ├─ list()
    │      └─ ISysJobLogService.selectJobLogList()
    │             └─ SysJobLogMapper.selectJobLogList()
    │
    ├─ export()
    │      └─ ISysJobLogService.selectJobLogList()
    │      └─ ExcelUtil.exportExcel()
    │
    ├─ remove()
    │      └─ ISysJobLogService.deleteJobLogByIds()
    │             └─ SysJobLogMapper.deleteJobLogByIds()
    │
    ├─ detail()
    │      └─ ISysJobLogService.selectJobLogById()
    │             └─ SysJobLogMapper.selectJobLogById()
    │
    └─ clean()
           └─ ISysJobLogService.cleanJobLog()
                  └─ SysJobLogMapper.cleanJobLog()

[タスク実行時]
AbstractQuartzJob.execute()
    │
    └─ ISysJobLogService.addJobLog()
           └─ SysJobLogMapper.insertJobLog()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件     ───▶ Controller         ───▶ TableDataInfo
(jobName,          ↓                        (rows, total)
 jobGroup,         Service
 status)           ↓
                   Mapper
                   ↓
                   sys_job_log

[タスク実行時]

SysJob       ───▶ AbstractQuartzJob  ───▶ sys_job_log
                   ↓                        (INSERT)
                   タスク実行
                   ↓
                   結果記録
                   ↓
                   ISysJobLogService.addJobLog()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysJobLogController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/` | コントローラー | HTTPリクエストのハンドリング |
| SysJobLog.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/` | エンティティ | タスク実行ログのデータモデル |
| ISysJobLogService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/` | インターフェース | サービス層の契約定義 |
| SysJobLogServiceImpl.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/` | サービス実装 | ビジネスロジック |
| SysJobLogMapper.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/mapper/` | Mapper | データアクセス層インターフェース |
| SysJobLogMapper.xml | `ruoyi-quartz/src/main/resources/mapper/quartz/` | MyBatis XML | SQL定義 |
| AbstractQuartzJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/` | 抽象クラス | タスク実行・ログ記録 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/` | ユーティリティ | Excelエクスポート処理 |
