# 機能設計書 5-役職管理

## 概要

本ドキュメントは、RuoYiシステムにおける役職管理機能の設計仕様を記載する。役職管理機能は、組織内の役職（岗位）を管理する機能である。

### 本機能の処理概要

役職管理機能は、システム管理者が役職の作成・変更・削除・照会を行うための機能を提供する。役職はユーザーに割り当てられ、ユーザーの職責を示すために使用される。

**業務上の目的・背景**：企業・組織において、役職（ポジション）を管理することは、人事管理の基盤となる。本機能により、管理者は「部長」「課長」「一般社員」などの役職を定義し、ユーザーへの割当を行うことができる。

**機能の利用シーン**：
- 新しい役職の創設時
- 役職名称の変更時
- 不要な役職の削除時
- ユーザー登録・編集時の役職選択
- 役職一覧の出力時（Excel出力）

**主要な処理内容**：
1. 役職一覧の検索・表示
2. 役職の新規登録
3. 役職情報の編集・更新
4. 役職の削除
5. Excelファイルによる役職データのエクスポート

**関連システム・外部連携**：本機能は単独で動作し、外部システムとの直接連携はない。ユーザー管理機能と連携し、ユーザーへの役職割当に使用される。

**権限による制御**：
- `system:post:view` - 役職一覧画面の表示権限
- `system:post:list` - 役職一覧の取得権限
- `system:post:add` - 役職新規登録権限
- `system:post:edit` - 役職編集権限
- `system:post:remove` - 役職削除権限
- `system:post:export` - 役職データエクスポート権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | 岗位管理一覧 | 主画面 | 役職一覧の検索、表示処理 |
| 35 | 岗位新規登録 | 主画面 | 新規役職情報入力と登録保存処理 |
| 36 | 岗位編集 | 主画面 | 役職情報の更新保存処理 |

## 機能種別

CRUD操作 / データ連携（Excel出力） / バリデーション

## 入力仕様

### 入力パラメータ

#### 役職検索条件

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| postCode | String | No | 役職コード（部分一致） | 最大64文字 |
| postName | String | No | 役職名（部分一致） | 最大50文字 |
| status | String | No | ステータス | 0:正常, 1:停用 |

#### 役職登録・更新

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| postId | Long | 更新時必須 | 役職ID | 数値 |
| postCode | String | Yes | 役職コード | 必須、最大64文字、一意性チェック |
| postName | String | Yes | 役職名 | 必須、最大50文字、一意性チェック |
| postSort | String | Yes | 表示順序 | 必須 |
| status | String | No | ステータス | 0:正常, 1:停用 |
| remark | String | No | 備考 | - |

### 入力データソース

- 画面入力：管理者による直接入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| postId | Long | 役職ID |
| postCode | String | 役職コード |
| postName | String | 役職名 |
| postSort | String | 表示順序 |
| status | String | ステータス |
| createBy | String | 作成者 |
| createTime | Date | 作成日時 |
| updateBy | String | 更新者 |
| updateTime | Date | 更新日時 |
| remark | String | 備考 |

### 出力先

- 画面表示：役職一覧
- Excelファイル：エクスポート機能

## 処理フロー

### 処理シーケンス

```
1. 役職一覧取得
   └─ 検索条件を受け取り、役職一覧を取得
   └─ ページング処理

2. 役職新規登録
   └─ 入力バリデーション
   └─ 役職名一意性チェック
   └─ 役職コード一意性チェック
   └─ 役職情報登録

3. 役職更新
   └─ 入力バリデーション
   └─ 役職名一意性チェック
   └─ 役職コード一意性チェック
   └─ 役職情報更新

4. 役職削除
   └─ ユーザー割当確認（割当済みの場合は削除不可）
   └─ 役職削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧取得| C[検索条件取得]
    C --> D[ページング設定]
    D --> E[役職一覧取得]
    E --> Z[終了]

    B -->|新規登録| F[入力バリデーション]
    F --> G{バリデーションOK?}
    G -->|No| H[エラー返却]
    H --> Z
    G -->|Yes| I[役職名一意性チェック]
    I --> J{一意?}
    J -->|No| H
    J -->|Yes| K[役職コード一意性チェック]
    K --> L{一意?}
    L -->|No| H
    L -->|Yes| M[役職登録]
    M --> Z

    B -->|削除| N[ユーザー割当確認]
    N --> O{割当あり?}
    O -->|Yes| H
    O -->|No| P[役職削除]
    P --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 役職名一意性 | システム内で役職名は一意でなければならない | 役職登録・更新時 |
| BR-002 | 役職コード一意性 | システム内で役職コードは一意でなければならない | 役職登録・更新時 |
| BR-003 | 割当済み削除禁止 | ユーザーに割り当てられている役職は削除できない | 役職削除時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 役職一覧取得 | sys_post | SELECT | 条件に合致する役職一覧を取得 |
| 役職登録 | sys_post | INSERT | 新規役職情報を登録 |
| 役職更新 | sys_post | UPDATE | 役職情報を更新 |
| 役職削除 | sys_post | DELETE | 役職を削除 |
| ユーザー割当確認 | sys_user_post | SELECT COUNT | 割当ユーザー数を取得 |

### テーブル別操作詳細

#### sys_post

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | post_id | 自動採番 | 主キー |
| INSERT | post_code | 入力値 | 役職コード |
| INSERT | post_name | 入力値 | 役職名 |
| INSERT | post_sort | 入力値 | 表示順序 |
| INSERT | status | 入力値または'0' | ステータス |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |
| DELETE | post_id | 対象役職ID | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | 必須項目未入力、形式不正 | エラーメッセージを画面表示 |
| - | 一意性エラー（役職名） | 役職名が重複 | 「岗位名称已存在」メッセージを表示 |
| - | 一意性エラー（役職コード） | 役職コードが重複 | 「岗位编码已存在」メッセージを表示 |
| - | 割当エラー | ユーザーに割当済みの状態で削除 | 「〜已分配,不能删除」メッセージを表示 |

### リトライ仕様

特になし。エラー発生時は即座にエラーメッセージを返却する。

## トランザクション仕様

- 役職登録：単一INSERT処理
- 役職更新：単一UPDATE処理
- 役職削除：単一DELETE処理

## パフォーマンス要件

- 役職一覧取得：ページング処理により1ページあたり適切な件数を取得

## セキュリティ考慮事項

1. **権限制御**：Apache Shiroによるメソッドレベルの権限チェック
2. **監査ログ**：@Logアノテーションによる操作ログ記録

## 備考

- 役職削除は物理削除となる
- 役職はユーザー管理画面でユーザーへ割当可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | 役職エンティティ、バリデーションアノテーション、Excelアノテーションを確認 |

**読解のコツ**: `@NotBlank`/`@Size`アノテーションでバリデーションルールを定義。`@Excel`アノテーションでExcel出力設定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | 各エンドポイント、権限アノテーションを確認 |

**主要処理フロー**:
- **44-52行目**: 役職一覧取得（ページング）
- **54-63行目**: Excelエクスポート
- **87-103行目**: 新規登録保存（役職名・コードの一意性チェック）
- **119-135行目**: 更新保存

#### Step 3: ビジネスロジック層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysPostServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysPostServiceImpl.java` | 一意性チェック、削除時の割当チェックを確認 |

### プログラム呼び出し階層図

```
SysPostController
    │
    ├─ list() [役職一覧取得]
    │      └─ ISysPostService.selectPostList()
    │
    ├─ export() [Excelエクスポート]
    │      └─ ISysPostService.selectPostList()
    │      └─ ExcelUtil.exportExcel()
    │
    ├─ addSave() [役職新規登録]
    │      ├─ ISysPostService.checkPostNameUnique()
    │      ├─ ISysPostService.checkPostCodeUnique()
    │      └─ ISysPostService.insertPost()
    │
    ├─ editSave() [役職更新]
    │      ├─ ISysPostService.checkPostNameUnique()
    │      ├─ ISysPostService.checkPostCodeUnique()
    │      └─ ISysPostService.updatePost()
    │
    └─ remove() [役職削除]
           └─ ISysPostService.deletePostByIds()
                  └─ countUserPostById() [割当確認]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | Controller | リクエスト受付 |
| SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | Entity | 役職エンティティ |
| SysPostServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysPostServiceImpl.java` | Service | ビジネスロジック |
| SysPostMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysPostMapper.java` | Mapper | データアクセス |
