# 機能設計書 6-通知公告

## 概要

本ドキュメントは、RuoYiシステムにおける通知公告機能の設計仕様を記載する。通知公告機能は、システム内でのお知らせや公告を管理するための機能である。

### 本機能の処理概要

通知公告機能は、システム管理者が通知・公告の作成・変更・削除・照会を行うための機能を提供する。通知と公告は異なるタイプとして分類され、ユーザーへの情報伝達に使用される。

**業務上の目的・背景**：企業・組織において、重要なお知らせや公告を全ユーザーに伝達する必要がある。本機能により、管理者は「通知」（業務連絡など）や「公告」（全社向け情報）を作成し、ユーザーに表示することができる。

**機能の利用シーン**：
- システムメンテナンス告知の作成時
- 業務連絡の配信時
- 組織からの公告発信時
- 過去の通知・公告の参照時

**主要な処理内容**：
1. 通知公告一覧の検索・表示
2. 通知公告の新規登録
3. 通知公告情報の編集・更新
4. 通知公告の削除
5. 通知公告の詳細表示

**関連システム・外部連携**：本機能は単独で動作し、外部システムとの直接連携はない。

**権限による制御**：
- `system:notice:view` - 通知公告一覧画面の表示権限
- `system:notice:list` - 通知公告一覧の取得権限
- `system:notice:add` - 通知公告新規登録権限
- `system:notice:edit` - 通知公告編集権限
- `system:notice:remove` - 通知公告削除権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | 通知公告管理一覧 | 主画面 | 通知・公告一覧の検索、表示処理 |
| 48 | 通知公告新規登録 | 主画面 | 新規通知情報入力と登録保存処理 |
| 49 | 通知公告編集 | 主画面 | 通知情報の更新保存処理 |
| 50 | 通知公告表示 | 主画面 | 通知・公告の詳細表示処理 |

## 機能種別

CRUD操作 / バリデーション / XSS対策

## 入力仕様

### 入力パラメータ

#### 通知公告検索条件

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| noticeTitle | String | No | 公告タイトル（部分一致） | - |
| noticeType | String | No | 公告タイプ | 1:通知, 2:公告 |
| createBy | String | No | 作成者（部分一致） | - |

#### 通知公告登録・更新

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| noticeId | Long | 更新時必須 | 公告ID | 数値 |
| noticeTitle | String | Yes | 公告タイトル | 必須、最大50文字、XSSチェック |
| noticeType | String | Yes | 公告タイプ | 1:通知, 2:公告 |
| noticeContent | String | No | 公告内容 | - |
| status | String | No | ステータス | 0:正常, 1:关闭 |

### 入力データソース

- 画面入力：管理者による直接入力
- リッチテキストエディタ：公告内容の入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| noticeId | Long | 公告ID |
| noticeTitle | String | 公告タイトル |
| noticeType | String | 公告タイプ |
| noticeContent | String | 公告内容 |
| status | String | ステータス |
| createBy | String | 作成者 |
| createTime | Date | 作成日時 |
| updateBy | String | 更新者 |
| updateTime | Date | 更新日時 |
| remark | String | 備考 |

### 出力先

- 画面表示：通知公告一覧、詳細画面

## 処理フロー

### 処理シーケンス

```
1. 通知公告一覧取得
   └─ 検索条件を受け取り、通知公告一覧を取得
   └─ ページング処理

2. 通知公告新規登録
   └─ 入力バリデーション（XSSチェック含む）
   └─ 通知公告情報登録

3. 通知公告更新
   └─ 入力バリデーション（XSSチェック含む）
   └─ 通知公告情報更新

4. 通知公告削除
   └─ 対象通知公告削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧取得| C[検索条件取得]
    C --> D[ページング設定]
    D --> E[通知公告一覧取得]
    E --> Z[終了]

    B -->|新規登録| F[入力バリデーション]
    F --> G{バリデーションOK?}
    G -->|No| H[エラー返却]
    H --> Z
    G -->|Yes| I[XSSチェック]
    I --> J[通知公告登録]
    J --> Z

    B -->|削除| K[対象通知公告削除]
    K --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | XSS対策 | 公告タイトルにスクリプト文字を含めることはできない | 公告登録・更新時 |
| BR-002 | タイプ区分 | 通知（1）と公告（2）を区別して管理する | 公告登録・更新時 |
| BR-003 | ステータス管理 | 正常（0）と关闭（1）の2状態を管理 | 公告登録・更新時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 通知公告一覧取得 | sys_notice | SELECT | 条件に合致する通知公告一覧を取得 |
| 通知公告登録 | sys_notice | INSERT | 新規通知公告情報を登録 |
| 通知公告更新 | sys_notice | UPDATE | 通知公告情報を更新 |
| 通知公告削除 | sys_notice | DELETE | 通知公告を削除 |

### テーブル別操作詳細

#### sys_notice

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | notice_id | 自動採番 | 主キー |
| INSERT | notice_title | 入力値 | 公告タイトル |
| INSERT | notice_type | 入力値 | 公告タイプ |
| INSERT | notice_content | 入力値 | 公告内容 |
| INSERT | status | 入力値または'0' | ステータス |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |
| DELETE | notice_id | 対象公告ID | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | 必須項目未入力、形式不正 | エラーメッセージを画面表示 |
| - | XSSエラー | タイトルにスクリプト文字を含む | 「公告标题不能包含脚本字符」メッセージを表示 |

### リトライ仕様

特になし。エラー発生時は即座にエラーメッセージを返却する。

## トランザクション仕様

- 通知公告登録：単一INSERT処理
- 通知公告更新：単一UPDATE処理
- 通知公告削除：単一DELETE処理（複数ID指定時は複数DELETE）

## パフォーマンス要件

- 通知公告一覧取得：ページング処理により1ページあたり適切な件数を取得

## セキュリティ考慮事項

1. **権限制御**：Apache Shiroによるメソッドレベルの権限チェック
2. **監査ログ**：@Logアノテーションによる操作ログ記録
3. **XSS対策**：@Xssアノテーションによるスクリプト文字の排除

## 備考

- 通知公告削除は物理削除となる
- 公告内容はリッチテキスト（HTML）形式で保存可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | 通知公告エンティティ、バリデーションアノテーション、XSSアノテーションを確認 |

**読解のコツ**: `@NotBlank`/`@Size`アノテーションでバリデーションルールを定義。`@Xss`アノテーション（49行目）でXSS対策を実装。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | 各エンドポイント、権限アノテーションを確認 |

**主要処理フロー**:
- **47-54行目**: 通知公告一覧取得（ページング）
- **69-77行目**: 新規登録保存
- **93-101行目**: 更新保存
- **117-124行目**: 削除処理
- **106-112行目**: 詳細表示

#### Step 3: ビジネスロジック層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | シンプルなCRUD処理を確認 |

### プログラム呼び出し階層図

```
SysNoticeController
    │
    ├─ list() [通知公告一覧取得]
    │      └─ ISysNoticeService.selectNoticeList()
    │
    ├─ addSave() [通知公告新規登録]
    │      └─ ISysNoticeService.insertNotice()
    │
    ├─ editSave() [通知公告更新]
    │      └─ ISysNoticeService.updateNotice()
    │
    ├─ remove() [通知公告削除]
    │      └─ ISysNoticeService.deleteNoticeByIds()
    │
    └─ view() [通知公告詳細表示]
           └─ ISysNoticeService.selectNoticeById()
```

### データフロー図

```mermaid
flowchart LR
    subgraph Controller
        A[SysNoticeController]
    end

    subgraph Service
        B[SysNoticeServiceImpl]
    end

    subgraph Mapper
        C[SysNoticeMapper]
    end

    subgraph Database
        D[(sys_notice)]
    end

    A --> B
    B --> C
    C --> D
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | Controller | リクエスト受付 |
| SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | Entity | 通知公告エンティティ |
| SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | Service | ビジネスロジック |
| SysNoticeMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysNoticeMapper.java` | Mapper | データアクセス |
