# 機能設計書 7-パラメータ設定

## 概要

本ドキュメントは、RuoYiシステムにおけるパラメータ設定機能の設計仕様を記載する。パラメータ設定機能は、システム全体で使用される設定パラメータを管理するための機能である。

### 本機能の処理概要

パラメータ設定機能は、システム管理者がシステムパラメータの作成・変更・削除・照会を行うための機能を提供する。パラメータはキー・バリュー形式で管理され、キャッシュを通じてシステム全体で参照される。

**業務上の目的・背景**：システム運用において、動的に変更可能な設定値を外部化して管理する必要がある。本機能により、管理者はソースコードを変更することなく、システムの動作を制御するパラメータを管理できる。

**機能の利用シーン**：
- システム初期設定の定義時
- 運用中のパラメータ変更時
- キャッシュのリフレッシュ時
- パラメータ一覧の出力時（Excel出力）

**主要な処理内容**：
1. パラメータ一覧の検索・表示
2. パラメータの新規登録
3. パラメータ情報の編集・更新
4. パラメータの削除
5. キャッシュのリフレッシュ
6. Excelファイルによるパラメータデータのエクスポート

**関連システム・外部連携**：本機能は単独で動作し、外部システムとの直接連携はない。パラメータ値はシステム全体から参照される。

**権限による制御**：
- `system:config:view` - パラメータ一覧画面の表示権限
- `system:config:list` - パラメータ一覧の取得権限
- `system:config:add` - パラメータ新規登録権限
- `system:config:edit` - パラメータ編集権限
- `system:config:remove` - パラメータ削除権限
- `system:config:export` - パラメータデータエクスポート権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | パラメータ管理一覧 | 主画面 | パラメータ一覧の検索、表示処理 |
| 45 | パラメータ新規登録 | 主画面 | 新規パラメータ情報入力と登録保存処理 |
| 46 | パラメータ編集 | 主画面 | パラメータ情報の更新保存処理 |

## 機能種別

CRUD操作 / データ連携（Excel出力） / キャッシュ管理 / バリデーション

## 入力仕様

### 入力パラメータ

#### パラメータ検索条件

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| configName | String | No | パラメータ名（部分一致） | - |
| configKey | String | No | パラメータキー（部分一致） | - |
| configType | String | No | システム内置 | Y:是, N:否 |

#### パラメータ登録・更新

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| configId | Long | 更新時必須 | パラメータID | 数値 |
| configName | String | Yes | パラメータ名 | 必須、最大100文字 |
| configKey | String | Yes | パラメータキー | 必須、最大100文字、一意性チェック |
| configValue | String | Yes | パラメータ値 | 必須、最大500文字 |
| configType | String | No | システム内置 | Y:是, N:否 |
| remark | String | No | 備考 | - |

### 入力データソース

- 画面入力：管理者による直接入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| configId | Long | パラメータID |
| configName | String | パラメータ名 |
| configKey | String | パラメータキー |
| configValue | String | パラメータ値 |
| configType | String | システム内置 |
| createBy | String | 作成者 |
| createTime | Date | 作成日時 |
| updateBy | String | 更新者 |
| updateTime | Date | 更新日時 |
| remark | String | 備考 |

### 出力先

- 画面表示：パラメータ一覧
- Excelファイル：エクスポート機能

## 処理フロー

### 処理シーケンス

```
1. パラメータ一覧取得
   └─ 検索条件を受け取り、パラメータ一覧を取得
   └─ ページング処理

2. パラメータ新規登録
   └─ 入力バリデーション
   └─ パラメータキー一意性チェック
   └─ パラメータ情報登録
   └─ キャッシュ更新

3. パラメータ更新
   └─ 入力バリデーション
   └─ パラメータキー一意性チェック
   └─ パラメータ情報更新
   └─ キャッシュ更新（キー変更時は旧キャッシュ削除）

4. パラメータ削除
   └─ 内置パラメータチェック（内置の場合は削除不可）
   └─ パラメータ削除
   └─ キャッシュ削除

5. キャッシュリフレッシュ
   └─ 全キャッシュクリア
   └─ DBから全パラメータ再読込
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧取得| C[検索条件取得]
    C --> D[ページング設定]
    D --> E[パラメータ一覧取得]
    E --> Z[終了]

    B -->|新規登録| F[入力バリデーション]
    F --> G{バリデーションOK?}
    G -->|No| H[エラー返却]
    H --> Z
    G -->|Yes| I[パラメータキー一意性チェック]
    I --> J{一意?}
    J -->|No| H
    J -->|Yes| K[パラメータ登録]
    K --> L[キャッシュ更新]
    L --> Z

    B -->|削除| M{内置パラメータ?}
    M -->|Yes| H
    M -->|No| N[パラメータ削除]
    N --> O[キャッシュ削除]
    O --> Z

    B -->|キャッシュリフレッシュ| P[全キャッシュクリア]
    P --> Q[DBから再読込]
    Q --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | パラメータキー一意性 | システム内でパラメータキーは一意でなければならない | パラメータ登録・更新時 |
| BR-002 | 内置パラメータ削除禁止 | システム内置パラメータ（configType='Y'）は削除できない | パラメータ削除時 |
| BR-003 | キャッシュ自動更新 | パラメータ登録・更新・削除時にキャッシュを自動更新 | パラメータCRUD時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パラメータ一覧取得 | sys_config | SELECT | 条件に合致するパラメータ一覧を取得 |
| パラメータ登録 | sys_config | INSERT | 新規パラメータ情報を登録 |
| パラメータ更新 | sys_config | UPDATE | パラメータ情報を更新 |
| パラメータ削除 | sys_config | DELETE | パラメータを削除 |

### テーブル別操作詳細

#### sys_config

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | config_id | 自動採番 | 主キー |
| INSERT | config_name | 入力値 | パラメータ名 |
| INSERT | config_key | 入力値 | パラメータキー |
| INSERT | config_value | 入力値 | パラメータ値 |
| INSERT | config_type | 入力値または'N' | システム内置 |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |
| DELETE | config_id | 対象パラメータID | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | 必須項目未入力、形式不正 | エラーメッセージを画面表示 |
| - | 一意性エラー | パラメータキーが重複 | 「参数键名已存在」メッセージを表示 |
| - | 内置パラメータエラー | 内置パラメータの削除を試みた | 「内置参数【〜】不能删除」メッセージを表示 |

### リトライ仕様

特になし。エラー発生時は即座にエラーメッセージを返却する。

## トランザクション仕様

- パラメータ登録：単一INSERT処理
- パラメータ更新：単一UPDATE処理
- パラメータ削除：ループ処理（各パラメータごとにチェック・削除）

## パフォーマンス要件

- パラメータ一覧取得：ページング処理により1ページあたり適切な件数を取得
- キャッシュ機能：@PostConstructでアプリケーション起動時にキャッシュにロード

## セキュリティ考慮事項

1. **権限制御**：Apache Shiroによるメソッドレベルの権限チェック
2. **監査ログ**：@Logアノテーションによる操作ログ記録

## 備考

- パラメータ削除は物理削除となる
- システム起動時に全パラメータがキャッシュに読み込まれる
- パラメータ値の参照はキャッシュ優先、なければDBから取得してキャッシュに格納

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | パラメータエンティティ、バリデーションアノテーション、Excelアノテーションを確認 |

**読解のコツ**: `@NotBlank`/`@Size`アノテーション（49-50, 61-62, 73-74行目）でバリデーションルールを定義。`@Excel`アノテーションでExcel出力設定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | 各エンドポイント、権限アノテーションを確認 |

**主要処理フロー**:
- **48-55行目**: パラメータ一覧取得（ページング）
- **57-66行目**: Excelエクスポート
- **81-93行目**: 新規登録保存（キー一意性チェック）
- **109-121行目**: 更新保存
- **126-134行目**: 削除処理
- **139-147行目**: キャッシュリフレッシュ

#### Step 3: ビジネスロジック層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysConfigServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java` | キャッシュ管理、一意性チェック、内置パラメータチェックを確認 |

**キーポイント**:
- **31-35行目**: @PostConstructでアプリケーション起動時にキャッシュ初期化
- **58-74行目**: キー名による値取得（キャッシュ優先）
- **95-103行目**: 登録時のキャッシュ更新
- **112-126行目**: 更新時のキャッシュ更新（キー変更対応）
- **134-147行目**: 削除時の内置パラメータチェックとキャッシュ削除
- **175-179行目**: キャッシュリフレッシュ

### プログラム呼び出し階層図

```
SysConfigController
    │
    ├─ list() [パラメータ一覧取得]
    │      └─ ISysConfigService.selectConfigList()
    │
    ├─ export() [Excelエクスポート]
    │      └─ ISysConfigService.selectConfigList()
    │      └─ ExcelUtil.exportExcel()
    │
    ├─ addSave() [パラメータ新規登録]
    │      ├─ ISysConfigService.checkConfigKeyUnique()
    │      └─ ISysConfigService.insertConfig()
    │             └─ CacheUtils.put() [キャッシュ更新]
    │
    ├─ editSave() [パラメータ更新]
    │      ├─ ISysConfigService.checkConfigKeyUnique()
    │      └─ ISysConfigService.updateConfig()
    │             ├─ CacheUtils.remove() [旧キャッシュ削除]
    │             └─ CacheUtils.put() [新キャッシュ設定]
    │
    ├─ remove() [パラメータ削除]
    │      └─ ISysConfigService.deleteConfigByIds()
    │             ├─ configType='Y'チェック
    │             └─ CacheUtils.remove() [キャッシュ削除]
    │
    └─ refreshCache() [キャッシュリフレッシュ]
           └─ ISysConfigService.resetConfigCache()
                  ├─ clearConfigCache()
                  └─ loadingConfigCache()
```

### データフロー図

```mermaid
flowchart LR
    subgraph Controller
        A[SysConfigController]
    end

    subgraph Service
        B[SysConfigServiceImpl]
    end

    subgraph Cache
        C[CacheUtils]
    end

    subgraph Mapper
        D[SysConfigMapper]
    end

    subgraph Database
        E[(sys_config)]
    end

    A --> B
    B --> C
    B --> D
    D --> E
    C -.-> B
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | Controller | リクエスト受付 |
| SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | Entity | パラメータエンティティ |
| SysConfigServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java` | Service | ビジネスロジック |
| SysConfigMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysConfigMapper.java` | Mapper | データアクセス |
| CacheUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/CacheUtils.java` | Utility | キャッシュ操作 |
