# 機能設計書 8-辞書タイプ管理

## 概要

本ドキュメントは、RuoYiシステムにおける辞書タイプ管理機能の設計仕様を記載する。辞書タイプ管理機能は、システム内で使用される各種区分値の分類（辞書タイプ）を管理するための機能である。

### 本機能の処理概要

辞書タイプ管理機能は、システム管理者が辞書タイプの作成・変更・削除・照会を行うための機能を提供する。辞書タイプは辞書データの親分類として機能し、辞書タイプごとに複数の辞書データを管理する。

**業務上の目的・背景**：システム内で使用される各種区分値（ステータス、性別、フラグなど）を体系的に管理する必要がある。本機能により、管理者は辞書タイプを定義し、それに紐づく辞書データを管理できる。

**機能の利用シーン**：
- 新しい区分値分類の定義時
- 辞書タイプ名称の変更時
- 不要な辞書タイプの削除時
- 辞書タイプ一覧の出力時（Excel出力）
- 辞書キャッシュのリフレッシュ時

**主要な処理内容**：
1. 辞書タイプ一覧の検索・表示
2. 辞書タイプの新規登録
3. 辞書タイプ情報の編集・更新
4. 辞書タイプの削除
5. 辞書タイプツリーの表示
6. キャッシュのリフレッシュ
7. Excelファイルによる辞書タイプデータのエクスポート

**関連システム・外部連携**：本機能は辞書データ管理機能と連携する。辞書タイプを変更すると、関連する辞書データの辞書タイプも自動更新される。

**権限による制御**：
- `system:dict:view` - 辞書タイプ一覧画面の表示権限
- `system:dict:list` - 辞書タイプ一覧の取得権限
- `system:dict:add` - 辞書タイプ新規登録権限
- `system:dict:edit` - 辞書タイプ編集権限
- `system:dict:remove` - 辞書タイプ削除権限
- `system:dict:export` - 辞書タイプデータエクスポート権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | 字典類型管理一覧 | 主画面 | 辞書タイプ一覧の検索、表示処理 |
| 38 | 字典類型新規登録 | 主画面 | 新規辞書タイプ情報入力と登録保存処理 |
| 39 | 字典類型編集 | 主画面 | 辞書タイプ情報の更新保存処理 |
| 40 | 字典類型ツリー表示 | 主画面 | 辞書タイプのツリー構造表示処理 |

## 機能種別

CRUD操作 / データ連携（Excel出力） / キャッシュ管理 / バリデーション / ツリー構造

## 入力仕様

### 入力パラメータ

#### 辞書タイプ検索条件

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| dictName | String | No | 辞書名称（部分一致） | - |
| dictType | String | No | 辞書タイプ（部分一致） | - |
| status | String | No | ステータス | 0:正常, 1:停用 |

#### 辞書タイプ登録・更新

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| dictId | Long | 更新時必須 | 辞書ID | 数値 |
| dictName | String | Yes | 辞書名称 | 必須、最大100文字 |
| dictType | String | Yes | 辞書タイプ | 必須、最大100文字、英小文字開始、英小文字・数字・アンダースコアのみ、一意性チェック |
| status | String | No | ステータス | 0:正常, 1:停用 |
| remark | String | No | 備考 | - |

### 入力データソース

- 画面入力：管理者による直接入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| dictId | Long | 辞書ID |
| dictName | String | 辞書名称 |
| dictType | String | 辞書タイプ |
| status | String | ステータス |
| createBy | String | 作成者 |
| createTime | Date | 作成日時 |
| updateBy | String | 更新者 |
| updateTime | Date | 更新日時 |
| remark | String | 備考 |

### 出力先

- 画面表示：辞書タイプ一覧、ツリー
- Excelファイル：エクスポート機能

## 処理フロー

### 処理シーケンス

```
1. 辞書タイプ一覧取得
   └─ 検索条件を受け取り、辞書タイプ一覧を取得
   └─ ページング処理

2. 辞書タイプ新規登録
   └─ 入力バリデーション
   └─ 辞書タイプ一意性チェック
   └─ 辞書タイプ情報登録
   └─ キャッシュ設定

3. 辞書タイプ更新
   └─ 入力バリデーション
   └─ 辞書タイプ一意性チェック
   └─ 関連辞書データの辞書タイプ更新
   └─ 辞書タイプ情報更新
   └─ キャッシュ更新

4. 辞書タイプ削除
   └─ 辞書データ存在チェック（存在する場合は削除不可）
   └─ 辞書タイプ削除
   └─ キャッシュ削除

5. キャッシュリフレッシュ
   └─ 全辞書キャッシュクリア
   └─ DBから全辞書データ再読込
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧取得| C[検索条件取得]
    C --> D[ページング設定]
    D --> E[辞書タイプ一覧取得]
    E --> Z[終了]

    B -->|新規登録| F[入力バリデーション]
    F --> G{バリデーションOK?}
    G -->|No| H[エラー返却]
    H --> Z
    G -->|Yes| I[辞書タイプ一意性チェック]
    I --> J{一意?}
    J -->|No| H
    J -->|Yes| K[辞書タイプ登録]
    K --> L[キャッシュ設定]
    L --> Z

    B -->|更新| M[辞書データの辞書タイプ更新]
    M --> N[辞書タイプ更新]
    N --> O[キャッシュ更新]
    O --> Z

    B -->|削除| P{辞書データ存在?}
    P -->|Yes| H
    P -->|No| Q[辞書タイプ削除]
    Q --> R[キャッシュ削除]
    R --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 辞書タイプ一意性 | システム内で辞書タイプは一意でなければならない | 辞書タイプ登録・更新時 |
| BR-002 | 辞書データ存在時削除禁止 | 辞書データが存在する辞書タイプは削除できない | 辞書タイプ削除時 |
| BR-003 | 辞書タイプ形式 | 辞書タイプは英小文字で開始し、英小文字・数字・アンダースコアのみ使用可能 | 辞書タイプ登録・更新時 |
| BR-004 | キャッシュ自動更新 | 辞書タイプ登録・更新・削除時にキャッシュを自動更新 | 辞書タイプCRUD時 |
| BR-005 | 辞書データ連動更新 | 辞書タイプ更新時に関連する辞書データの辞書タイプも自動更新 | 辞書タイプ更新時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 辞書タイプ一覧取得 | sys_dict_type | SELECT | 条件に合致する辞書タイプ一覧を取得 |
| 辞書タイプ登録 | sys_dict_type | INSERT | 新規辞書タイプ情報を登録 |
| 辞書タイプ更新 | sys_dict_type, sys_dict_data | UPDATE | 辞書タイプ情報と関連辞書データを更新 |
| 辞書タイプ削除 | sys_dict_type | DELETE | 辞書タイプを削除 |
| 辞書データ存在確認 | sys_dict_data | SELECT COUNT | 辞書タイプに紐づく辞書データ数を取得 |

### テーブル別操作詳細

#### sys_dict_type

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | dict_id | 自動採番 | 主キー |
| INSERT | dict_name | 入力値 | 辞書名称 |
| INSERT | dict_type | 入力値 | 辞書タイプ |
| INSERT | status | 入力値または'0' | ステータス |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |
| UPDATE | dict_type | 新辞書タイプ | 辞書データも連動更新 |
| DELETE | dict_id | 対象辞書ID | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | 必須項目未入力、形式不正 | エラーメッセージを画面表示 |
| - | 一意性エラー | 辞書タイプが重複 | 「字典类型已存在」メッセージを表示 |
| - | 削除制約エラー | 辞書データが存在する状態で削除 | 「〜已分配,不能删除」メッセージを表示 |
| - | 形式エラー | 辞書タイプが形式に合わない | 「字典类型必须以字母开头，且只能为（小写字母，数字，下滑线）」メッセージを表示 |

### リトライ仕様

特になし。エラー発生時は即座にエラーメッセージを返却する。

## トランザクション仕様

- 辞書タイプ登録：単一INSERT処理
- 辞書タイプ更新：@Transactionalによるトランザクション管理（辞書データ更新と辞書タイプ更新）
- 辞書タイプ削除：ループ処理（各辞書タイプごとにチェック・削除）

## パフォーマンス要件

- 辞書タイプ一覧取得：ページング処理により1ページあたり適切な件数を取得
- キャッシュ機能：@PostConstructでアプリケーション起動時にキャッシュにロード

## セキュリティ考慮事項

1. **権限制御**：Apache Shiroによるメソッドレベルの権限チェック
2. **監査ログ**：@Logアノテーションによる操作ログ記録

## 備考

- 辞書タイプ削除は物理削除となる
- システム起動時に全辞書データがキャッシュに読み込まれる
- 辞書タイプのツリー表示ではステータスが正常（0）のもののみ表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | 辞書タイプエンティティ、バリデーションアノテーション、Excelアノテーションを確認 |

**読解のコツ**: `@NotBlank`/`@Size`/`@Pattern`アノテーション（45-46, 57-59行目）でバリデーションルールを定義。特に`@Pattern`（59行目）で辞書タイプの形式チェックを実装。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | 各エンドポイント、権限アノテーションを確認 |

**主要処理フロー**:
- **45-53行目**: 辞書タイプ一覧取得（ページング）
- **55-65行目**: Excelエクスポート
- **80-92行目**: 新規登録保存（タイプ一意性チェック）
- **108-120行目**: 更新保存
- **122-130行目**: 削除処理
- **135-143行目**: キャッシュリフレッシュ
- **181-187行目**: ツリーデータ取得

#### Step 3: ビジネスロジック層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDictTypeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictTypeServiceImpl.java` | キャッシュ管理、一意性チェック、トランザクション管理を確認 |

**キーポイント**:
- **41-45行目**: @PostConstructでアプリケーション起動時にキャッシュ初期化
- **123-136行目**: 削除時の辞書データ存在チェック
- **196-208行目**: @Transactionalで辞書タイプ更新時の辞書データ連動更新
- **217-226行目**: 一意性チェック
- **235-251行目**: ツリーデータ生成（ステータス正常のみ）

### プログラム呼び出し階層図

```
SysDictTypeController
    │
    ├─ list() [辞書タイプ一覧取得]
    │      └─ ISysDictTypeService.selectDictTypeList()
    │
    ├─ export() [Excelエクスポート]
    │      └─ ISysDictTypeService.selectDictTypeList()
    │      └─ ExcelUtil.exportExcel()
    │
    ├─ addSave() [辞書タイプ新規登録]
    │      ├─ ISysDictTypeService.checkDictTypeUnique()
    │      └─ ISysDictTypeService.insertDictType()
    │             └─ DictUtils.setDictCache() [キャッシュ設定]
    │
    ├─ editSave() [辞書タイプ更新]  @Transactional
    │      ├─ ISysDictTypeService.checkDictTypeUnique()
    │      └─ ISysDictTypeService.updateDictType()
    │             ├─ SysDictDataMapper.updateDictDataType() [辞書データ連動更新]
    │             └─ DictUtils.setDictCache() [キャッシュ更新]
    │
    ├─ remove() [辞書タイプ削除]
    │      └─ ISysDictTypeService.deleteDictTypeByIds()
    │             ├─ countDictDataByType() [辞書データ存在チェック]
    │             └─ DictUtils.removeDictCache() [キャッシュ削除]
    │
    ├─ refreshCache() [キャッシュリフレッシュ]
    │      └─ ISysDictTypeService.resetDictCache()
    │             ├─ clearDictCache()
    │             └─ loadingDictCache()
    │
    └─ treeData() [ツリーデータ取得]
           └─ ISysDictTypeService.selectDictTree()
```

### データフロー図

```mermaid
flowchart LR
    subgraph Controller
        A[SysDictTypeController]
    end

    subgraph Service
        B[SysDictTypeServiceImpl]
    end

    subgraph Cache
        C[DictUtils]
    end

    subgraph Mapper
        D[SysDictTypeMapper]
        E[SysDictDataMapper]
    end

    subgraph Database
        F[(sys_dict_type)]
        G[(sys_dict_data)]
    end

    A --> B
    B --> C
    B --> D
    B --> E
    D --> F
    E --> G
    C -.-> B
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | Controller | リクエスト受付 |
| SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | Entity | 辞書タイプエンティティ |
| SysDictTypeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictTypeServiceImpl.java` | Service | ビジネスロジック |
| SysDictTypeMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysDictTypeMapper.java` | Mapper | データアクセス |
| SysDictDataMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysDictDataMapper.java` | Mapper | 辞書データアクセス |
| DictUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/DictUtils.java` | Utility | キャッシュ操作 |
