# 機能設計書 9-辞書データ管理

## 概要

本ドキュメントは、RuoYiシステムにおける辞書データ管理機能の設計仕様を記載する。辞書データ管理機能は、辞書タイプに紐づく具体的な区分値（辞書データ）を管理するための機能である。

### 本機能の処理概要

辞書データ管理機能は、システム管理者が辞書データの作成・変更・削除・照会を行うための機能を提供する。辞書データは辞書タイプに属し、実際のラベルと値のペアを管理する。

**業務上の目的・背景**：システム内で使用される各種区分値（例：性別の「男/女」、ステータスの「有効/無効」など）の具体的な選択肢を管理する必要がある。本機能により、管理者は辞書タイプごとに辞書データを定義し、画面表示やデータ検証に使用できる。

**機能の利用シーン**：
- 新しい区分値の追加時
- 区分値のラベル変更時
- 不要な区分値の削除時
- 区分値一覧の出力時（Excel出力）

**主要な処理内容**：
1. 辞書データ一覧の検索・表示
2. 辞書データの新規登録
3. 辞書データ情報の編集・更新
4. 辞書データの削除
5. Excelファイルによる辞書データのエクスポート

**関連システム・外部連携**：本機能は辞書タイプ管理機能と連携する。辞書データは辞書タイプに属し、辞書タイプを介して管理される。

**権限による制御**：
- `system:dict:view` - 辞書データ一覧画面の表示権限
- `system:dict:list` - 辞書データ一覧の取得権限
- `system:dict:add` - 辞書データ新規登録権限
- `system:dict:edit` - 辞書データ編集権限
- `system:dict:remove` - 辞書データ削除権限
- `system:dict:export` - 辞書データエクスポート権限

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | 字典データ管理一覧 | 主画面 | 辞書データ一覧の検索、表示処理 |
| 42 | 字典データ新規登録 | 主画面 | 新規辞書データ情報入力と登録保存処理 |
| 43 | 字典データ編集 | 主画面 | 辞書データ情報の更新保存処理 |

## 機能種別

CRUD操作 / データ連携（Excel出力） / キャッシュ管理 / バリデーション

## 入力仕様

### 入力パラメータ

#### 辞書データ検索条件

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| dictType | String | Yes | 辞書タイプ | - |
| dictLabel | String | No | 辞書ラベル（部分一致） | - |
| status | String | No | ステータス | 0:正常, 1:停用 |

#### 辞書データ登録・更新

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| dictCode | Long | 更新時必須 | 辞書コード | 数値 |
| dictType | String | Yes | 辞書タイプ | 必須、最大100文字 |
| dictLabel | String | Yes | 辞書ラベル | 必須、最大100文字 |
| dictValue | String | Yes | 辞書値 | 必須、最大100文字 |
| dictSort | Long | No | 表示順序 | 数値 |
| cssClass | String | No | CSSクラス | 最大100文字 |
| listClass | String | No | リストスタイル | - |
| isDefault | String | No | デフォルト値 | Y:是, N:否 |
| status | String | No | ステータス | 0:正常, 1:停用 |
| remark | String | No | 備考 | - |

### 入力データソース

- 画面入力：管理者による直接入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| dictCode | Long | 辞書コード |
| dictSort | Long | 表示順序 |
| dictLabel | String | 辞書ラベル |
| dictValue | String | 辞書値 |
| dictType | String | 辞書タイプ |
| cssClass | String | CSSクラス |
| listClass | String | リストスタイル |
| isDefault | String | デフォルト値 |
| status | String | ステータス |
| createBy | String | 作成者 |
| createTime | Date | 作成日時 |
| updateBy | String | 更新者 |
| updateTime | Date | 更新日時 |
| remark | String | 備考 |

### 出力先

- 画面表示：辞書データ一覧
- Excelファイル：エクスポート機能

## 処理フロー

### 処理シーケンス

```
1. 辞書データ一覧取得
   └─ 検索条件を受け取り、辞書データ一覧を取得
   └─ ページング処理

2. 辞書データ新規登録
   └─ 入力バリデーション
   └─ 辞書データ情報登録
   └─ キャッシュ更新

3. 辞書データ更新
   └─ 入力バリデーション
   └─ 辞書データ情報更新
   └─ キャッシュ更新

4. 辞書データ削除
   └─ 辞書データ削除
   └─ キャッシュ更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧取得| C[辞書タイプ指定]
    C --> D[ページング設定]
    D --> E[辞書データ一覧取得]
    E --> Z[終了]

    B -->|新規登録| F[入力バリデーション]
    F --> G{バリデーションOK?}
    G -->|No| H[エラー返却]
    H --> Z
    G -->|Yes| I[辞書データ登録]
    I --> J[キャッシュ更新]
    J --> Z

    B -->|更新| K[入力バリデーション]
    K --> L{バリデーションOK?}
    L -->|No| H
    L -->|Yes| M[辞書データ更新]
    M --> N[キャッシュ更新]
    N --> Z

    B -->|削除| O[辞書データ削除]
    O --> P[キャッシュ更新]
    P --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 辞書タイプ必須 | 辞書データは必ず辞書タイプに属する | 辞書データ登録・更新時 |
| BR-002 | キャッシュ自動更新 | 辞書データ登録・更新・削除時にキャッシュを自動更新 | 辞書データCRUD時 |
| BR-003 | デフォルト値管理 | isDefault='Y'のデータがデフォルト選択値となる | 画面表示時 |
| BR-004 | 表示順序管理 | dictSort値に基づいて辞書データをソート | 画面表示時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 辞書データ一覧取得 | sys_dict_data | SELECT | 条件に合致する辞書データ一覧を取得 |
| 辞書データ登録 | sys_dict_data | INSERT | 新規辞書データ情報を登録 |
| 辞書データ更新 | sys_dict_data | UPDATE | 辞書データ情報を更新 |
| 辞書データ削除 | sys_dict_data | DELETE | 辞書データを削除 |

### テーブル別操作詳細

#### sys_dict_data

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | dict_code | 自動採番 | 主キー |
| INSERT | dict_sort | 入力値 | 表示順序 |
| INSERT | dict_label | 入力値 | 辞書ラベル |
| INSERT | dict_value | 入力値 | 辞書値 |
| INSERT | dict_type | 入力値 | 辞書タイプ |
| INSERT | css_class | 入力値 | CSSクラス |
| INSERT | list_class | 入力値 | リストスタイル |
| INSERT | is_default | 入力値または'N' | デフォルト値 |
| INSERT | status | 入力値または'0' | ステータス |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |
| DELETE | dict_code | 対象辞書コード | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | 必須項目未入力、形式不正 | エラーメッセージを画面表示 |

### リトライ仕様

特になし。エラー発生時は即座にエラーメッセージを返却する。

## トランザクション仕様

- 辞書データ登録：単一INSERT処理
- 辞書データ更新：単一UPDATE処理
- 辞書データ削除：ループ処理（各辞書データごとに削除・キャッシュ更新）

## パフォーマンス要件

- 辞書データ一覧取得：ページング処理により1ページあたり適切な件数を取得
- キャッシュ機能：辞書データ更新後に該当辞書タイプのキャッシュを更新

## セキュリティ考慮事項

1. **権限制御**：Apache Shiroによるメソッドレベルの権限チェック
2. **監査ログ**：@Logアノテーションによる操作ログ記録

## 備考

- 辞書データ削除は物理削除となる
- 辞書データはdictSortに基づいてソートされてキャッシュに格納される
- 辞書タイプ画面から辞書データ画面へ遷移する導線が存在する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDictData.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` | 辞書データエンティティ、バリデーションアノテーション、Excelアノテーションを確認 |

**読解のコツ**: `@NotBlank`/`@Size`アノテーション（75-76, 87-88, 99-100, 111行目）でバリデーションルールを定義。`@Excel`アノテーションでExcel出力設定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysDictDataController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` | 各エンドポイント、権限アノテーションを確認 |

**主要処理フロー**:
- **44-52行目**: 辞書データ一覧取得（ページング）
- **54-63行目**: Excelエクスポート
- **79-87行目**: 新規登録保存
- **103-111行目**: 更新保存
- **113-121行目**: 削除処理

#### Step 3: ビジネスロジック層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDictDataServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java` | キャッシュ管理を確認 |

**キーポイント**:
- **66-76行目**: 削除処理とキャッシュ更新
- **85-94行目**: 登録処理とキャッシュ更新
- **103-112行目**: 更新処理とキャッシュ更新

### プログラム呼び出し階層図

```
SysDictDataController
    │
    ├─ list() [辞書データ一覧取得]
    │      └─ ISysDictDataService.selectDictDataList()
    │
    ├─ export() [Excelエクスポート]
    │      └─ ISysDictDataService.selectDictDataList()
    │      └─ ExcelUtil.exportExcel()
    │
    ├─ addSave() [辞書データ新規登録]
    │      └─ ISysDictDataService.insertDictData()
    │             ├─ SysDictDataMapper.insertDictData()
    │             └─ DictUtils.setDictCache() [キャッシュ更新]
    │
    ├─ editSave() [辞書データ更新]
    │      └─ ISysDictDataService.updateDictData()
    │             ├─ SysDictDataMapper.updateDictData()
    │             └─ DictUtils.setDictCache() [キャッシュ更新]
    │
    └─ remove() [辞書データ削除]
           └─ ISysDictDataService.deleteDictDataByIds()
                  ├─ SysDictDataMapper.deleteDictDataById()
                  └─ DictUtils.setDictCache() [キャッシュ更新]
```

### データフロー図

```mermaid
flowchart LR
    subgraph Controller
        A[SysDictDataController]
    end

    subgraph Service
        B[SysDictDataServiceImpl]
    end

    subgraph Cache
        C[DictUtils]
    end

    subgraph Mapper
        D[SysDictDataMapper]
    end

    subgraph Database
        E[(sys_dict_data)]
    end

    A --> B
    B --> C
    B --> D
    D --> E
    C -.-> B
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysDictDataController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` | Controller | リクエスト受付 |
| SysDictData.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` | Entity | 辞書データエンティティ |
| SysDictDataServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java` | Service | ビジネスロジック |
| SysDictDataMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysDictDataMapper.java` | Mapper | データアクセス |
| DictUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/DictUtils.java` | Utility | キャッシュ操作 |
