---
generated_at: 2026-01-08 15:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：1-ユーザー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（1ページあたり100件）**：コード上の設定値未確認
  2. **Excelインポート件数制限なし**：明示的な制限確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `SysUserController.java` (ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/)
- E-02: `SysUser.java` (ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/)
- E-03: `SysUserServiceImpl.java` (ruoyi-system/src/main/java/com/ruoyi/system/service/impl/)
- E-04: `SysUserMapper.java` (ruoyi-system/src/main/java/com/ruoyi/system/mapper/)
- E-05: `SysUserMapper.xml` (ruoyi-system/src/main/resources/mapper/system/)
- E-06: `ISysUserService.java` (ruoyi-system/src/main/java/com/ruoyi/system/service/)
- E-07: `画面機能マッピング.csv` (docs/code-to-docs/画面機能マッピング/)
- E-08: `機能一覧.csv` (docs/code-to-docs/機能一覧/)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザー一覧取得機能を提供 | E-01（71-79行目）、E-03（80-85行目） | ○ |
| C-02 | ユーザー新規登録機能を提供 | E-01（128-153行目）、E-03（219-230行目） | ○ |
| C-03 | ユーザー編集機能を提供 | E-01（187-212行目）、E-03（251-265行目） | ○ |
| C-04 | ユーザー削除機能を提供 | E-01（276-287行目）、E-03（196-211行目） | ○ |
| C-05 | パスワードリセット機能を提供 | E-01（223-242行目）、E-03（323-328行目） | ○ |
| C-06 | ロール割当機能を提供 | E-01（263-274行目）、E-03（310-316行目） | ○ |
| C-07 | ステータス変更機能を提供 | E-01（322-331行目）、E-03（590-594行目） | ○ |
| C-08 | Excelエクスポート機能を提供 | E-01（81-90行目） | ○ |
| C-09 | Excelインポート機能を提供 | E-01（92-102行目）、E-03（512-582行目） | ○ |
| C-10 | 権限アノテーション@RequiresPermissionsを使用 | E-01（64, 71, 82, 93, 104, 116, 128等の行） | ○ |
| C-11 | system:user:view権限が必要 | E-01（64行目） | ○ |
| C-12 | system:user:list権限が必要 | E-01（71行目） | ○ |
| C-13 | system:user:add権限が必要 | E-01（116, 128行目） | ○ |
| C-14 | system:user:edit権限が必要 | E-01（158, 187, 214, 247, 263, 322行目） | ○ |
| C-15 | system:user:remove権限が必要 | E-01（276行目） | ○ |
| C-16 | system:user:export権限が必要 | E-01（82行目） | ○ |
| C-17 | system:user:import権限が必要 | E-01（93行目） | ○ |
| C-18 | system:user:resetPwd権限が必要 | E-01（214, 223行目） | ○ |
| C-19 | 管理者操作禁止ルールが存在 | E-03（441-448行目）checkUserAllowed | ○ |
| C-20 | 自己削除禁止ルールが存在 | E-01（282-285行目） | ○ |
| C-21 | ログイン名一意性チェック | E-03（388-398行目）、E-05（141-143行目） | ○ |
| C-22 | 電話番号一意性チェック | E-03（406-416行目）、E-05（145-147行目） | ○ |
| C-23 | メールアドレス一意性チェック | E-03（424-434行目）、E-05（149-151行目） | ○ |
| C-24 | データスコープ制限機能 | E-03（455-468行目）checkUserDataScope、E-03（81行目）@DataScope | ○ |
| C-25 | 論理削除を採用（del_flag='2'） | E-05（159-160行目）、E-05（163-167行目） | ○ |
| C-26 | パスワード暗号化（MD5+Salt） | E-01（148-150行目）、E-03（534行目） | ○ |
| C-27 | sys_userテーブルを操作 | E-05（5行目namespace、全SQL） | ○ |
| C-28 | sys_user_roleテーブルを操作 | E-03（184, 207, 257, 314行目） | ○ |
| C-29 | sys_user_postテーブルを操作 | E-03（186, 209, 261行目） | ○ |
| C-30 | トランザクション管理（@Transactional） | E-03（180, 197, 220, 252, 311行目） | ○ |
| C-31 | 関連画面No.9-15が存在 | E-07（該当行） | ○ |
| C-32 | バリデーションアノテーション使用 | E-02（160-162, 173-174, 195-196, 207行目等） | ○ |
| C-33 | XSS防止アノテーション使用 | E-02（160, 173行目）@Xss | ○ |
| C-34 | 1ページあたり最大100件のページング | **根拠なし** | △ |
| C-35 | Excelインポート件数制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-34**: ページングの最大件数設定はコード上で確認できず。設定ファイルまたはフロントエンド側で制御されている可能性がある。
  - 候補：application.yml / フロントエンドJavaScript / BaseController.java
- **C-35**: Excelインポートの件数制限について明示的なチェックコードは見当たらない。メモリ制限等で暗黙的に制限される可能性がある。
  - 候補：ExcelUtil.java / application.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様、権限制御、ビジネスルールは十分に根拠あり
- 1: 中リスク - パフォーマンス要件の具体値は要確認
- 0: 低リスク - セキュリティ関連（パスワード暗号化、XSS対策等）は根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 権限文字列（system:user:xxx）がメニューマスタと一致しているか確認
- [ ] 管理者操作禁止のuserIdが環境によって異なる可能性がないか確認
- [ ] パスワード暗号化方式（MD5+Salt）がセキュリティ要件を満たすか確認（最新の推奨はbcrypt等）
- [ ] ページングの最大件数がどこで設定されているか確認
- [ ] Excelインポート時の大量データ対応について確認
