---
generated_at: 2026-01-08 14:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-ログインログ機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java`
- E-02: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysLogininforServiceImpl.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysLogininforMapper.xml`
- E-05: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログインログ一覧の検索・表示機能を提供 | E-01 (45-53行目) | ○ |
| C-02 | ExcelエクスポートはExcelUtilを使用 | E-01 (55-64行目) | ○ |
| C-03 | 削除にはmonitor:logininfor:remove権限が必要 | E-01 (66行目) | ○ |
| C-04 | クリア処理はTRUNCATE TABLEを使用 | E-04 (52-54行目) | ○ |
| C-05 | アカウントロック解除はキャッシュ削除で実現 | E-05 (76-79行目) | ○ |
| C-06 | SysLogininforエンティティにはinfoId, loginName等のフィールドがある | E-02 (19-53行目) | ○ |
| C-07 | 検索はユーザー名、IPアドレス、ステータス、日時範囲で絞り込み可能 | E-04 (24-43行目) | ○ |
| C-08 | ユーザー名とIPアドレスは部分一致検索 | E-04 (27-35行目) | ○ |
| C-09 | 画面No.60がログインログ一覧画面 | E-06 | ○ |
| C-10 | 機能No.11がログインログ機能 | E-07 | ○ |
| C-11 | SysLogininforServiceImplがサービス実装クラス | E-03 | ○ |
| C-12 | deleteLogininforByIdsはConvert.toStrArrayを使用 | E-03 (55行目) | ○ |
| C-13 | @Logアノテーションで操作ログを記録 | E-01 (55, 67, 76, 86行目) | ○ |
| C-14 | @RequiresPermissionsで権限制御 | E-01 (38, 45, 56, 66, 75, 85行目) | ○ |
| C-15 | SysPasswordServiceを使用してロック解除 | E-01 (35-36, 91行目) | ○ |
| C-16 | BaseControllerを継承 | E-01 (28行目) | ○ |
| C-17 | リクエストマッピングは/monitor/logininfor | E-01 (27行目) | ○ |
| C-18 | @Excelアノテーションでエクスポート設定 | E-02 (20-52行目) | ○ |
| C-19 | statusは0が成功、1が失敗 | E-02 (27-29行目) | ○ |
| C-20 | loginTimeは日時フォーマットyyyy-MM-dd HH:mm:ss | E-02 (52行目) | ○ |
| C-21 | insertLogininforはsysdate()を使用 | E-04 (19-22行目) | ○ |
| C-22 | resultMapでカラムマッピング定義 | E-04 (7-17行目) | ○ |
| C-23 | cleanLogininforはtruncateを実行 | E-04 (52-54行目) | ○ |
| C-24 | clearLoginRecordCacheでキャッシュ削除 | E-05 (76-79行目) | ○ |
| C-25 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値（1秒以内、5秒以内など）はソースコードからは確認できない
  - 候補：性能要件定義書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張にソースコードからの明確な根拠あり
- 1: 中リスク - パフォーマンス要件は推測値のため、実運用環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定（@RequiresPermissions）が適切か確認
- [ ] TRUNCATE TABLE使用のリスクを理解しているか確認
- [ ] アカウントロック解除の影響範囲を確認
- [ ] パフォーマンス要件の妥当性を確認
