---
generated_at: 2026-01-08 14:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-オンラインユーザー機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java`
- E-02: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserOnline.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserOnlineServiceImpl.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysUserOnlineMapper.xml`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | オンラインユーザー一覧の表示機能を提供 | E-01 (49-57行目) | ○ |
| C-02 | 強制ログアウト機能を提供 | E-01 (59-87行目) | ○ |
| C-03 | monitor:online:view権限で画面閲覧可能 | E-01 (42行目) | ○ |
| C-04 | monitor:online:forceLogout権限で強制ログアウト可能 | E-01 (59行目) | ○ |
| C-05 | 自分自身のセッションは強制ログアウト不可 | E-01 (77-80行目) | ○ |
| C-06 | 既にオフラインのセッションはエラー | E-01 (67-76行目) | ○ |
| C-07 | SysUserOnlineにsessionId, deptName等のフィールドがある | E-02 (18-49行目) | ○ |
| C-08 | OnlineStatusはデフォルトでon_line | E-02 (49行目) | ○ |
| C-09 | 画面No.51がオンラインユーザー一覧画面 | E-05 | ○ |
| C-10 | 機能No.12がオンラインユーザー機能 | E-06 | ○ |
| C-11 | removeUserCacheでEhCacheからキャッシュ削除 | E-03 (117-127行目) | ○ |
| C-12 | selectOnlineByIdでセッションID指定取得 | E-03 (37-40行目) | ○ |
| C-13 | saveOnlineでセッション情報を保存 | E-03 (83-86行目) | ○ |
| C-14 | OnlineSessionDAOを使用してShiroセッション操作 | E-01 (39-40, 72, 81行目) | ○ |
| C-15 | SYS_USERCACHEキャッシュを使用 | E-03 (120行目) | ○ |
| C-16 | BaseControllerを継承 | E-01 (32行目) | ○ |
| C-17 | リクエストマッピングは/monitor/online | E-01 (31行目) | ○ |
| C-18 | @Log(businessType = BusinessType.FORCE) | E-01 (60行目) | ○ |
| C-19 | Convert.toStrArrayでIDリスト変換 | E-01 (65行目) | ○ |
| C-20 | ShiroUtils.getSessionIdで自セッションID取得 | E-01 (77行目) | ○ |
| C-21 | エラーメッセージは中国語 | E-01 (70, 75, 79行目) | ○ |
| C-22 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はソースコードからは確認できない
  - 候補：性能要件定義書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張にソースコードからの明確な根拠あり
- 1: 中リスク - エラーメッセージが中国語のため、日本語環境での確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定（@RequiresPermissions）が適切か確認
- [ ] 自己強制ログアウト禁止のロジックが正しいか確認
- [ ] EhCacheのキャッシュ削除が正しく動作するか確認
- [ ] 一括強制ログアウト時の部分失敗のハンドリングを確認
