---
generated_at: 2026-01-08 14:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-サーバー監視機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/ServerController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CPU、メモリ、JVM、ディスク情報を表示する | E-02 (36-57行目) | ○ |
| C-02 | OSHIライブラリを使用して情報取得 | E-02 (14-22行目 import文) | ○ |
| C-03 | monitor:server:view権限で画面閲覧可能 | E-01 (22行目) | ○ |
| C-04 | OSHI_WAIT_SECOND = 1000ms | E-02 (32行目) | ○ |
| C-05 | copyTo()メソッドで情報収集 | E-02 (109-123行目) | ○ |
| C-06 | setCpuInfo()でCPU情報収集 | E-02 (128-149行目) | ○ |
| C-07 | CPU使用率は1秒サンプリング | E-02 (131-132行目) Util.sleep(OSHI_WAIT_SECOND) | ○ |
| C-08 | setMemInfo()でメモリ情報収集 | E-02 (154-159行目) | ○ |
| C-09 | setSysInfo()でシステム情報収集 | E-02 (164-172行目) | ○ |
| C-10 | setJvmInfo()でJVM情報収集 | E-02 (177-185行目) | ○ |
| C-11 | setSysFiles()でディスク情報収集 | E-02 (190-209行目) | ○ |
| C-12 | ファイルサイズは自動フォーマット | E-02 (217-239行目) convertFileSize() | ○ |
| C-13 | 画面No.61がサーバー監視画面 | E-03 | ○ |
| C-14 | 機能No.13がサーバー監視機能 | E-04 | ○ |
| C-15 | BaseControllerを継承 | E-01 (18行目) | ○ |
| C-16 | リクエストマッピングは/monitor/server | E-01 (17行目) | ○ |
| C-17 | ModelMapにserverを設定 | E-01 (28行目) | ○ |
| C-18 | Runtime.getRuntime()でJVM情報取得 | E-02 (180-182行目) | ○ |
| C-19 | System.getProperties()でプロパティ取得 | E-02 (166, 179行目) | ○ |
| C-20 | Arith.mul/divで精密計算 | E-02 (206行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] OSHIライブラリの依存関係が正しく設定されているか確認
- [ ] 1秒のCPUサンプリング待機がユーザー体験に影響しないか確認
- [ ] ディスク情報の取得で大量のマウントポイントがある場合のパフォーマンスを確認
