---
generated_at: 2026-01-08 14:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-キャッシュ監視機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/CacheController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/CacheService.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャッシュ名一覧の取得機能を提供 | E-01 (29-35行目), E-02 (23-27行目) | ○ |
| C-02 | キー一覧取得機能を提供 | E-01 (45-52行目), E-02 (35-38行目) | ○ |
| C-03 | 値取得機能を提供 | E-01 (54-62行目), E-02 (47-50行目) | ○ |
| C-04 | キャッシュ名指定クリア機能を提供 | E-01 (64-71行目), E-02 (57-60行目) | ○ |
| C-05 | キー指定クリア機能を提供 | E-01 (73-80行目), E-02 (68-71行目) | ○ |
| C-06 | 全キャッシュクリア機能を提供 | E-01 (82-89行目), E-02 (76-83行目) | ○ |
| C-07 | monitor:cache:view権限で全操作可能 | E-01 (29, 37, 45, 54, 64, 73, 82行目) | ○ |
| C-08 | SYS_AUTH_CACHEを除外 | E-02 (26行目) ArrayUtils.removeElement | ○ |
| C-09 | キー一覧はTreeSetでソート | E-02 (37行目) new TreeSet<> | ○ |
| C-10 | 画面No.62がキャッシュ監視画面 | E-03 | ○ |
| C-11 | 機能No.14がキャッシュ監視機能 | E-04 | ○ |
| C-12 | BaseControllerを継承 | E-01 (22行目) | ○ |
| C-13 | リクエストマッピングは/monitor/cache | E-01 (21行目) | ○ |
| C-14 | CacheServiceをAutowired | E-01 (26-27行目) | ○ |
| C-15 | Thymeleafフラグメントを返却 | E-01 (42, 51, 61行目) ::fragment-* | ○ |
| C-16 | clearAllで各キャッシュを順次クリア | E-02 (78-82行目) forループ | ○ |
| C-17 | CacheUtils.getCacheNames()を使用 | E-02 (25行目) | ○ |
| C-18 | AjaxResult.success()を返却 | E-01 (70, 79, 88行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] SYS_AUTH_CACHEの除外が正しく動作するか確認
- [ ] キャッシュクリア時のデータ整合性への影響を確認
- [ ] 大量のキーがある場合のパフォーマンスを確認
- [ ] キャッシュ値にセンシティブ情報が含まれないか確認
