---
generated_at: 2026-01-08 14:55:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-データ監視機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/DruidController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/DruidConfig.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /druid/index.htmlへリダイレクトする | E-01 (24行目) redirect(prefix + "/index.html") | ○ |
| C-02 | monitor:data:view権限で閲覧可能 | E-01 (20行目) @RequiresPermissions | ○ |
| C-03 | リクエストマッピングは/monitor/data | E-01 (16行目) @RequestMapping | ○ |
| C-04 | BaseControllerを継承 | E-01 (17行目) extends BaseController | ○ |
| C-05 | prefixは/druid | E-01 (18行目) | ○ |
| C-06 | 機能No.15がデータ監視機能 | E-03 | ○ |
| C-07 | DruidConfigでデータソース設定 | E-02 | ○ |
| C-08 | コントローラーは非常にシンプル | E-01 (全27行のみ) | ○ |
| C-09 | Druidの監視機能と連携 | E-01, E-02 | ○ |
| C-10 | GETリクエストで処理 | E-01 (21行目) @GetMapping | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの明確な根拠あり
- 注意: Druid監視画面自体のアクセス制御はDruidConfig側で設定されるため、そちらの確認も必要

## 6) レビュアーチェックリスト（最小）
- [ ] Druid監視画面の認証設定が適切か確認（DruidConfig）
- [ ] Druid監視画面でセンシティブなSQL情報が露出しないか確認
- [ ] 本番環境でのDruid監視機能の有効/無効設定を確認
