---
generated_at: 2026-01-08 15:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-定期タスク管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java`
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobServiceImpl.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タスク一覧の表示・検索機能を提供 | E-01 (51-59行目) | ○ |
| C-02 | 新規タスクの登録機能を提供 | E-01 (131-163行目) | ○ |
| C-03 | タスクの編集機能を提供 | E-01 (179-210行目) | ○ |
| C-04 | タスクの削除機能を提供 | E-01 (72-80行目) | ○ |
| C-05 | ステータス変更機能を提供 | E-01 (94-103行目) | ○ |
| C-06 | 即時実行機能を提供 | E-01 (108-116行目) | ○ |
| C-07 | Cron式検証機能を提供 | E-01 (215-220行目) | ○ |
| C-08 | Excelエクスポート機能を提供 | E-01 (61-70行目) | ○ |
| C-09 | jobNameは最大64文字、空白不可 | E-02 (66-68行目) | ○ |
| C-10 | invokeTargetは最大1000文字 | E-02 (88-89行目) | ○ |
| C-11 | cronExpressionは最大255文字 | E-02 (100-101行目) | ○ |
| C-12 | misfirePolicyのデフォルトはMISFIRE_DEFAULT | E-02 (46行目) | ○ |
| C-13 | 新規登録時のステータスはPAUSE | E-03 (206行目) | ○ |
| C-14 | rmi呼び出しは禁止 | E-01 (141-144行目) | ○ |
| C-15 | ldap呼び出しは禁止 | E-01 (145-148行目) | ○ |
| C-16 | http呼び出しは禁止 | E-01 (149-152行目) | ○ |
| C-17 | ホワイトリストチェックを実行 | E-01 (157-160行目) | ○ |
| C-18 | @Transactionalでトランザクション管理 | E-03 (80, 100, 120, 140, 157, 179, 203, 221行目) | ○ |
| C-19 | @PostConstructでDB→Quartz同期 | E-03 (39-48行目) | ○ |
| C-20 | pauseJobでQuartzジョブを停止 | E-03 (80-92行目) | ○ |
| C-21 | resumeJobでQuartzジョブを再開 | E-03 (99-112行目) | ○ |
| C-22 | run()でscheduler.triggerJob()を呼び出し | E-03 (192行目) | ○ |
| C-23 | updateSchedulerJobでジョブ再作成 | E-03 (239-250行目) | ○ |
| C-24 | getNextValidTime()で次回実行時刻取得 | E-02 (112-119行目) | ○ |
| C-25 | 画面No.52-55,57が関連画面 | E-04 | ○ |
| C-26 | 機能No.16が定期タスク管理機能 | E-05 | ○ |
| C-27 | CronUtils.isValid()でCron式検証 | E-01 (137行目) | ○ |
| C-28 | scheduler.checkExists()でジョブ存在確認 | E-03 (189行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの明確な根拠あり
- セキュリティ関連のホワイトリスト・禁止文字列チェックは重要なので入念に確認

## 6) レビュアーチェックリスト（最小）
- [ ] ホワイトリストの設定が適切か確認（ScheduleUtils.whiteList）
- [ ] 禁止文字列のチェックが網羅的か確認
- [ ] トランザクション管理がDB操作とQuartz操作の両方をカバーしているか確認
- [ ] Cron式検証ロジックが正確か確認
- [ ] 起動時のDB→Quartz同期が正しく動作するか確認
