---
generated_at: 2026-01-08 15:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-コード生成機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-02: `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTable.java`
- E-03: `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTableColumn.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル一覧表示機能を提供 | E-01 (68-76行目) | ○ |
| C-02 | テーブルインポート機能を提供 | E-01 (128-140行目) | ○ |
| C-03 | SQL実行でテーブル作成機能を提供 | E-01 (197-228行目) | ○ |
| C-04 | コードプレビュー機能を提供 | E-01 (233-240行目) | ○ |
| C-05 | コード生成（ZIP）機能を提供 | E-01 (247-252行目) | ○ |
| C-06 | コード生成（ローカル）機能を提供 | E-01 (257-269行目) | ○ |
| C-07 | DB同期機能を提供 | E-01 (274-282行目) | ○ |
| C-08 | tool:gen:view権限で画面閲覧可能 | E-01 (58行目) | ○ |
| C-09 | admin ロールでテーブル作成可能 | E-01 (195行目) @RequiresRoles("admin") | ○ |
| C-10 | GenConfig.isAllowOverwrite()でローカル出力制御 | E-01 (263-266行目) | ○ |
| C-11 | tableNameは空白不可 | E-02 (24行目) @NotBlank | ○ |
| C-12 | classNameは空白不可 | E-02 (38-39行目) @NotBlank | ○ |
| C-13 | tplCategoryでテンプレート種別を指定 | E-02 (42行目) | ○ |
| C-14 | isSub/isTree/isCrud判定メソッドがある | E-02 (341-369行目) | ○ |
| C-15 | SqlUtil.filterKeyword()でSQL検証 | E-01 (203行目) | ○ |
| C-16 | MySqlCreateTableStatementで解析 | E-01 (208行目) | ○ |
| C-17 | 画面No.63-67が関連画面 | E-04 | ○ |
| C-18 | 機能No.18がコード生成機能 | E-05 | ○ |
| C-19 | genPathでローカル出力先指定 | E-02 (71行目) | ○ |
| C-20 | genTypeで生成方式指定（0:ZIP、1:ローカル） | E-02 (68行目) | ○ |
| C-21 | columnsでカラム情報リスト保持 | E-02 (81行目) | ○ |
| C-22 | @Validでカラムリストをバリデーション | E-02 (80行目) | ○ |
| C-23 | subTableName/subTableFkNameで主従表設定 | E-02 (32-35行目) | ○ |
| C-24 | parentMenuId/parentMenuNameでメニュー設定 | E-02 (96-99行目) | ○ |
| C-25 | Convert.toStrArray()でテーブル名配列変換 | E-01 (134行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの明確な根拠あり
- SQL実行機能は高リスクのため、権限制御とSQLフィルタリングの確認が重要

## 6) レビュアーチェックリスト（最小）
- [ ] SqlUtil.filterKeyword()のフィルタリングが十分か確認
- [ ] admin ロール制限が適切に機能するか確認
- [ ] GenConfig.isAllowOverwrite()の設定値を確認
- [ ] Velocityテンプレートにセキュリティ問題がないか確認
- [ ] 生成されるコードの品質・セキュリティを確認
