---
generated_at: 2026-01-08 15:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-ログイン機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java`
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-04: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/realm/UserRealm.java`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面表示機能を提供 | E-01 (40-53行目) @GetMapping("/login") | ○ |
| C-02 | Ajaxリクエスト時はJSONエラーを返却 | E-01 (44-47行目) isAjaxRequest判定 | ○ |
| C-03 | 「記憶する」機能設定を読み込み | E-01 (34-35行目) @Value shiro.rememberMe.enabled | ○ |
| C-04 | ユーザー登録許可設定を読み込み | E-01 (51行目) sys.account.registerUser | ○ |
| C-05 | POSTでログイン認証を実行 | E-01 (55-75行目) @PostMapping("/login") | ○ |
| C-06 | UsernamePasswordTokenで認証 | E-01 (59行目) new UsernamePasswordToken | ○ |
| C-07 | Subject.login()でShiro認証を実行 | E-01 (63行目) subject.login(token) | ○ |
| C-08 | AuthenticationException捕捉してエラー返却 | E-01 (66-73行目) catch AuthenticationException | ○ |
| C-09 | キャプチャ検証を実行 | E-02 (57-61行目) CAPTCHA_ERROR判定 | ○ |
| C-10 | ユーザー名・パスワード空チェック | E-02 (63-67行目) StringUtils.isEmpty | ○ |
| C-11 | パスワード長さを5-20文字で検証 | E-02 (69-74行目) PASSWORD_MIN/MAX_LENGTH | ○ |
| C-12 | ユーザー名長さを2-20文字で検証 | E-02 (77-82行目) USERNAME_MIN/MAX_LENGTH | ○ |
| C-13 | IPブラックリストチェックを実行 | E-02 (85-90行目) sys.login.blackIPList | ○ |
| C-14 | ユーザー情報をDBから取得 | E-02 (93行目) selectUserByLoginName | ○ |
| C-15 | ユーザー未存在時はUserNotExistsException | E-02 (107-111行目) throw UserNotExistsException | ○ |
| C-16 | 削除済みユーザーはUserDeleteException | E-02 (113-117行目) UserStatus.DELETED判定 | ○ |
| C-17 | 無効化ユーザーはUserBlockedException | E-02 (119-123行目) UserStatus.DISABLE判定 | ○ |
| C-18 | パスワード検証はpasswordService.validate | E-02 (125行目) passwordService.validate | ○ |
| C-19 | 認証成功時にログイン記録を非同期実行 | E-02 (127行目) AsyncFactory.recordLogininfor | ○ |
| C-20 | 認証成功時に権限設定を実行 | E-02 (128行目) setRolePermission | ○ |
| C-21 | ログイン情報（IP、日時）を更新 | E-02 (129行目, 180-183行目) recordLoginInfo | ○ |
| C-22 | 権限エラー画面への遷移処理 | E-01 (77-81行目) @GetMapping("/unauth") | ○ |
| C-23 | 画面No.1がログイン画面 | E-05 | ○ |
| C-24 | 機能No.19がログイン機能 | E-06 | ○ |
| C-25 | BlackListExceptionでIPブロック | E-02 (89行目) throw new BlackListException | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの明確な根拠あり
- ログイン機能はセキュリティの要であるため、Shiro設定とパスワードポリシーの確認が重要

## 6) レビュアーチェックリスト（最小）
- [ ] キャプチャ設定が適切に有効化されているか確認
- [ ] パスワード試行回数制限の設定値を確認
- [ ] IPブラックリスト設定の運用方針を確認
- [ ] パスワードハッシュ化方式（MD5+ソルト）の妥当性を確認
- [ ] セッション管理の設定（タイムアウト等）を確認
- [ ] rememberMe機能の安全性を確認
