---
generated_at: 2026-01-08 15:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ロール管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `SysRoleController.java` (ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/)
- E-02: `SysRole.java` (ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/)
- E-03: `SysRoleServiceImpl.java` (ruoyi-system/src/main/java/com/ruoyi/system/service/impl/)
- E-04: `SysRoleMapper.java` (ruoyi-system/src/main/java/com/ruoyi/system/mapper/)
- E-05: `SysRoleMenuMapper.java` (ruoyi-system/src/main/java/com/ruoyi/system/mapper/)
- E-06: `SysRoleDeptMapper.java` (ruoyi-system/src/main/java/com/ruoyi/system/mapper/)
- E-07: `画面機能マッピング.csv` (docs/code-to-docs/画面機能マッピング/)
- E-08: `機能一覧.csv` (docs/code-to-docs/機能一覧/)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ロール一覧取得機能を提供 | E-01（56-64行目）、E-03（54-59行目） | ○ |
| C-02 | ロール新規登録機能を提供 | E-01（90-108行目）、E-03（181-188行目） | ○ |
| C-03 | ロール編集機能を提供 | E-01（125-144行目）、E-03（196-205行目） | ○ |
| C-04 | ロール削除機能を提供 | E-01（177-184行目）、E-03（153-173行目） | ○ |
| C-05 | データ権限設定機能を提供 | E-01（160-175行目）、E-03（213-223行目） | ○ |
| C-06 | ユーザー割当機能を提供 | E-01（302-313行目）、E-03（402-416行目） | ○ |
| C-07 | ユーザー割当解除機能を提供 | E-01（257-264行目）、E-03（376-380行目） | ○ |
| C-08 | ステータス変更機能を提供 | E-01（218-227行目）、E-03（364-368行目） | ○ |
| C-09 | Excelエクスポート機能を提供 | E-01（66-75行目） | ○ |
| C-10 | 権限アノテーション@RequiresPermissionsを使用 | E-01（49, 56, 67, 80, 90, 113, 125等の行） | ○ |
| C-11 | system:role:view権限が必要 | E-01（49行目） | ○ |
| C-12 | system:role:list権限が必要 | E-01（56行目） | ○ |
| C-13 | system:role:add権限が必要 | E-01（80, 90行目） | ○ |
| C-14 | system:role:edit権限が必要 | E-01（113, 125, 160, 218, 232, 257, 269, 305, 318行目） | ○ |
| C-15 | system:role:remove権限が必要 | E-01（177行目） | ○ |
| C-16 | system:role:export権限が必要 | E-01（67行目） | ○ |
| C-17 | 管理者ロール操作禁止ルールが存在 | E-03（314-321行目）checkRoleAllowed | ○ |
| C-18 | 割当済みロール削除禁止ルールが存在 | E-03（163-166行目）countUserRoleByRoleId | ○ |
| C-19 | ロール名一意性チェック | E-03（279-289行目） | ○ |
| C-20 | 権限文字列一意性チェック | E-03（297-307行目） | ○ |
| C-21 | データスコープ制限機能 | E-03（328-344行目）checkRoleDataScope、E-03（55行目）@DataScope | ○ |
| C-22 | 論理削除を採用 | E-03（172行目）deleteRoleByIds | ○ |
| C-23 | sys_roleテーブルを操作 | E-03（37, 58, 127, 144, 172, 186, 201, 218行目等） | ○ |
| C-24 | sys_role_menuテーブルを操作 | E-03（40, 141, 169, 203, 244行目） | ○ |
| C-25 | sys_role_deptテーブルを操作 | E-03（46, 143, 171, 220, 268行目） | ○ |
| C-26 | sys_user_roleテーブルを操作 | E-03（43, 355, 379, 392, 415行目） | ○ |
| C-27 | トランザクション管理（@Transactional） | E-03（137, 154, 182, 197, 214行目） | ○ |
| C-28 | 関連画面No.19-24が存在 | E-07（該当行） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対して根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様、権限制御、ビジネスルールは十分に根拠あり
- 0: 低リスク - データベース操作仕様は根拠あり
- 0: 低リスク - トランザクション管理は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 権限文字列（system:role:xxx）がメニューマスタと一致しているか確認
- [ ] 管理者ロール操作禁止のroleIdが環境によって異なる可能性がないか確認
- [ ] データスコープの5種類の値が要件を満たしているか確認
- [ ] ユーザー割当状態の確認ロジックが正しく動作するか確認
