---
generated_at: 2026-01-08 15:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-ユーザー登録機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysRegisterService.java`
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java`
- E-05: `sql/ry_20250416.sql`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 登録画面表示機能を提供 | E-01 (29-33行目) @GetMapping("/register") | ○ |
| C-02 | POSTで登録処理を実行 | E-01 (35-45行目) @PostMapping("/register") | ○ |
| C-03 | 登録機能有効性をチェック | E-01 (39-42行目) sys.account.registerUser | ○ |
| C-04 | 機能無効時はエラーを返却 | E-01 (41行目) "当前系统没有开启注册功能" | ○ |
| C-05 | SysRegisterService.register()を呼び出し | E-01 (43行目) registerService.register | ○ |
| C-06 | キャプチャ検証を実行 | E-02 (39-42行目) CAPTCHA_ERROR判定 | ○ |
| C-07 | ユーザー名空チェック | E-02 (43-46行目) StringUtils.isEmpty(loginName) | ○ |
| C-08 | パスワード空チェック | E-02 (47-50行目) StringUtils.isEmpty(password) | ○ |
| C-09 | パスワード長さを5-20文字で検証 | E-02 (51-55行目) PASSWORD_MIN/MAX_LENGTH | ○ |
| C-10 | ユーザー名長さを2-20文字で検証 | E-02 (56-60行目) USERNAME_MIN/MAX_LENGTH | ○ |
| C-11 | ユーザー名重複チェック | E-02 (61-64行目) checkLoginNameUnique | ○ |
| C-12 | パスワード更新日を設定 | E-02 (67行目) setPwdUpdateDate | ○ |
| C-13 | userNameにloginNameと同じ値を設定 | E-02 (68行目) setUserName(loginName) | ○ |
| C-14 | ソルトを生成 | E-02 (69行目) ShiroUtils.randomSalt() | ○ |
| C-15 | パスワードをハッシュ化 | E-02 (70行目) encryptPassword | ○ |
| C-16 | userService.registerUserでDB登録 | E-02 (71行目) userService.registerUser | ○ |
| C-17 | 登録成功時に非同期ログ記録 | E-02 (78行目) AsyncFactory.recordLogininfor | ○ |
| C-18 | ユーザータイプを'01'に設定 | E-04 (241行目) REGISTER_USER_TYPE | ○ |
| C-19 | デフォルトでは登録機能無効（false） | E-05 (545行目) 'false' | ○ |
| C-20 | 画面No.2がユーザー登録画面 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの明確な根拠あり
- 登録機能はデフォルト無効だが、有効化時のセキュリティリスクを考慮すべき

## 6) レビュアーチェックリスト（最小）
- [ ] sys.account.registerUser設定の運用方針を確認
- [ ] キャプチャ設定が適切に有効化されているか確認
- [ ] パスワードハッシュ化方式（MD5+ソルト）の妥当性を確認
- [ ] 登録ユーザーに付与されるデフォルト権限を確認
- [ ] 大量の不正登録に対する保護策を確認（レート制限など）
- [ ] 登録ユーザータイプ（'01'）の利用方針を確認
