---
generated_at: 2026-01-08 14:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-キャプチャ生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **レスポンス時間要件100ms以内**：コードから導出困難な非機能要件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysCaptchaController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/CaptchaConfig.java`
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/KaptchaTextCreator.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /captcha/captchaImage | E-01 37-38行目 `@GetMapping(value = "/captchaImage")` | ○ |
| C-02 | typeパラメータでmath/charを指定可能 | E-01 50-65行目 if文による分岐処理 | ○ |
| C-03 | 算術式タイプは@記号で表示テキストと正解を分離 | E-01 57-58行目、E-03 73行目 `suChinese.append("=?@" + result)` | ○ |
| C-04 | セッションにKAPTCHA_SESSION_KEYで正解を保存 | E-01 66行目 `session.setAttribute(Constants.KAPTCHA_SESSION_KEY, code)` | ○ |
| C-05 | 画像はJPEG形式で出力 | E-01 48行目 `response.setContentType("image/jpeg")` | ○ |
| C-06 | キャッシュ無効化ヘッダーを設定 | E-01 44-47行目 Cache-Control, Pragma設定 | ○ |
| C-07 | 画像サイズは160x60ピクセル | E-02 28-30行目 `KAPTCHA_IMAGE_WIDTH, "160"` `KAPTCHA_IMAGE_HEIGHT, "60"` | ○ |
| C-08 | 文字タイプは4文字 | E-02 36行目 `KAPTCHA_TEXTPRODUCER_CHAR_LENGTH, "4"` | ○ |
| C-09 | 算術式タイプは6文字表示 | E-02 70行目 `KAPTCHA_TEXTPRODUCER_CHAR_LENGTH, "6"` | ○ |
| C-10 | ShadowGimpyスタイルを使用 | E-02 40行目、78行目 `KAPTCHA_OBSCURIFICATOR_IMPL, "ShadowGimpy"` | ○ |
| C-11 | 算術式は加減乗除のランダム選択 | E-03 24-72行目 randomoperandsによる分岐 | ○ |
| C-12 | SecureRandomを使用 | E-03 20行目 `Random random = new SecureRandom()` | ○ |
| C-13 | 減算は負数にならないよう制御 | E-03 51-64行目 x>=yの判定 | ○ |
| C-14 | 除算は割り切れる場合のみ | E-03 34行目 `y % x == 0` の条件 | ○ |
| C-15 | ログイン画面で使用 | E-04 2-3行目 画面No.1 ログイン画面との関連 | ○ |
| C-16 | ユーザー登録画面で使用 | E-04 5-6行目 画面No.2 ユーザー登録画面との関連 | ○ |
| C-17 | 機能説明は「ログイン用の画像認証コード生成機能を提供」 | E-05 22行目 No.21の説明文 | ○ |
| C-18 | レスポンス時間100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンス時間要件100ms以内はソースコードから直接確認できない非機能要件として記載
  - 候補：パフォーマンステスト結果 / 要件定義書 / 設計基準書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なコード実装との整合性は確認済み
- 1: 中リスク - パフォーマンス要件は推定値のため、実測による検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 算術式キャプチャの@区切りロジックがKaptchaTextCreator.javaと整合しているか確認
- [ ] セッションキー名（Constants.KAPTCHA_SESSION_KEY）がログイン検証側と一致しているか確認
- [ ] パフォーマンス要件100msの妥当性を確認（要実測または要件確認）
