---
generated_at: 2026-01-08 14:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：22-プロファイル管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（各処理のレスポンス時間）**：コードから導出困難な非機能要件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java`
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java`
- E-05: `ruoyi-common/src/main/java/com/ruoyi/common/utils/file/FileUploadUtils.java`
- E-06: `ruoyi-common/src/main/java/com/ruoyi/common/utils/file/FileUtils.java`
- E-07: `ruoyi-common/src/main/java/com/ruoyi/common/config/RuoYiConfig.java`
- E-08: `ruoyi-common/src/main/java/com/ruoyi/common/utils/file/MimeTypeUtils.java`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /system/user/profile | E-01 34行目 `@RequestMapping("/system/user/profile")` | ○ |
| C-02 | profile()でユーザー情報、ロールグループ、役職グループを取得 | E-01 50-58行目 | ○ |
| C-03 | checkPassword()でパスワード照合APIを提供 | E-01 60-66行目 | ○ |
| C-04 | resetPwd()で旧パスワード照合を行う | E-01 82-85行目 `if (!passwordService.matches(user, oldPassword))` | ○ |
| C-05 | 新旧パスワード同一チェックを行う | E-01 86-89行目 `if (passwordService.matches(user, newPassword))` | ○ |
| C-06 | ShiroUtils.randomSalt()でソルト生成 | E-01 90行目 | ○ |
| C-07 | パスワード暗号化はMD5ハッシュ形式 | E-02 81-84行目 `new Md5Hash(loginName + password + salt).toHex()` | ○ |
| C-08 | update()で電話番号の一意性チェック | E-01 135-138行目 `checkPhoneUnique()` | ○ |
| C-09 | update()でメールの一意性チェック | E-01 139-142行目 `checkEmailUnique()` | ○ |
| C-10 | updateAvatar()でファイルアップロード処理 | E-01 164行目 `FileUploadUtils.upload()` | ○ |
| C-11 | アバターは画像形式のみ許可 | E-01 164行目 `MimeTypeUtils.IMAGE_EXTENSION`、E-08 20行目 | ○ |
| C-12 | 旧アバターファイルを削除 | E-01 167-171行目 `FileUtils.deleteFile()` | ○ |
| C-13 | アバター保存先は{profile}/avatar/ | E-07 104-107行目 `getAvatarPath()` | ○ |
| C-14 | selectUserRoleGroup()でロール名をカンマ区切りで取得 | E-04 476-485行目 | ○ |
| C-15 | selectUserPostGroup()で役職名をカンマ区切りで取得 | E-04 493-502行目 | ○ |
| C-16 | updateUserInfo()で個人情報を更新 | E-04 273-277行目 | ○ |
| C-17 | updateUserAvatar()でアバターパスを更新 | E-04 286-289行目 | ○ |
| C-18 | resetUserPwd()でパスワードを更新 | E-04 323-328行目 | ○ |
| C-19 | ファイルサイズ上限は50MB | E-05 29行目 `DEFAULT_MAX_SIZE = 50 * 1024 * 1024L` | ○ |
| C-20 | UUID形式でファイル名を生成 | E-05 152-155行目 `uuidFilename()` | ○ |
| C-21 | 関連画面はプロフィール画面、アバター変更、パスワード変更 | E-09 29-33行目 画面No.16,17,18との関連 | ○ |
| C-22 | 機能説明は「個人情報の表示、編集、パスワード変更、アバター更新機能を提供」 | E-10 23行目 No.22の説明文 | ○ |
| C-23 | @Logアノテーションで操作ログを記録 | E-01 76行目、125行目、154行目 | ○ |
| C-24 | パフォーマンス要件（レスポンス時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（プロファイル表示500ms、更新1s、アバター3s）はソースコードから直接確認できない非機能要件
  - 候補：パフォーマンステスト結果 / 要件定義書 / 設計基準書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なコード実装との整合性は確認済み
- 0: 低リスク - セキュリティ関連（パスワード暗号化、旧パスワード照合）はコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パスワード暗号化方式（MD5+Salt）がセキュリティ要件を満たしているか確認
- [ ] 旧アバターファイル削除処理でエラーが発生した場合のリカバリ処理を確認
- [ ] 電話番号・メールの一意性チェックロジックがSysUserServiceImpl.javaと整合しているか確認
- [ ] パフォーマンス要件の妥当性を確認（要実測または要件確認）
