---
generated_at: 2026-01-08 14:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：23-ファイルアップロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（ファイルサイズ別レスポンス時間）**：コードから導出困難な非機能要件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/common/CommonController.java`
- E-02: `ruoyi-common/src/main/java/com/ruoyi/common/utils/file/FileUploadUtils.java`
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/utils/file/MimeTypeUtils.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/config/RuoYiConfig.java`
- E-05: `ruoyi-common/src/main/java/com/ruoyi/common/config/ServerConfig.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 単一ファイルアップロードは POST /common/upload | E-01 75-76行目 `@PostMapping("/upload")` | ○ |
| C-02 | 複数ファイルアップロードは POST /common/uploads | E-01 102-103行目 `@PostMapping("/uploads")` | ○ |
| C-03 | ファイルサイズ上限は50MB | E-02 29行目 `DEFAULT_MAX_SIZE = 50 * 1024 * 1024L` | ○ |
| C-04 | ファイル名長さ上限は100文字 | E-02 34行目 `DEFAULT_FILE_NAME_LENGTH = 100` | ○ |
| C-05 | 許可拡張子はDEFAULT_ALLOWED_EXTENSIONで定義 | E-03 29-39行目 | ○ |
| C-06 | 画像形式はbmp,gif,jpg,jpeg,png | E-03 20行目 `IMAGE_EXTENSION` | ○ |
| C-07 | アップロード先は{profile}/upload | E-04 120-123行目 `getUploadPath()` | ○ |
| C-08 | serverConfig.getUrl()でサーバーURLを取得 | E-01 85行目、E-05 22-25行目 | ○ |
| C-09 | 複数ファイル結果はカンマ区切り | E-01 38行目 `FILE_DELIMETER = ","` | ○ |
| C-10 | extractFilename()で日付パス+ファイル名+シーケンス形式 | E-02 144-147行目 | ○ |
| C-11 | assertAllowed()でサイズと拡張子をチェック | E-02 186-224行目 | ○ |
| C-12 | FileSizeLimitExceededExceptionをスロー | E-02 192行目 | ○ |
| C-13 | FileNameLengthLimitExceededExceptionをスロー | E-02 129行目 | ○ |
| C-14 | InvalidExtensionExceptionをスロー | E-02 199-222行目 | ○ |
| C-15 | file.transferTo()でファイル保存 | E-02 137行目 | ○ |
| C-16 | getPathFileName()でRESOURCE_PREFIX付きパスを返却 | E-02 171-176行目 | ○ |
| C-17 | AjaxResult.success()でurl,fileName等を返却 | E-01 86-91行目 | ○ |
| C-18 | StringUtils.join()でカンマ区切り結合 | E-01 125-128行目 | ○ |
| C-19 | 関連画面はユーザー管理一覧、アバター変更 | E-06 14行目、32行目 | ○ |
| C-20 | 機能説明は「単一ファイル・複数ファイルのアップロード機能を提供」 | E-07 24行目 No.23の説明文 | ○ |
| C-21 | getAbsoluteFile()でディレクトリを作成 | E-02 157-169行目 | ○ |
| C-22 | パフォーマンス要件（サイズ別レスポンス時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（1MB以下1s、10MB5s、50MB30s）はソースコードから直接確認できない非機能要件
  - 候補：パフォーマンステスト結果 / 要件定義書 / 設計基準書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なコード実装との整合性は確認済み
- 0: 低リスク - セキュリティ関連（拡張子ホワイトリスト、サイズ制限）はコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] DEFAULT_ALLOWED_EXTENSIONの拡張子リストがセキュリティポリシーを満たしているか確認
- [ ] 50MBのファイルサイズ制限がサーバーリソースに対して適切か確認
- [ ] 複数ファイルアップロード時のリスト最大数制限の有無を確認
- [ ] パフォーマンス要件の妥当性を確認（要実測または要件確認）
