---
generated_at: 2026-01-08 14:50:00
metrics:
  claims_total: 21
  claims_with_evidence: 20
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：24-ファイルダウンロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：20 / 21、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（ファイルサイズ別レスポンス時間）**：コードから導出困難な非機能要件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/common/CommonController.java`
- E-02: `ruoyi-common/src/main/java/com/ruoyi/common/utils/file/FileUtils.java`
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/utils/file/MimeTypeUtils.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/config/RuoYiConfig.java`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 一般ファイルダウンロードは GET /common/download | E-01 46行目 `@GetMapping("/download")` | ○ |
| C-02 | リソースダウンロードは GET /common/download/resource | E-01 140行目 `@GetMapping("/download/resource")` | ○ |
| C-03 | deleteパラメータでダウンロード後削除を制御 | E-01 47行目、61-64行目 | ○ |
| C-04 | checkAllowDownload()でセキュリティチェック | E-01 51行目、145行目、E-02 153-169行目 | ○ |
| C-05 | ディレクトリトラバーサル（".."）を拒否 | E-02 156-159行目 `StringUtils.contains(resource, "..")` | ○ |
| C-06 | 許可拡張子はDEFAULT_ALLOWED_EXTENSIONで検証 | E-02 162行目、E-03 29-39行目 | ○ |
| C-07 | ダウンロードパスは{profile}/download/ | E-04 110-115行目 `getDownloadPath()` | ○ |
| C-08 | リソースパスはgetProfile() + stripPrefix(resource) | E-01 150-152行目 | ○ |
| C-09 | stripPrefix()でRESOURCE_PREFIXを除去 | E-02 113-116行目 | ○ |
| C-10 | Content-Typeはapplication/octet-stream | E-01 58行目、155行目 | ○ |
| C-11 | setAttachmentResponseHeader()でContent-Disposition設定 | E-01 59行目、156行目、E-02 213-226行目 | ○ |
| C-12 | percentEncode()でRFC 5987準拠エンコード | E-02 234-238行目 | ○ |
| C-13 | writeBytes()でファイル出力 | E-01 60行目、157行目、E-02 39-66行目 | ○ |
| C-14 | FileInputStreamで1KBバッファ読み込み | E-02 50-55行目 `byte[] b = new byte[1024]` | ○ |
| C-15 | deleteFile()でファイル削除 | E-01 63行目、E-02 124-134行目 | ○ |
| C-16 | FileNotFoundExceptionをスロー | E-02 47-48行目 | ○ |
| C-17 | エラー時は「下载文件失败」ログ出力 | E-01 68行目 `log.error("下载文件失败", e)` | ○ |
| C-18 | 関連画面は多数のExcelエクスポート画面 | E-05 15,35,56,60,65,69,78,83,86,89行目 | ○ |
| C-19 | 機能説明は「一般ファイル・リソースファイルのダウンロード機能を提供」 | E-06 25行目 No.24の説明文 | ○ |
| C-20 | 実ファイル名はtimestamp_形式から抽出 | E-01 55行目 `fileName.substring(fileName.indexOf("_") + 1)` | ○ |
| C-21 | パフォーマンス要件（サイズ別レスポンス時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（1MB以下1s、10MB5s、50MB30s）はソースコードから直接確認できない非機能要件
  - 候補：パフォーマンステスト結果 / 要件定義書 / 設計基準書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なコード実装との整合性は確認済み
- 0: 低リスク - セキュリティ関連（ディレクトリトラバーサル防止、拡張子検証）はコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] checkAllowDownload()の拡張子ホワイトリストが十分か確認
- [ ] delete=trueの場合のファイル削除処理が適切にエラーハンドリングされているか確認
- [ ] 大容量ファイルダウンロード時のメモリ使用量が適切か確認（1KBバッファ）
- [ ] パフォーマンス要件の妥当性を確認（要実測または要件確認）
