---
generated_at: 2026-01-08 16:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-メニュー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `SysMenuController.java` (ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/)
- E-02: `SysMenu.java` (ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/)
- E-03: `SysMenuServiceImpl.java` (ruoyi-system/src/main/java/com/ruoyi/system/service/impl/)
- E-04: `画面機能マッピング.csv` (docs/code-to-docs/画面機能マッピング/)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メニュー一覧取得機能を提供 | E-01（47-55行目） | ○ |
| C-02 | メニュー新規登録機能を提供 | E-01（103-116行目） | ○ |
| C-03 | メニュー編集機能を提供 | E-01（132-145行目） | ○ |
| C-04 | メニュー削除機能を提供 | E-01（59-76行目） | ○ |
| C-05 | 表示順序更新機能を提供 | E-01（150-156行目） | ○ |
| C-06 | アイコン選択機能を提供 | E-01（161-165行目） | ○ |
| C-07 | system:menu:view権限が必要 | E-01（40行目） | ○ |
| C-08 | system:menu:list権限が必要 | E-01（47行目） | ○ |
| C-09 | system:menu:add権限が必要 | E-01（81, 103行目） | ○ |
| C-10 | system:menu:edit権限が必要 | E-01（121, 132行目） | ○ |
| C-11 | system:menu:remove権限が必要 | E-01（61行目） | ○ |
| C-12 | 子メニュー存在時削除禁止 | E-01（66-69行目） | ○ |
| C-13 | ロール割当時削除禁止 | E-01（70-73行目） | ○ |
| C-14 | メニュー名一意性チェック | E-01（109-112行目、138-141行目） | ○ |
| C-15 | メニュー種別（M/C/F） | E-02（41行目）menuType | ○ |
| C-16 | 階層構造（children） | E-02（56行目） | ○ |
| C-17 | ロール用メニューツリー取得 | E-01（180-187行目） | ○ |
| C-18 | メニューツリー取得 | E-01（192-198行目） | ○ |
| C-19 | 認可キャッシュクリア実行 | E-01（74, 114, 143行目） | ○ |
| C-20 | 関連画面No.25-29が存在 | E-04（該当行） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対して根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様、権限制御は十分に根拠あり
- 0: 低リスク - ツリー構造管理は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] メニュー種別（M/C/F）の使い分けが正しいか確認
- [ ] permsフィールドの権限文字列がShiro設定と一致しているか確認
- [ ] メニュー削除が物理削除であることを確認し、運用上問題ないか検討
