---
generated_at: 2026-01-08 16:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-部門管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `SysDeptController.java` (ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/)
- E-02: `SysDept.java` (ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/)
- E-03: `SysDeptServiceImpl.java` (ruoyi-system/src/main/java/com/ruoyi/system/service/impl/)
- E-04: `画面機能マッピング.csv` (docs/code-to-docs/画面機能マッピング/)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 部門一覧取得機能を提供 | E-01（45-52行目） | ○ |
| C-02 | 部門新規登録機能を提供 | E-01（69-84行目） | ○ |
| C-03 | 部門編集機能を提供 | E-01（103-128行目） | ○ |
| C-04 | 部門削除機能を提供 | E-01（133-149行目） | ○ |
| C-05 | 部門ツリー取得機能を提供 | E-01（167-174行目, 176-188行目） | ○ |
| C-06 | system:dept:view権限が必要 | E-01（38行目） | ○ |
| C-07 | system:dept:list権限が必要 | E-01（45行目） | ○ |
| C-08 | system:dept:add権限が必要 | E-01（57, 72行目） | ○ |
| C-09 | system:dept:edit権限が必要 | E-01（89, 106行目） | ○ |
| C-10 | system:dept:remove権限が必要 | E-01（134行目） | ○ |
| C-11 | 下位部門存在時削除禁止 | E-01（139-142行目） | ○ |
| C-12 | ユーザー所属時削除禁止 | E-01（143-146行目） | ○ |
| C-13 | 部門名一意性チェック | E-01（78-81行目、114-117行目） | ○ |
| C-14 | 自己参照禁止チェック | E-01（118-121行目） | ○ |
| C-15 | 停用時子部門チェック | E-01（122-125行目） | ○ |
| C-16 | データスコープチェック実行 | E-01（93, 113, 147行目） | ○ |
| C-17 | ancestors（祖先ID列）を持つ | E-02（28行目） | ○ |
| C-18 | ルート部門の特別扱い（ID=100） | E-01（95-98行目） | ○ |
| C-19 | 非管理者の親部門デフォルト | E-01（61-64行目） | ○ |
| C-20 | 論理削除を採用 | E-02（49行目）delFlag | ○ |
| C-21 | 関連画面No.30-33が存在 | E-04（該当行） | ○ |
| C-22 | ツリー構造で除外ID指定可能 | E-01（176-188行目）excludeId | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対して根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様、権限制御は十分に根拠あり
- 0: 低リスク - ツリー構造・祖先ID列管理は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 祖先ID列（ancestors）の更新ロジックが正しく動作するか確認
- [ ] ルート部門（ID=100）の扱いが運用要件と一致しているか確認
- [ ] データスコープによる制限が正しく機能しているか確認
