---
generated_at: 2026-01-08 16:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-通知公告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `SysNoticeController.java` (ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/)
- E-02: `SysNotice.java` (ruoyi-system/src/main/java/com/ruoyi/system/domain/)
- E-03: `SysNoticeServiceImpl.java` (ruoyi-system/src/main/java/com/ruoyi/system/service/impl/)
- E-04: `画面機能マッピング.csv` (docs/code-to-docs/画面機能マッピング/)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知公告一覧取得機能を提供 | E-01（47-54行目） | ○ |
| C-02 | 通知公告新規登録機能を提供 | E-01（69-77行目） | ○ |
| C-03 | 通知公告編集機能を提供 | E-01（93-101行目） | ○ |
| C-04 | 通知公告削除機能を提供 | E-01（117-124行目） | ○ |
| C-05 | 通知公告詳細表示機能を提供 | E-01（106-112行目） | ○ |
| C-06 | system:notice:view権限が必要 | E-01（36行目） | ○ |
| C-07 | system:notice:list権限が必要 | E-01（46行目） | ○ |
| C-08 | system:notice:add権限が必要 | E-01（59, 69行目） | ○ |
| C-09 | system:notice:edit権限が必要 | E-01（82, 93行目） | ○ |
| C-10 | system:notice:remove権限が必要 | E-01（117行目） | ○ |
| C-11 | タイトルにXSSチェック実施 | E-02（49-51行目）@Xss, @NotBlank, @Size | ○ |
| C-12 | 通知タイプ（1:通知, 2:公告） | E-02（25行目）コメント | ○ |
| C-13 | ステータス（0:正常, 1:关闭） | E-02（31行目）コメント | ○ |
| C-14 | 関連画面No.47-50が存在 | E-04（該当行） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対して根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様、権限制御は十分に根拠あり
- 1: 中リスク - 通知公告削除が物理削除であることの運用上の影響を確認する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] 通知公告削除が物理削除であることを確認し、運用上問題ないか検討
- [ ] 公告内容（noticeContent）のHTMLサニタイズが適切に行われているか確認
- [ ] 公告表示画面でのXSS対策が十分か確認
