---
generated_at: 2026-01-08 12:00:00
metrics:
  claims_total: 71
  claims_with_evidence: 71
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：71 / 71、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全ての画面が実際のHTMLテンプレートファイルから確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/login.html`
- E-02: `ruoyi-admin/src/main/resources/templates/register.html`
- E-03: `ruoyi-admin/src/main/resources/templates/lock.html`
- E-04: `ruoyi-admin/src/main/resources/templates/index.html`
- E-05: `ruoyi-admin/src/main/resources/templates/index-topnav.html`
- E-06: `ruoyi-admin/src/main/resources/templates/main.html`
- E-07: `ruoyi-admin/src/main/resources/templates/main_v1.html`
- E-08: `ruoyi-admin/src/main/resources/templates/skin.html`
- E-09: `ruoyi-admin/src/main/resources/templates/system/user/user.html`
- E-10: `ruoyi-admin/src/main/resources/templates/system/user/add.html`
- E-11: `ruoyi-admin/src/main/resources/templates/system/user/edit.html`
- E-12: `ruoyi-admin/src/main/resources/templates/system/user/view.html`
- E-13: `ruoyi-admin/src/main/resources/templates/system/user/resetPwd.html`
- E-14: `ruoyi-admin/src/main/resources/templates/system/user/authRole.html`
- E-15: `ruoyi-admin/src/main/resources/templates/system/user/deptTree.html`
- E-16: `ruoyi-admin/src/main/resources/templates/system/user/profile/profile.html`
- E-17: `ruoyi-admin/src/main/resources/templates/system/user/profile/avatar.html`
- E-18: `ruoyi-admin/src/main/resources/templates/system/user/profile/resetPwd.html`
- E-19: `ruoyi-admin/src/main/resources/templates/system/role/role.html`
- E-20: `ruoyi-admin/src/main/resources/templates/system/role/add.html`
- E-21: `ruoyi-admin/src/main/resources/templates/system/role/edit.html`
- E-22: `ruoyi-admin/src/main/resources/templates/system/role/dataScope.html`
- E-23: `ruoyi-admin/src/main/resources/templates/system/role/authUser.html`
- E-24: `ruoyi-admin/src/main/resources/templates/system/role/selectUser.html`
- E-25: `ruoyi-admin/src/main/resources/templates/system/menu/menu.html`
- E-26: `ruoyi-admin/src/main/resources/templates/system/menu/add.html`
- E-27: `ruoyi-admin/src/main/resources/templates/system/menu/edit.html`
- E-28: `ruoyi-admin/src/main/resources/templates/system/menu/tree.html`
- E-29: `ruoyi-admin/src/main/resources/templates/system/menu/icon.html`
- E-30: `ruoyi-admin/src/main/resources/templates/system/dept/dept.html`
- E-31: `ruoyi-admin/src/main/resources/templates/system/dept/add.html`
- E-32: `ruoyi-admin/src/main/resources/templates/system/dept/edit.html`
- E-33: `ruoyi-admin/src/main/resources/templates/system/dept/tree.html`
- E-34: `ruoyi-admin/src/main/resources/templates/system/post/post.html`
- E-35: `ruoyi-admin/src/main/resources/templates/system/post/add.html`
- E-36: `ruoyi-admin/src/main/resources/templates/system/post/edit.html`
- E-37: `ruoyi-admin/src/main/resources/templates/system/dict/type/type.html`
- E-38: `ruoyi-admin/src/main/resources/templates/system/dict/type/add.html`
- E-39: `ruoyi-admin/src/main/resources/templates/system/dict/type/edit.html`
- E-40: `ruoyi-admin/src/main/resources/templates/system/dict/type/tree.html`
- E-41: `ruoyi-admin/src/main/resources/templates/system/dict/data/data.html`
- E-42: `ruoyi-admin/src/main/resources/templates/system/dict/data/add.html`
- E-43: `ruoyi-admin/src/main/resources/templates/system/dict/data/edit.html`
- E-44: `ruoyi-admin/src/main/resources/templates/system/config/config.html`
- E-45: `ruoyi-admin/src/main/resources/templates/system/config/add.html`
- E-46: `ruoyi-admin/src/main/resources/templates/system/config/edit.html`
- E-47: `ruoyi-admin/src/main/resources/templates/system/notice/notice.html`
- E-48: `ruoyi-admin/src/main/resources/templates/system/notice/add.html`
- E-49: `ruoyi-admin/src/main/resources/templates/system/notice/edit.html`
- E-50: `ruoyi-admin/src/main/resources/templates/system/notice/view.html`
- E-51: `ruoyi-admin/src/main/resources/templates/monitor/online/online.html`
- E-52: `ruoyi-quartz/src/main/resources/templates/monitor/job/job.html`
- E-53: `ruoyi-quartz/src/main/resources/templates/monitor/job/add.html`
- E-54: `ruoyi-quartz/src/main/resources/templates/monitor/job/edit.html`
- E-55: `ruoyi-quartz/src/main/resources/templates/monitor/job/detail.html`
- E-56: `ruoyi-quartz/src/main/resources/templates/monitor/job/jobLog.html`
- E-57: `ruoyi-quartz/src/main/resources/templates/monitor/job/cron.html`
- E-58: `ruoyi-admin/src/main/resources/templates/monitor/operlog/operlog.html`
- E-59: `ruoyi-admin/src/main/resources/templates/monitor/operlog/detail.html`
- E-60: `ruoyi-admin/src/main/resources/templates/monitor/logininfor/logininfor.html`
- E-61: `ruoyi-admin/src/main/resources/templates/monitor/server/server.html`
- E-62: `ruoyi-admin/src/main/resources/templates/monitor/cache/cache.html`
- E-63: `ruoyi-admin/src/main/resources/templates/tool/build/build.html`
- E-64: `ruoyi-generator/src/main/resources/templates/tool/gen/gen.html`
- E-65: `ruoyi-generator/src/main/resources/templates/tool/gen/importTable.html`
- E-66: `ruoyi-generator/src/main/resources/templates/tool/gen/createTable.html`
- E-67: `ruoyi-generator/src/main/resources/templates/tool/gen/edit.html`
- E-68: `ruoyi-admin/src/main/resources/templates/error/404.html`
- E-69: `ruoyi-admin/src/main/resources/templates/error/500.html`
- E-70: `ruoyi-admin/src/main/resources/templates/error/service.html`
- E-71: `ruoyi-admin/src/main/resources/templates/error/unauth.html`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面の存在と機能 | E-01 | ○ |
| C-02 | ユーザー登録画面の存在 | E-02 | ○ |
| C-03 | 画面ロック機能の存在 | E-03 | ○ |
| C-04 | システム首頁（左メニュー型）の存在 | E-04 | ○ |
| C-05 | システム首頁（トップナビ型）の存在 | E-05 | ○ |
| C-06 | メインコンテンツ画面の存在 | E-06 | ○ |
| C-07 | メインコンテンツ（v1）画面の存在 | E-07 | ○ |
| C-08 | テーマ切替画面の存在 | E-08 | ○ |
| C-09 | ユーザー管理一覧画面の存在と機能 | E-09 | ○ |
| C-10 | ユーザー新規登録画面の存在 | E-10 | ○ |
| C-11 | ユーザー編集画面の存在 | E-11 | ○ |
| C-12 | ユーザー詳細表示画面の存在 | E-12 | ○ |
| C-13 | ユーザーパスワードリセット画面の存在 | E-13 | ○ |
| C-14 | ユーザーロール割当画面の存在 | E-14 | ○ |
| C-15 | 部門ツリー選択画面の存在 | E-15 | ○ |
| C-16 | プロフィール画面の存在 | E-16 | ○ |
| C-17 | アバター変更画面の存在 | E-17 | ○ |
| C-18 | パスワード変更画面の存在 | E-18 | ○ |
| C-19 | ロール管理一覧画面の存在と機能 | E-19 | ○ |
| C-20 | ロール新規登録画面の存在 | E-20 | ○ |
| C-21 | ロール編集画面の存在 | E-21 | ○ |
| C-22 | ロールデータ権限設定画面の存在 | E-22 | ○ |
| C-23 | ロールユーザー割当画面の存在 | E-23 | ○ |
| C-24 | ユーザー選択ダイアログの存在 | E-24 | ○ |
| C-25 | メニュー管理一覧画面の存在と機能 | E-25 | ○ |
| C-26 | メニュー新規登録画面の存在 | E-26 | ○ |
| C-27 | メニュー編集画面の存在 | E-27 | ○ |
| C-28 | メニューツリー選択画面の存在 | E-28 | ○ |
| C-29 | アイコン選択画面の存在 | E-29 | ○ |
| C-30 | 部門管理一覧画面の存在と機能 | E-30 | ○ |
| C-31 | 部門新規登録画面の存在 | E-31 | ○ |
| C-32 | 部門編集画面の存在 | E-32 | ○ |
| C-33 | 部門ツリー選択画面の存在 | E-33 | ○ |
| C-34 | 岗位管理一覧画面の存在と機能 | E-34 | ○ |
| C-35 | 岗位新規登録画面の存在 | E-35 | ○ |
| C-36 | 岗位編集画面の存在 | E-36 | ○ |
| C-37 | 字典類型管理一覧画面の存在と機能 | E-37 | ○ |
| C-38 | 字典類型新規登録画面の存在 | E-38 | ○ |
| C-39 | 字典類型編集画面の存在 | E-39 | ○ |
| C-40 | 字典類型ツリー表示画面の存在 | E-40 | ○ |
| C-41 | 字典データ管理一覧画面の存在と機能 | E-41 | ○ |
| C-42 | 字典データ新規登録画面の存在 | E-42 | ○ |
| C-43 | 字典データ編集画面の存在 | E-43 | ○ |
| C-44 | パラメータ管理一覧画面の存在と機能 | E-44 | ○ |
| C-45 | パラメータ新規登録画面の存在 | E-45 | ○ |
| C-46 | パラメータ編集画面の存在 | E-46 | ○ |
| C-47 | 通知公告管理一覧画面の存在と機能 | E-47 | ○ |
| C-48 | 通知公告新規登録画面の存在 | E-48 | ○ |
| C-49 | 通知公告編集画面の存在 | E-49 | ○ |
| C-50 | 通知公告表示画面の存在 | E-50 | ○ |
| C-51 | オンラインユーザー一覧画面の存在と機能 | E-51 | ○ |
| C-52 | 定時任務管理一覧画面の存在と機能 | E-52 | ○ |
| C-53 | 定時任務新規登録画面の存在 | E-53 | ○ |
| C-54 | 定時任務編集画面の存在 | E-54 | ○ |
| C-55 | 定時任務詳細画面の存在 | E-55 | ○ |
| C-56 | 定時任務ログ画面の存在 | E-56 | ○ |
| C-57 | Cron式生成器画面の存在 | E-57 | ○ |
| C-58 | 操作ログ一覧画面の存在と機能 | E-58 | ○ |
| C-59 | 操作ログ詳細画面の存在 | E-59 | ○ |
| C-60 | ログインログ一覧画面の存在と機能 | E-60 | ○ |
| C-61 | サーバー監視画面の存在と機能 | E-61 | ○ |
| C-62 | キャッシュ監視画面の存在と機能 | E-62 | ○ |
| C-63 | フォームビルダー画面の存在と機能 | E-63 | ○ |
| C-64 | コード生成一覧画面の存在と機能 | E-64 | ○ |
| C-65 | テーブルインポート画面の存在 | E-65 | ○ |
| C-66 | テーブル作成画面の存在 | E-66 | ○ |
| C-67 | コード生成編集画面の存在 | E-67 | ○ |
| C-68 | 404エラー画面の存在 | E-68 | ○ |
| C-69 | 500エラー画面の存在 | E-69 | ○ |
| C-70 | サービスエラー画面の存在 | E-70 | ○ |
| C-71 | 権限エラー画面の存在 | E-71 | ○ |

## 4) 不足情報（Unknown / Missing）
- **該当なし**：全ての画面情報は実際のHTMLテンプレートファイルから取得されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての画面がソースコード上のHTMLテンプレートファイルから確認されました
- 画面名・説明は各HTMLファイルのtitleタグおよびth:include属性から抽出しています
- 画面遷移はJavaScriptコードおよびThymeleaf属性（th:href等）から推測しています

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧に記載された全71画面がシステム要件と一致しているか確認
- [ ] デモ画面（demo配下）を除外した本番用画面のみが一覧化されているか確認
- [ ] 画面遷移図のフローが実際の業務フローと整合しているか確認
- [ ] テンプレートファイルパスが正確であるか確認
- [ ] 画面のカテゴリ分類が適切であるか確認
