# 画面遷移図

## 概要

RuoYi後台管理システムの画面遷移図です。システムは認証、メイン画面、システム管理、システム監視、システムツールの各カテゴリで構成されています。

## 全体構成図

```mermaid
flowchart TB
    subgraph 認証
        Login[ログイン画面]
        Register[ユーザー登録画面]
        Lock[画面ロック]
    end

    subgraph メイン
        Index[システム首頁]
        IndexTopNav[システム首頁トップナビ型]
        Main[メインコンテンツ]
        Skin[テーマ切替]
    end

    subgraph システム管理
        UserList[ユーザー管理一覧]
        RoleList[ロール管理一覧]
        MenuList[メニュー管理一覧]
        DeptList[部門管理一覧]
        PostList[岗位管理一覧]
        DictTypeList[字典類型管理一覧]
        ConfigList[パラメータ管理一覧]
        NoticeList[通知公告管理一覧]
    end

    subgraph システム監視
        OnlineList[オンラインユーザー一覧]
        JobList[定時任務管理一覧]
        OperlogList[操作ログ一覧]
        LogininforList[ログインログ一覧]
        ServerMonitor[サーバー監視]
        CacheMonitor[キャッシュ監視]
    end

    subgraph システムツール
        FormBuilder[フォームビルダー]
        GenList[コード生成一覧]
    end

    Login --> Index
    Login --> Register
    Index --> Main
    Index --> Lock
    IndexTopNav --> Main
    Index --> Skin

    Index --> UserList
    Index --> RoleList
    Index --> MenuList
    Index --> DeptList
    Index --> PostList
    Index --> DictTypeList
    Index --> ConfigList
    Index --> NoticeList

    Index --> OnlineList
    Index --> JobList
    Index --> OperlogList
    Index --> LogininforList
    Index --> ServerMonitor
    Index --> CacheMonitor

    Index --> FormBuilder
    Index --> GenList
```

## 認証フロー

```mermaid
flowchart LR
    Start((開始)) --> Login[ログイン画面]
    Login -->|ログイン成功| Index[システム首頁]
    Login -->|新規登録| Register[ユーザー登録画面]
    Register -->|登録完了| Login
    Index -->|ロック| Lock[画面ロック]
    Lock -->|認証成功| Index
    Index -->|ログアウト| Login
```

## ユーザー管理フロー

```mermaid
flowchart TB
    UserList[ユーザー管理一覧]
    UserAdd[ユーザー新規登録]
    UserEdit[ユーザー編集]
    UserView[ユーザー詳細表示]
    UserResetPwd[ユーザーパスワードリセット]
    UserAuthRole[ユーザーロール割当]
    DeptTree[部門ツリー選択]
    Profile[プロフィール画面]
    Avatar[アバター変更]
    ProfileResetPwd[パスワード変更]

    UserList -->|新規| UserAdd
    UserList -->|編集| UserEdit
    UserList -->|詳細| UserView
    UserList -->|パスワードリセット| UserResetPwd
    UserList -->|ロール割当| UserAuthRole
    UserList -->|部門選択| DeptTree
    UserAdd --> UserList
    UserEdit --> UserList

    Profile -->|アバター変更| Avatar
    Profile -->|パスワード変更| ProfileResetPwd
    Avatar --> Profile
    ProfileResetPwd --> Profile
```

## ロール管理フロー

```mermaid
flowchart TB
    RoleList[ロール管理一覧]
    RoleAdd[ロール新規登録]
    RoleEdit[ロール編集]
    RoleDataScope[ロールデータ権限設定]
    RoleAuthUser[ロールユーザー割当]
    SelectUser[ユーザー選択ダイアログ]

    RoleList -->|新規| RoleAdd
    RoleList -->|編集| RoleEdit
    RoleList -->|データ権限| RoleDataScope
    RoleList -->|ユーザー割当| RoleAuthUser
    RoleAuthUser -->|ユーザー選択| SelectUser
    RoleAdd --> RoleList
    RoleEdit --> RoleList
    RoleDataScope --> RoleList
    SelectUser --> RoleAuthUser
```

## メニュー管理フロー

```mermaid
flowchart TB
    MenuList[メニュー管理一覧]
    MenuAdd[メニュー新規登録]
    MenuEdit[メニュー編集]
    MenuTree[メニューツリー選択]
    IconSelect[アイコン選択]

    MenuList -->|新規| MenuAdd
    MenuList -->|編集| MenuEdit
    MenuAdd -->|親メニュー選択| MenuTree
    MenuAdd -->|アイコン選択| IconSelect
    MenuEdit -->|親メニュー選択| MenuTree
    MenuEdit -->|アイコン選択| IconSelect
    MenuAdd --> MenuList
    MenuEdit --> MenuList
```

## 部門管理フロー

```mermaid
flowchart TB
    DeptList[部門管理一覧]
    DeptAdd[部門新規登録]
    DeptEdit[部門編集]
    DeptTree[部門ツリー選択]

    DeptList -->|新規| DeptAdd
    DeptList -->|編集| DeptEdit
    DeptAdd -->|親部門選択| DeptTree
    DeptEdit -->|親部門選択| DeptTree
    DeptAdd --> DeptList
    DeptEdit --> DeptList
```

## 岗位管理フロー

```mermaid
flowchart LR
    PostList[岗位管理一覧]
    PostAdd[岗位新規登録]
    PostEdit[岗位編集]

    PostList -->|新規| PostAdd
    PostList -->|編集| PostEdit
    PostAdd --> PostList
    PostEdit --> PostList
```

## 字典管理フロー

```mermaid
flowchart TB
    DictTypeList[字典類型管理一覧]
    DictTypeAdd[字典類型新規登録]
    DictTypeEdit[字典類型編集]
    DictDataList[字典データ管理一覧]
    DictDataAdd[字典データ新規登録]
    DictDataEdit[字典データ編集]

    DictTypeList -->|新規| DictTypeAdd
    DictTypeList -->|編集| DictTypeEdit
    DictTypeList -->|データ一覧| DictDataList
    DictTypeAdd --> DictTypeList
    DictTypeEdit --> DictTypeList

    DictDataList -->|新規| DictDataAdd
    DictDataList -->|編集| DictDataEdit
    DictDataAdd --> DictDataList
    DictDataEdit --> DictDataList
```

## パラメータ管理フロー

```mermaid
flowchart LR
    ConfigList[パラメータ管理一覧]
    ConfigAdd[パラメータ新規登録]
    ConfigEdit[パラメータ編集]

    ConfigList -->|新規| ConfigAdd
    ConfigList -->|編集| ConfigEdit
    ConfigAdd --> ConfigList
    ConfigEdit --> ConfigList
```

## 通知公告管理フロー

```mermaid
flowchart TB
    NoticeList[通知公告管理一覧]
    NoticeAdd[通知公告新規登録]
    NoticeEdit[通知公告編集]
    NoticeView[通知公告表示]

    NoticeList -->|新規| NoticeAdd
    NoticeList -->|編集| NoticeEdit
    NoticeList -->|詳細| NoticeView
    NoticeAdd --> NoticeList
    NoticeEdit --> NoticeList
```

## 定時任務管理フロー

```mermaid
flowchart TB
    JobList[定時任務管理一覧]
    JobAdd[定時任務新規登録]
    JobEdit[定時任務編集]
    JobDetail[定時任務詳細]
    JobLog[定時任務ログ]
    CronGen[Cron式生成器]

    JobList -->|新規| JobAdd
    JobList -->|編集| JobEdit
    JobList -->|詳細| JobDetail
    JobList -->|ログ| JobLog
    JobList -->|Cron生成| CronGen
    JobAdd -->|Cron設定| CronGen
    JobEdit -->|Cron設定| CronGen
    JobAdd --> JobList
    JobEdit --> JobList
```

## ログ管理フロー

```mermaid
flowchart TB
    OperlogList[操作ログ一覧]
    OperlogDetail[操作ログ詳細]
    LogininforList[ログインログ一覧]

    OperlogList -->|詳細| OperlogDetail
```

## コード生成フロー

```mermaid
flowchart TB
    GenList[コード生成一覧]
    ImportTable[テーブルインポート]
    CreateTable[テーブル作成]
    GenEdit[コード生成編集]
    Preview[プレビュー]
    Download[コードダウンロード]

    GenList -->|インポート| ImportTable
    GenList -->|作成| CreateTable
    GenList -->|編集| GenEdit
    GenList -->|プレビュー| Preview
    GenList -->|生成| Download
    ImportTable --> GenList
    CreateTable --> GenList
    GenEdit --> GenList
```

## エラー画面フロー

```mermaid
flowchart TB
    AnyPage[任意の画面]
    Error404[404エラー画面]
    Error500[500エラー画面]
    ServiceError[サービスエラー画面]
    UnauthError[権限エラー画面]

    AnyPage -->|ページ未発見| Error404
    AnyPage -->|サーバーエラー| Error500
    AnyPage -->|サービス停止| ServiceError
    AnyPage -->|権限不足| UnauthError
```
