---
generated_at: 2026-01-08 12:00:00
metrics:
  claims_total: 91
  claims_with_evidence: 91
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：91 / 91、根拠なし：0
- 優先レビュー（高）
  1. なし（すべてのマッピングはソースコードから確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（71画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（24機能）
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザー管理コントローラー
- E-04: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` - ロール管理コントローラー
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java` - メニュー管理コントローラー
- E-06: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java` - 部門管理コントローラー
- E-07: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` - 役職管理コントローラー
- E-08: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` - 通知公告コントローラー
- E-09: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` - パラメータ設定コントローラー
- E-10: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` - 辞書タイプコントローラー
- E-11: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` - 辞書データコントローラー
- E-12: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java` - ログインコントローラー
- E-13: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java` - ユーザー登録コントローラー
- E-14: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java` - プロフィールコントローラー
- E-15: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` - インデックスコントローラー
- E-16: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` - 操作ログコントローラー
- E-17: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java` - ログインログコントローラー
- E-18: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java` - オンラインユーザーコントローラー
- E-19: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/ServerController.java` - サーバー監視コントローラー
- E-20: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/CacheController.java` - キャッシュ監視コントローラー
- E-21: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` - 定期タスクコントローラー
- E-22: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java` - タスクログコントローラー
- E-23: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` - コード生成コントローラー
- E-24: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/tool/BuildController.java` - フォームビルダーコントローラー
- E-25: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/common/CommonController.java` - 共通コントローラー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面 - ログイン機能（主機能） | E-12 (SysLoginController.ajaxLogin) | ○ |
| C-02 | ログイン画面 - キャプチャ生成（補助機能） | E-01, E-02 (画面一覧備考欄に認証コード記載) | ○ |
| C-03 | ログイン画面 - ユーザー登録への遷移（遷移先機能） | E-12 (isAllowRegister設定参照) | ○ |
| C-04 | ユーザー登録画面 - ユーザー登録（主機能） | E-13 (SysRegisterController.ajaxRegister) | ○ |
| C-05 | 画面ロック - ログイン（主機能） | E-15 (SysIndexController.unlockscreen) | ○ |
| C-06 | ユーザー管理一覧 - ユーザー管理（主機能） | E-03 (SysUserController.list, changeStatus) | ○ |
| C-07 | ユーザー管理一覧 - 部門管理（補助機能） | E-03 (SysUserController.deptTreeData) | ○ |
| C-08 | ユーザー管理一覧 - ファイルアップロード（補助機能） | E-03 (SysUserController.importData) | ○ |
| C-09 | ユーザー管理一覧 - ファイルダウンロード（補助機能） | E-03 (SysUserController.export) | ○ |
| C-10 | ユーザー新規登録 - ユーザー管理（主機能） | E-03 (SysUserController.add, addSave) | ○ |
| C-11 | ユーザー新規登録 - ロール管理（補助機能） | E-03 (roleService.selectRoleAll参照) | ○ |
| C-12 | ユーザー新規登録 - 役職管理（補助機能） | E-03 (postService.selectPostAll参照) | ○ |
| C-13 | ユーザー新規登録 - 部門管理（補助機能） | E-03 (deptService参照) | ○ |
| C-14 | ユーザー編集 - ユーザー管理（主機能） | E-03 (SysUserController.edit, editSave) | ○ |
| C-15 | ユーザー詳細表示 - ユーザー管理（主機能） | E-03 (SysUserController.view) | ○ |
| C-16 | ユーザーパスワードリセット - ユーザー管理（主機能） | E-03 (SysUserController.resetPwd, resetPwdSave) | ○ |
| C-17 | ユーザーロール割当 - ユーザー管理（主機能） | E-03 (SysUserController.authRole, insertAuthRole) | ○ |
| C-18 | ユーザーロール割当 - ロール管理（API連携） | E-03 (roleService.selectRolesByUserId参照) | ○ |
| C-19 | 部門ツリー選択 - 部門管理（主機能） | E-03 (SysUserController.selectDeptTree) | ○ |
| C-20 | プロフィール画面 - プロファイル管理（主機能） | E-14 (SysProfileController.profile) | ○ |
| C-21 | プロフィール画面 - ユーザー管理（補助機能） | E-14 (userService.selectUserRoleGroup参照) | ○ |
| C-22 | アバター変更 - プロファイル管理（主機能） | E-14 (SysProfileController.avatar, updateAvatar) | ○ |
| C-23 | アバター変更 - ファイルアップロード（補助機能） | E-14 (FileUploadUtils.upload参照) | ○ |
| C-24 | パスワード変更 - プロファイル管理（主機能） | E-14 (SysProfileController.resetPwd) | ○ |
| C-25 | ロール管理一覧 - ロール管理（主機能） | E-04 (SysRoleController.list, changeStatus) | ○ |
| C-26 | ロール管理一覧 - ファイルダウンロード（補助機能） | E-04 (SysRoleController.export) | ○ |
| C-27 | ロール新規登録 - ロール管理（主機能） | E-04 (SysRoleController.add, addSave) | ○ |
| C-28 | ロール新規登録 - メニュー管理（補助機能） | E-05 (menuService.roleMenuTreeData参照) | ○ |
| C-29 | ロール編集 - ロール管理（主機能） | E-04 (SysRoleController.edit, editSave) | ○ |
| C-30 | ロールデータ権限設定 - ロール管理（主機能） | E-04 (SysRoleController.authDataScope) | ○ |
| C-31 | ロールデータ権限設定 - 部門管理（補助機能） | E-04 (deptService.roleDeptTreeData参照) | ○ |
| C-32 | ロールユーザー割当 - ロール管理（主機能） | E-04 (SysRoleController.authUser) | ○ |
| C-33 | ロールユーザー割当 - ユーザー管理（API連携） | E-04 (userService.selectAllocatedList参照) | ○ |
| C-34 | ユーザー選択ダイアログ - ユーザー管理（主機能） | E-04 (SysRoleController.selectUser) | ○ |
| C-35 | メニュー管理一覧 - メニュー管理（主機能） | E-05 (SysMenuController.menu, list) | ○ |
| C-36 | メニュー新規登録 - メニュー管理（主機能） | E-05 (SysMenuController.add, addSave) | ○ |
| C-37 | メニュー編集 - メニュー管理（主機能） | E-05 (SysMenuController.edit, editSave) | ○ |
| C-38 | メニューツリー選択 - メニュー管理（主機能） | E-05 (SysMenuController.selectMenuTree) | ○ |
| C-39 | アイコン選択 - メニュー管理（補助機能） | E-05 (SysMenuController.icon) | ○ |
| C-40 | 部門管理一覧 - 部門管理（主機能） | E-06 (SysDeptController.dept, list) | ○ |
| C-41 | 部門新規登録 - 部門管理（主機能） | E-06 (SysDeptController.add, addSave) | ○ |
| C-42 | 部門編集 - 部門管理（主機能） | E-06 (SysDeptController.edit, editSave) | ○ |
| C-43 | 部門ツリー選択 - 部門管理（主機能） | E-06 (SysDeptController.selectDeptTree) | ○ |
| C-44 | 岗位管理一覧 - 役職管理（主機能） | E-07 (SysPostController.operlog, list) | ○ |
| C-45 | 岗位管理一覧 - ファイルダウンロード（補助機能） | E-07 (SysPostController.export) | ○ |
| C-46 | 岗位新規登録 - 役職管理（主機能） | E-07 (SysPostController.add, addSave) | ○ |
| C-47 | 岗位編集 - 役職管理（主機能） | E-07 (SysPostController.edit, editSave) | ○ |
| C-48 | 字典類型管理一覧 - 辞書タイプ管理（主機能） | E-10 (SysDictTypeController.dictType, list) | ○ |
| C-49 | 字典類型管理一覧 - ファイルダウンロード（補助機能） | E-10 (SysDictTypeController.export) | ○ |
| C-50 | 字典類型新規登録 - 辞書タイプ管理（主機能） | E-10 (SysDictTypeController.add, addSave) | ○ |
| C-51 | 字典類型編集 - 辞書タイプ管理（主機能） | E-10 (SysDictTypeController.edit, editSave) | ○ |
| C-52 | 字典類型ツリー表示 - 辞書タイプ管理（主機能） | E-10 (SysDictTypeController.selectDictTree) | ○ |
| C-53 | 字典データ管理一覧 - 辞書データ管理（主機能） | E-11 (SysDictDataController.dictData, list) | ○ |
| C-54 | 字典データ管理一覧 - ファイルダウンロード（補助機能） | E-11 (SysDictDataController.export) | ○ |
| C-55 | 字典データ新規登録 - 辞書データ管理（主機能） | E-11 (SysDictDataController.add, addSave) | ○ |
| C-56 | 字典データ編集 - 辞書データ管理（主機能） | E-11 (SysDictDataController.edit, editSave) | ○ |
| C-57 | パラメータ管理一覧 - パラメータ設定（主機能） | E-09 (SysConfigController.config, list) | ○ |
| C-58 | パラメータ管理一覧 - ファイルダウンロード（補助機能） | E-09 (SysConfigController.export) | ○ |
| C-59 | パラメータ新規登録 - パラメータ設定（主機能） | E-09 (SysConfigController.add, addSave) | ○ |
| C-60 | パラメータ編集 - パラメータ設定（主機能） | E-09 (SysConfigController.edit, editSave) | ○ |
| C-61 | 通知公告管理一覧 - 通知公告（主機能） | E-08 (SysNoticeController.notice, list) | ○ |
| C-62 | 通知公告新規登録 - 通知公告（主機能） | E-08 (SysNoticeController.add, addSave) | ○ |
| C-63 | 通知公告編集 - 通知公告（主機能） | E-08 (SysNoticeController.edit, editSave) | ○ |
| C-64 | 通知公告表示 - 通知公告（主機能） | E-08 (SysNoticeController.view) | ○ |
| C-65 | オンラインユーザー一覧 - オンラインユーザー（主機能） | E-18 (SysUserOnlineController.online, batchForceLogout) | ○ |
| C-66 | 定時任務管理一覧 - 定期タスク管理（主機能） | E-21 (SysJobController.job, list, changeStatus, run) | ○ |
| C-67 | 定時任務管理一覧 - ファイルダウンロード（補助機能） | E-21 (SysJobController.export) | ○ |
| C-68 | 定時任務新規登録 - 定期タスク管理（主機能） | E-21 (SysJobController.add, addSave) | ○ |
| C-69 | 定時任務編集 - 定期タスク管理（主機能） | E-21 (SysJobController.edit, editSave) | ○ |
| C-70 | 定時任務詳細 - 定期タスク管理（主機能） | E-21 (SysJobController.detail) | ○ |
| C-71 | 定時任務ログ - タスク実行ログ（主機能） | E-22 (SysJobLogController.jobLog, list, remove, clean) | ○ |
| C-72 | 定時任務ログ - ファイルダウンロード（補助機能） | E-22 (SysJobLogController.export) | ○ |
| C-73 | Cron式生成器 - 定期タスク管理（補助機能） | E-21 (SysJobController.cron, queryCronExpression) | ○ |
| C-74 | 操作ログ一覧 - 操作ログ（主機能） | E-16 (SysOperlogController.operlog, list, remove, clean) | ○ |
| C-75 | 操作ログ一覧 - ファイルダウンロード（補助機能） | E-16 (SysOperlogController.export) | ○ |
| C-76 | 操作ログ詳細 - 操作ログ（主機能） | E-16 (SysOperlogController.detail) | ○ |
| C-77 | ログインログ一覧 - ログインログ（主機能） | E-17 (SysLogininforController.logininfor, list, remove, unlock) | ○ |
| C-78 | ログインログ一覧 - ファイルダウンロード（補助機能） | E-17 (SysLogininforController.export) | ○ |
| C-79 | サーバー監視 - サーバー監視（主機能） | E-19 (ServerController.server) | ○ |
| C-80 | キャッシュ監視 - キャッシュ監視（主機能） | E-20 (CacheController.cache, getCacheNames, getCacheKeys, getCacheValue, clearAll) | ○ |
| C-81 | フォームビルダー - コード生成（補助機能） | E-24 (BuildController.build) | ○ |
| C-82 | コード生成一覧 - コード生成（主機能） | E-23 (GenController.gen, genList, preview, download) | ○ |
| C-83 | テーブルインポート - コード生成（主機能） | E-23 (GenController.importTable, importTableSave) | ○ |
| C-84 | テーブル作成 - コード生成（主機能） | E-23 (GenController.createTable, create) | ○ |
| C-85 | コード生成編集 - コード生成（主機能） | E-23 (GenController.edit, editSave) | ○ |
| C-86 | 権限エラー画面 - ログイン（遷移先機能） | E-12 (SysLoginController.unauth) | ○ |
| C-87 | システム首頁 - ログイン（API連携） | E-15 (SysIndexController.index) | ○ |
| C-88 | システム首頁（トップナビ型） - ログイン（API連携） | E-15 (SysIndexController.index) | ○ |
| C-89 | メインコンテンツ - ログイン（補助機能） | E-15 (SysIndexController.main) | ○ |
| C-90 | メインコンテンツ（v1） - ログイン（補助機能） | E-15 (SysIndexController.main) | ○ |
| C-91 | テーマ切替 - パラメータ設定（補助機能） | E-15 (SysIndexController.switchSkin) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - すべてのマッピングはコントローラーソースコードおよび既存の画面一覧・機能一覧から確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのマッピングがソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧のすべての画面が適切にマッピングされているか確認
- [ ] 機能一覧のすべての機能が少なくとも1つの画面にマッピングされているか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）が適切に分類されているか確認
- [ ] 「関連する操作・処理」の説明が実際の機能と一致しているか確認
- [ ] エラー画面やヘルパー画面のマッピングが適切か確認
