# 画面設計書 1-ログイン画面

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「ログイン画面」の設計仕様を定義する。

### 本画面の処理概要

システムへのログイン認証を行う画面である。ユーザー名、パスワード、認証コード（キャプチャ）を入力し、認証が成功するとシステム首頁へ遷移する。

**業務上の目的・背景**：本システムはセキュリティが求められる後台管理システムであるため、不正アクセスを防止し、正規ユーザーのみがシステムにアクセスできるようにする必要がある。ログイン画面は、ユーザー認証の入口として、ユーザー名・パスワードによる認証と、ボット対策としての画像認証（キャプチャ）機能を提供する。また、「記住我（Remember Me）」機能により、ユーザーの利便性も確保している。

**画面へのアクセス方法**：ブラウザから直接 `/login` URLにアクセスするか、未認証状態で任意のページにアクセスした際に自動リダイレクトされる。また、ログアウト後にもこの画面に遷移する。

**主要な操作・処理内容**：
1. ユーザー名の入力（必須）
2. パスワードの入力（必須）
3. 認証コードの入力（キャプチャが有効な場合は必須）
4. 「記住我（Remember Me）」チェックボックスの選択（任意）
5. ログインボタン押下によるログイン認証処理の実行
6. 認証コード画像クリックによる新しいキャプチャ画像の取得

**画面遷移**：
- 遷移元：ログアウト後、セッションタイムアウト時、権限エラー画面
- 遷移先：ログイン成功時→システム首頁（/index）、新規登録リンク→ユーザー登録画面（/register）

**権限による表示制御**：本画面は未認証ユーザー専用であり、認証済みユーザーがアクセスした場合は自動的にシステム首頁にリダイレクトされる。「立即注册（新規登録）」リンクは、システム設定（sys.account.registerUser）により表示/非表示が切り替わる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ログイン | 主機能 | ユーザー名、パスワード入力によるログイン認証処理 |
| 21 | キャプチャ生成 | 補助機能 | 画像認証コードの表示・検証処理 |
| 20 | ユーザー登録 | 遷移先機能 | 新規登録リンクからユーザー登録画面への遷移 |

## 画面種別

認証（ログイン）

## URL/ルーティング

- GET `/login` - ログイン画面の表示
- POST `/login` - ログイン認証処理（Ajax）
- GET `/captcha/captchaImage` - キャプチャ画像取得

## 入出力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 入出力 | 説明 |
|--------|--------|-----|------|--------|--------|------|
| ユーザー名 | username | String | ○ | - | 入力 | ログインアカウント |
| パスワード | password | String | ○ | - | 入力 | ログインパスワード |
| 認証コード | validateCode | String | △ | 5 | 入力 | キャプチャ有効時は必須 |
| 記住我 | rememberMe | Boolean | - | - | 入力 | Remember Me機能 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| システムロゴ | 若依ロゴ画像 |
| システム名 | 「若依 後台管理系统」 |
| 技術スタック | SpringBoot, Mybatis, Shiro, Thymeleaf, Bootstrap |
| 認証コード画像 | キャプチャ画像（クリックで更新可能） |
| 新規登録リンク | 「立即注册」（設定により表示/非表示） |
| コピーライト | Copyright © 2018-2026 ruoyi.vip |

## イベント仕様

### 1-ログインボタン押下

1. クライアント側でjQuery Validateによる入力検証を実行
2. ユーザー名・パスワードの必須チェック
3. キャプチャ有効時は認証コードの入力チェック
4. 検証通過後、AjaxでPOST `/login` にリクエスト送信
5. サーバー側でApache Shiroによる認証処理を実行
6. 認証成功時：`/index` にリダイレクト
7. 認証失敗時：エラーメッセージ表示、キャプチャ画像を更新

### 2-認証コード画像クリック

1. 新しいキャプチャ画像をGET `/captcha/captchaImage` から取得
2. 乱数パラメータを付与してキャッシュを回避
3. 画像要素のsrc属性を更新して新しいキャプチャを表示

### 3-新規登録リンククリック

1. `/register` 画面に遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログインボタン押下（成功） | sys_logininfor | INSERT | ログイン履歴の記録 |
| ログインボタン押下（成功） | sys_user_online | INSERT | オンラインユーザー情報の登録 |
| ログインボタン押下（失敗） | sys_logininfor | INSERT | ログイン失敗履歴の記録 |

### テーブル別更新項目詳細

#### sys_logininfor

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | info_id | 自動採番 | 主キー |
| INSERT | login_name | 入力されたユーザー名 | - |
| INSERT | ipaddr | クライアントIPアドレス | - |
| INSERT | login_location | IPから判定した地域 | - |
| INSERT | browser | ブラウザ情報 | User-Agentから取得 |
| INSERT | os | OS情報 | User-Agentから取得 |
| INSERT | status | '0':成功 / '1':失敗 | - |
| INSERT | msg | 結果メッセージ | - |
| INSERT | login_time | 現在日時 | - |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| エラー | 请输入您的用户名 | ユーザー名が未入力 |
| エラー | 请输入您的密码 | パスワードが未入力 |
| エラー | 请输入验证码 | 認証コードが未入力（キャプチャ有効時） |
| エラー | 用户或密码错误 | 認証失敗時 |
| エラー | 未登录或登录超时。请重新登录 | Ajaxリクエスト時にセッション切れ |
| 警告 | 您已在别处登录，请您修改密码或重新登录 | 別セッションからログアウトされた場合 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| セッションタイムアウト | ログイン画面にリダイレクト |
| iframe内でのセッション切れ | トップフレームをログイン画面にリダイレクト |
| IE8以下のブラウザ | 互換性警告ページにリダイレクト |
| キャプチャ検証失敗 | エラーメッセージ表示、キャプチャ画像更新 |
| アカウントロック | ロック状態のメッセージを表示 |

## 備考

- キャプチャ機能はシステム設定により有効/無効を切り替え可能
- Remember Me機能はshiro.rememberMe.enabled設定により制御
- 新規登録リンクはsys.account.registerUser設定により制御
- IEブラウザの互換モード対策として `X-UA-Compatible: IE=edge` を設定
- 360ブラウザでは `webkit` レンダリングエンジンを使用するよう指定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログイン処理で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ユーザーエンティティの構造、loginName/passwordフィールド |
| 1-2 | AjaxResult.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java` | Ajax応答の形式（code, msg） |

**読解のコツ**: SysUserはShiroのPrincipal（認証情報）として使用される。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysLoginController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java` | GET/POST /loginのハンドリング |

**主要処理フロー**:
1. **40-53行目**: GET /login - ログイン画面の表示、設定値の取得とモデルへの設定
2. **55-75行目**: POST /login - 認証処理、Shiroによるログイン実行

#### Step 3: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | login.html | `ruoyi-admin/src/main/resources/templates/login.html` | 画面レイアウト、Thymeleaf条件分岐 |
| 3-2 | login.js | `ruoyi-admin/src/main/resources/static/ruoyi/login.js` | ログインAjax処理、バリデーション |

**主要処理フロー**:
- **login.js 11-43行目**: login()関数 - Ajaxでログインリクエスト送信
- **login.js 45-68行目**: validateRule()関数 - jQuery Validateによる入力検証

#### Step 4: 認証処理層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | UserRealm.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/realm/UserRealm.java` | Shiro認証ロジック |
| 4-2 | SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | パスワード検証 |

### プログラム呼び出し階層図

```
login.js::login()
    │
    ├─ $.ajax POST /login
    │      │
    │      └─ SysLoginController.ajaxLogin()
    │             │
    │             ├─ SecurityUtils.getSubject()
    │             │
    │             └─ subject.login(token)
    │                    │
    │                    └─ UserRealm.doGetAuthenticationInfo()
    │                           │
    │                           ├─ ISysUserService.selectUserByLoginName()
    │                           │
    │                           └─ SysPasswordService.matches()
    │
    └─ 成功時: location.href = ctx + 'index'
```

### データフロー図

```
[入力]               [処理]                    [出力]

username ───────┐
                │
password ───────┼──▶ SysLoginController ──▶ AjaxResult {code, msg}
                │         │
validateCode ───┼─────────┼──▶ CaptchaValidateFilter
                │         │
rememberMe ─────┘         └──▶ Shiro SecurityManager
                                    │
                                    └──▶ sys_logininfor (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| login.html | `ruoyi-admin/src/main/resources/templates/login.html` | テンプレート | ログイン画面のHTML |
| login.js | `ruoyi-admin/src/main/resources/static/ruoyi/login.js` | JavaScript | クライアント側ロジック |
| SysLoginController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java` | コントローラー | ログインエンドポイント |
| UserRealm.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/realm/UserRealm.java` | 認証 | Shiro認証処理 |
| SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | サービス | パスワード検証 |
| ConfigService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/ConfigService.java` | サービス | システム設定取得 |
| login.min.css | `ruoyi-admin/src/main/resources/static/css/login.min.css` | スタイル | ログイン画面CSS |
| ry-ui.js | `ruoyi-admin/src/main/resources/static/ruoyi/js/ry-ui.js` | JavaScript | 共通UIライブラリ |
