# 画面設計書 12-ユーザー詳細表示

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるユーザー詳細表示画面の設計仕様を定義するものである。

### 本画面の処理概要

ユーザー詳細表示画面は、システムに登録されているユーザーの詳細情報を参照専用で表示する画面である。管理者やユーザー自身が、特定のユーザーの基本情報、所属部門、ロール、岗位、ログイン履歴などの詳細を確認する際に利用される。

**業務上の目的・背景**：ユーザー管理において、特定のユーザーの詳細情報を素早く確認したいケースは頻繁に発生する。例えば、問い合わせ対応時のユーザー確認、監査対応時のユーザー情報参照、人事異動前の現状確認などである。本画面は、編集権限を持たないユーザーでも詳細情報を参照できる読み取り専用の画面を提供し、情報アクセスの利便性とセキュリティのバランスを確保する。

**画面へのアクセス方法**：ユーザー管理一覧画面から対象ユーザーの「詳細」ボタン（または行をダブルクリック）をクリックすると、モーダルウィンドウ形式でこの画面が表示される。URLパターンは `/system/user/view/{userId}` で、userIdパスパラメータで表示対象のユーザーを特定する。

**主要な操作・処理内容**：
1. 画面表示時に対象ユーザーの詳細情報（基本情報、所属情報、システム情報）を取得・表示
2. ユーザーに紐づくロールグループ名を文字列として表示
3. ユーザーに紐づく岗位グループ名を文字列として表示
4. 最終ログインIP、最終ログイン時間などのシステム情報を表示
5. 参照専用のため、編集機能は提供しない

**画面遷移**：
- 遷移元：ユーザー管理一覧画面（No.9）
- 遷移先：なし（参照専用画面）

**権限による表示制御**：本画面へのアクセスには `system:user:list` 権限が必要（一覧参照権限で詳細も参照可能）。データ権限（checkUserDataScope）によって閲覧可能なユーザーが制限される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ユーザー管理 | 主機能 | ユーザー情報の詳細表示処理 |

## 画面種別

詳細（モーダルダイアログ形式・参照専用）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /system/user/view/{userId} | 詳細画面表示 |

## 入出力項目

### 入力項目

本画面は参照専用のため、入力項目は存在しない。

## 表示項目

### 基本情報セクション

| No | 項目名 | 物理名 | 表示形式 | 説明 |
|----|--------|--------|---------|------|
| 1 | ユーザー名称 | userName | テキスト | ユーザーの表示名 |
| 2 | 归属部门 | dept.deptName | テキスト | 所属部門名 |
| 3 | 手機号碼 | phonenumber | テキスト | 電話番号 |
| 4 | 邮箱 | email | テキスト | メールアドレス |
| 5 | 登録帳號 | loginName | テキスト | ログインID |
| 6 | 用戸状態 | status | テキスト | 正常/停用 |
| 7 | 岗位 | postGroup | テキスト | 岗位名リスト（カンマ区切り）、なければ「无岗位」 |
| 8 | 用戸性別 | sex | テキスト | 辞書変換された性別表示（男/女/未知） |
| 9 | 角色 | roleGroup | テキスト | ロール名リスト（カンマ区切り）、なければ「无角色」 |

### 其他信息セクション

| No | 項目名 | 物理名 | 表示形式 | 説明 |
|----|--------|--------|---------|------|
| 10 | 创建者 | createBy | テキスト | ユーザーを作成した管理者名 |
| 11 | 创建时间 | createTime | 日時 | yyyy-MM-dd HH:mm:ss形式 |
| 12 | 更新者 | updateBy | テキスト | 最終更新者名 |
| 13 | 更新时间 | updateTime | 日時 | yyyy-MM-dd HH:mm:ss形式 |
| 14 | 最后登录IP | loginIp | テキスト | 最終ログイン時のIPアドレス |
| 15 | 最后登录时间 | loginDate | 日時 | yyyy-MM-dd HH:mm:ss形式 |
| 16 | 備考 | remark | テキスト | ユーザーに関する備考 |

## イベント仕様

### 1-画面初期表示

| 項目 | 内容 |
|------|------|
| トリガー | ユーザー管理一覧画面から「詳細」ボタン押下時 |
| 処理内容 | 1. コントローラーがuserIdパラメータを受け取り、データ権限チェックを実行<br>2. 該当ユーザー情報（部門・ロール含む）を取得<br>3. ユーザーのロールグループ名文字列を生成<br>4. ユーザーの岗位グループ名文字列を生成<br>5. モーダルウィンドウを表示し、各項目に値をバインド |
| 呼び出しAPI | GET /system/user/view/{userId} |
| 遷移先 | - |

## データベース更新仕様

### 操作別データベース影響一覧

本画面は参照専用のため、データベースの更新は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | sys_user | SELECT | ユーザー情報の取得 |
| 画面表示 | sys_dept | SELECT | 部門情報の取得（JOIN） |
| 画面表示 | sys_role | SELECT | ロール情報の取得（JOIN） |
| 画面表示 | sys_user_role | SELECT | ユーザーロール関連の取得（ロール名取得用） |
| 画面表示 | sys_user_post | SELECT | ユーザー岗位関連の取得（岗位名取得用） |
| 画面表示 | sys_post | SELECT | 岗位情報の取得（岗位名取得用） |

## メッセージ仕様

| No | 種別 | メッセージ | 表示条件 |
|----|------|----------|----------|
| 1 | 表示 | 无岗位 | 岗位が設定されていないユーザーの場合 |
| 2 | 表示 | 无角色 | ロールが設定されていないユーザーの場合 |

## 例外処理

| 例外パターン | 対応処理 |
|------------|---------|
| データ権限不足 | 対象ユーザーへのデータ権限がない場合、アクセス拒否エラー |
| 対象ユーザー不存在 | 表示対象のユーザーIDが存在しない場合、エラー画面表示 |

## 備考

- 本画面はフッター部分の共通includeのみを使用（編集機能がないため、ボタン類は非表示）
- ステータスは辞書を使用せず、直接三項演算子で「正常」「停用」を表示
- 性別は @dict.getLabel('sys_user_sex', sex) により辞書変換して表示
- 日時フォーマットは Thymeleafの #dates.format を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ユーザーエンティティ、SysDeptを内包 |
| 1-2 | SysDept.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` | 部門エンティティ |

**読解のコツ**: SysUserにはdept（SysDept型）がassociationとしてマッピングされており、JOINで取得される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysUserController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` | view()メソッドが詳細表示のエントリーポイント |

**主要処理フロー**:
1. **173行目**: `@RequiresPermissions("system:user:list")` - 一覧権限で詳細参照可能
2. **174-181行目**: `view()` メソッド - データ権限チェック後、ユーザー情報・ロールグループ・岗位グループを取得してモデルに設定

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | selectUserById, selectUserRoleGroup, selectUserPostGroupの定義 |
| 3-2 | SysUserServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java` | ロールグループ/岗位グループのカンマ区切り文字列生成ロジック |

**主要処理フロー**:
- `selectUserRoleGroup()`: ユーザーに紐づくロール名をカンマ区切りで連結
- `selectUserPostGroup()`: ユーザーに紐づく岗位名をカンマ区切りで連結

#### Step 4: 画面テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | view.html | `ruoyi-admin/src/main/resources/templates/system/user/view.html` | Thymeleafテンプレート、参照専用のため入力項目なし |

**主要処理フロー**:
- **9-91行目**: 基本情報の表示（th:objectでuserをバインド）
- **92-156行目**: 其他信息の表示（作成者、更新者、ログイン情報、備考）
- **59行目**: ステータス表示（三項演算子で正常/停用）
- **77行目**: 性別表示（@dict.getLabelで辞書変換）

### プログラム呼び出し階層図

```
ユーザー管理一覧画面 [詳細]ボタン押下
    │
    └─ SysUserController.view()              ← GET /system/user/view/{userId}
           ├─ userService.checkUserDataScope()   ← 権限チェック
           ├─ userService.selectUserById()       ← ユーザー情報取得
           ├─ userService.selectUserRoleGroup()  ← ロールグループ文字列取得
           └─ userService.selectUserPostGroup()  ← 岗位グループ文字列取得
                  │
                  └─ view.html 表示（参照専用）
```

### データフロー図

```
[入力]               [処理]                         [出力]

userId           SysUserController.view()        view.html表示
(パスパラメータ)  ───▶  │                           │
                      ├─ selectUserById()    ───▶ user（ユーザー情報）
                      ├─ selectUserRoleGroup() ───▶ roleGroup（ロール名一覧）
                      └─ selectUserPostGroup() ───▶ postGroup（岗位名一覧）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysUserController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` | コントローラー | リクエスト処理（view()メソッド） |
| view.html | `ruoyi-admin/src/main/resources/templates/system/user/view.html` | テンプレート | 詳細表示画面UI |
| SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | エンティティ | ユーザードメイン |
| ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | インターフェース | サービス定義 |
| SysUserServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java` | サービス実装 | ビジネスロジック |
| SysUserMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` | Mapper | selectUserById SQL |
