# 画面設計書 15-部門ツリー選択

## 概要

本ドキュメントは、RuoYi後台管理システムにおける部門ツリー選択画面の設計仕様を定義するものである。

### 本画面の処理概要

部門ツリー選択画面は、ユーザー登録・編集画面などから呼び出される補助画面で、組織部門をツリー形式で表示し、ユーザーの所属部門を選択するための画面である。zTreeライブラリを使用したツリーUIで、階層的な部門構造を視覚的に把握しながら選択操作を行う。

**業務上の目的・背景**：大規模な組織では部門数が多く、フラットなリストでは目的の部門を見つけにくい。本画面は、部門の階層構造（親子関係）をツリー形式で表示することで、ユーザーが直感的に所属部門を選択できる機能を提供する。検索機能やツリーの展開・折りたたみ機能により、効率的な部門選択が可能となる。

**画面へのアクセス方法**：ユーザー新規登録画面（No.10）またはユーザー編集画面（No.11）の「部門選択」フィールドをクリックすると、モーダルダイアログ形式でこの画面が表示される。URLパターンは `/system/user/selectDeptTree/{deptId}` で、現在選択中の部門IDをパラメータとして渡す。

**主要な操作・処理内容**：
1. 画面表示時に部門ツリーデータを取得し、zTreeで描画
2. キーワード検索による部門フィルタリング
3. ツリーの全展開・全折りたたみ操作
4. ノードクリックによる部門選択
5. 「確認」ボタンで選択した部門IDと部門名を呼び出し元に返却
6. 「清除」ボタンで選択をクリア
7. 「閉じる」ボタンでダイアログを閉じる

**画面遷移**：
- 遷移元：ユーザー新規登録画面（No.10）、ユーザー編集画面（No.11）
- 遷移先：なし（モーダルダイアログのため呼び出し元に戻る）

**権限による表示制御**：本画面へのアクセスには `system:user:list` 権限が必要。表示される部門はデータ権限（dept_scope）によってフィルタリングされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 部門管理 | 主機能 | 部門ツリー表示と選択処理 |

## 画面種別

選択（モーダルダイアログ形式・ツリーUI）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /system/user/selectDeptTree/{deptId} | 部門ツリー選択画面表示 |
| GET | /system/user/deptTreeData | 部門ツリーデータ取得（Ajax） |

## 入出力項目

### 入力項目

| No | 項目名 | 物理名 | 型 | 桁数 | 必須 | 初期値 | バリデーション |
|----|--------|--------|----|----|------|--------|--------------|
| 1 | 部門ID | treeId | hidden | - | - | 現在選択中の部門ID | - |
| 2 | 部門名 | treeName | hidden | - | - | 現在選択中の部門名 | - |
| 3 | 検索キーワード | keyword | text | 50 | - | 空 | - |

### 出力項目（呼び出し元へ返却）

| No | 項目名 | 物理名 | 説明 |
|----|--------|--------|------|
| 1 | 選択部門ID | treeId | 選択した部門のID |
| 2 | 選択部門名 | treeName | 選択した部門の名称 |

## 表示項目

| No | 項目名 | 説明 |
|----|--------|------|
| 1 | 検索ボックス | 部門名で絞り込むための検索欄（表示/非表示切替可能） |
| 2 | 展開/折りたたみリンク | ツリー全体の展開・折りたたみ操作用リンク |
| 3 | 部門ツリー | zTreeで描画された階層型部門選択UI |

## イベント仕様

### 1-画面初期表示

| 項目 | 内容 |
|------|------|
| トリガー | ユーザー登録/編集画面から部門選択フィールドクリック時 |
| 処理内容 | 1. コントローラーがdeptIdパラメータを受け取り、該当部門情報を取得<br>2. モデルにdept情報（現在の選択状態）を設定<br>3. Ajaxで部門ツリーデータを取得（deptTreeData API）<br>4. zTreeを初期化し、ツリーを描画（展開レベル2） |
| 呼び出しAPI | GET /system/user/selectDeptTree/{deptId}, GET /system/user/deptTreeData |
| 遷移先 | - |

### 2-検索ボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | 検索ボックスの「搜索」ボタン押下時 |
| 処理内容 | 1. keywordの値でツリーノードを検索<br>2. マッチしたノードをハイライト表示<br>3. 該当ノードまで展開 |
| 呼び出しAPI | - (クライアントサイド検索) |
| 遷移先 | - |

### 3-展開リンククリック

| 項目 | 内容 |
|------|------|
| トリガー | 「展開」リンククリック時 |
| 処理内容 | ツリーの全ノードを展開状態にする（$.tree.expand()） |
| 呼び出しAPI | - |
| 遷移先 | - |

### 4-折りたたみリンククリック

| 項目 | 内容 |
|------|------|
| トリガー | 「折叠」リンククリック時 |
| 処理内容 | ツリーの全ノードを折りたたみ状態にする（$.tree.collapse()） |
| 呼び出しAPI | - |
| 遷移先 | - |

### 5-ノードクリック（zOnClick）

| 項目 | 内容 |
|------|------|
| トリガー | ツリーノード（部門）クリック時 |
| 処理内容 | 1. クリックしたノードのidをtreeIdに設定<br>2. クリックしたノードのnameをtreeNameに設定 |
| 呼び出しAPI | - |
| 遷移先 | - |

### 6-確認ボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | ダイアログの「確認」ボタン押下時 |
| 処理内容 | 1. 呼び出し元のdoSubmit関数を実行<br>2. treeIdとtreeNameを呼び出し元フォームに反映<br>3. ダイアログを閉じる |
| 呼び出しAPI | - |
| 遷移先 | 呼び出し元画面（ユーザー登録/編集） |

### 7-清除ボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | ダイアログの「清除」ボタン押下時 |
| 処理内容 | 1. 呼び出し元のtreeIdを空に設定<br>2. 呼び出し元のtreeNameを空に設定<br>3. ダイアログを閉じる |
| 呼び出しAPI | - |
| 遷移先 | 呼び出し元画面（ユーザー登録/編集） |

### 8-検索表示切替

| 項目 | 内容 |
|------|------|
| トリガー | 検索ボックス上部の「︾」「︽」ボタンクリック時 |
| 処理内容 | 検索ボックスエリアの表示/非表示を切り替え（$.tree.toggleSearch()） |
| 呼び出しAPI | - |
| 遷移先 | - |

## データベース更新仕様

### 操作別データベース影響一覧

本画面は選択専用のため、データベースの更新は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ツリーデータ取得 | sys_dept | SELECT | 部門ツリーデータの取得 |

## メッセージ仕様

| No | 種別 | メッセージ | 表示条件 |
|----|------|----------|----------|
| - | - | - | 特になし |

## 例外処理

| 例外パターン | 対応処理 |
|------------|---------|
| 部門データ取得失敗 | Ajax通信エラー時、ツリーが表示されない |
| 指定部門ID不存在 | 指定されたdeptIdが存在しない場合、初期選択なしで表示 |

## 備考

- zTree 3.xライブラリを使用
- expandLevel: 2で初期表示時に2階層まで展開
- 検索はクライアントサイドで実行（$.tree.searchNode()）
- 親ウィンドウとのデータ受け渡しはhidden input経由

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Ztree.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` | zTree用のデータ構造（id, pId, name, title, checked, open等） |
| 1-2 | SysDept.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` | 部門エンティティ |

**読解のコツ**: ZtreeクラスはzTreeライブラリが要求するJSON形式に対応したDTO。pId（親ID）で親子関係を表現。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysUserController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` | selectDeptTree()とdeptTreeData()メソッド |

**主要処理フロー**:
1. **336-343行目**: `deptTreeData()` メソッド - 部門ツリーデータをJSON形式で返却
2. **345-356行目**: `selectDeptTree()` メソッド - 画面表示、現在選択中の部門情報を取得

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysDeptService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDeptService.java` | selectDeptTree()の定義 |
| 3-2 | SysDeptServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` | 部門一覧からZtreeリストへの変換処理 |

**主要処理フロー**:
- `selectDeptTree()`: 部門一覧を取得し、Ztreeオブジェクトのリストに変換

#### Step 4: 画面テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | deptTree.html | `ruoyi-admin/src/main/resources/templates/system/user/deptTree.html` | zTree初期化、検索・展開・折りたたみ機能 |

**主要処理フロー**:
- **12-13行目**: hidden項目でtreeId/treeNameを保持
- **33-41行目**: $.tree.init()でzTree初期化（expandLevel: 2）
- **43-48行目**: zOnClick関数でノード選択時の処理

### プログラム呼び出し階層図

```
ユーザー登録/編集画面 [部門選択]フィールドクリック
    │
    ├─ selectDeptTree() → モーダルダイアログ表示
    │      │
    │      └─ SysUserController.selectDeptTree()  ← GET /selectDeptTree/{deptId}
    │             └─ deptService.selectDeptById()  ← 現在部門情報取得
    │
    └─ deptTree.html 表示
           │
           ├─ $.tree.init()
           │      └─ Ajax: GET /system/user/deptTreeData
           │             └─ deptService.selectDeptTree()  ← 部門ツリー取得
           │
           ├─ [ノードクリック] → zOnClick() → treeId/treeName更新
           │
           └─ [確認]ボタン → doSubmit() → 呼び出し元に値反映
```

### データフロー図

```
[入力]                    [処理]                           [出力]

deptId (パス)         SysUserController.selectDeptTree()  dept情報
                  ───▶                                 ───▶ deptTree.html表示

(Ajax)            SysUserController.deptTreeData()       JSON (Ztree配列)
                  ───▶ deptService.selectDeptTree() ───▶  [
                                                           {id:1, pId:0, name:"xxx"},
                                                           ...
                                                         ]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysUserController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` | コントローラー | selectDeptTree(), deptTreeData()メソッド |
| deptTree.html | `ruoyi-admin/src/main/resources/templates/system/user/deptTree.html` | テンプレート | 部門ツリー選択画面UI（zTree） |
| Ztree.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` | ドメイン | zTree用データ構造 |
| SysDept.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` | エンティティ | 部門ドメイン |
| ISysDeptService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDeptService.java` | インターフェース | 部門サービス定義 |
| ztree.js | `ruoyi-admin/src/main/resources/static/ruoyi/js/ry-ui.js` | JavaScript | zTree初期化・操作ユーティリティ |
