# 画面設計書 19-ロール管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるロール管理一覧画面の設計仕様を定義するものである。

### 本画面の処理概要

ロール管理一覧画面は、システム内のロール（役割）を一覧表示し、ロールのCRUD操作、状態変更、データ権限設定、ユーザー割当などを行うための管理画面である。Bootstrap Tableを使用したデータテーブル形式で、検索・ソート・ページネーション機能を備える。

**業務上の目的・背景**：RBAC（Role-Based Access Control）に基づくアクセス制御において、ロールはユーザーとメニュー権限を結びつける中核的な概念である。本画面は、ロールの作成・編集・削除、データスコープ（データ権限）の設定、ユーザーへのロール割当を一元管理する。

**画面へのアクセス方法**：サイドメニューの「系统管理」→「角色管理」から遷移。URLパターンは `/system/role` である。

**主要な操作・処理内容**：
1. ロール一覧の表示（ページネーション、ソート対応）
2. 検索条件（ロール名、権限文字、状態、作成日時）による絞り込み
3. 新規ロール登録画面への遷移
4. ロール編集画面への遷移
5. ロールの削除（単一/一括）
6. ロールの有効/無効状態切替
7. データ権限設定画面への遷移
8. ユーザー割当画面への遷移
9. ロール一覧のExcelエクスポート

**画面遷移**：
- 遷移元：サイドメニュー（角色管理）
- 遷移先：ロール新規登録（No.20）、ロール編集、データ権限設定、ユーザー割当

**権限による表示制御**：
- system:role:view - 画面表示
- system:role:list - 一覧取得
- system:role:add - 新規ボタン表示
- system:role:edit - 編集ボタン表示、状態切替
- system:role:remove - 削除ボタン表示
- system:role:export - エクスポートボタン表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | ロール管理 | 主機能 | ロールCRUD、状態変更、データ権限設定 |

## 画面種別

一覧（検索・テーブル・ツールバー構成）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /system/role | ロール一覧画面表示 |
| POST | /system/role/list | ロール一覧データ取得（Ajax） |
| POST | /system/role/remove | ロール削除 |
| POST | /system/role/changeStatus | ロール状態変更 |
| POST | /system/role/export | Excelエクスポート |
| GET | /system/role/add | 新規登録画面表示 |
| GET | /system/role/edit/{roleId} | 編集画面表示 |
| GET | /system/role/authDataScope/{roleId} | データ権限設定画面 |
| GET | /system/role/authUser/{roleId} | ユーザー割当画面 |

## 入出力項目

### 検索条件

| No | 項目名 | 物理名 | 型 | 説明 |
|----|--------|--------|----|----|
| 1 | 角色名称 | roleName | text | ロール名（部分一致） |
| 2 | 权限字符 | roleKey | text | 権限文字列（部分一致） |
| 3 | 角色状态 | status | select | 0:正常, 1:停用 |
| 4 | 创建时间（開始） | params[beginTime] | datetime | 作成日時範囲（開始） |
| 5 | 创建时间（終了） | params[endTime] | datetime | 作成日時範囲（終了） |

### テーブル表示項目

| No | 項目名 | 物理名 | ソート | 説明 |
|----|--------|--------|--------|------|
| 1 | チェックボックス | - | - | 複数選択用 |
| 2 | 角色编号 | roleId | - | ロールID |
| 3 | 角色名称 | roleName | ○ | ロール名 |
| 4 | 权限字符 | roleKey | ○ | 権限文字列 |
| 5 | 数据权限 | dataScope | - | データスコープ（Badge表示） |
| 6 | 显示顺序 | roleSort | ○ | 表示順 |
| 7 | 角色状态 | status | - | トグルスイッチ表示 |
| 8 | 创建时间 | createTime | ○ | 作成日時 |
| 9 | 操作 | - | - | 編集/削除/更多操作 |

## イベント仕様

### 1-画面初期表示

| 項目 | 内容 |
|------|------|
| トリガー | 画面アクセス時 |
| 処理内容 | 1. Bootstrap Table初期化（$.table.init）<br>2. デフォルトソート：roleSort昇順<br>3. Ajax POST /system/role/listでデータ取得<br>4. 権限に応じたボタン表示/非表示制御 |
| 呼び出しAPI | GET /system/role, POST /system/role/list |
| 遷移先 | - |

### 2-検索ボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | 「搜索」ボタン押下時 |
| 処理内容 | 1. フォームの検索条件を取得<br>2. $.table.search()でテーブルを再描画 |
| 呼び出しAPI | POST /system/role/list |
| 遷移先 | - |

### 3-リセットボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | 「重置」ボタン押下時 |
| 処理内容 | $.form.reset()でフォームをクリア |
| 呼び出しAPI | - |
| 遷移先 | - |

### 4-新規ボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | 「新增」ボタン押下時 |
| 処理内容 | $.operate.add()でモーダルダイアログ表示 |
| 呼び出しAPI | GET /system/role/add |
| 遷移先 | ロール新規登録画面（No.20） |

### 5-編集ボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | 行の「编辑」ボタン押下時 |
| 処理内容 | $.operate.edit(roleId)でモーダルダイアログ表示 |
| 呼び出しAPI | GET /system/role/edit/{roleId} |
| 遷移先 | ロール編集画面 |

### 6-削除ボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | 行の「删除」ボタン押下時 |
| 処理内容 | 1. 確認ダイアログ表示<br>2. $.operate.remove(roleId)でAjax削除<br>3. テーブル再描画 |
| 呼び出しAPI | POST /system/role/remove |
| 遷移先 | - |

### 7-一括削除ボタン押下

| 項目 | 内容 |
|------|------|
| トリガー | ツールバー「删除」ボタン押下時 |
| 処理内容 | 1. 選択行のroleIdを取得<br>2. $.operate.removeAll()で一括削除 |
| 呼び出しAPI | POST /system/role/remove |
| 遷移先 | - |

### 8-状態切替（有効化）

| 項目 | 内容 |
|------|------|
| トリガー | 無効状態（toggle-off）アイコンクリック時 |
| 処理内容 | 1. 確認ダイアログ「确认要启用角色吗？」<br>2. $.operate.post()でstatus=0送信<br>3. テーブル再描画 |
| 呼び出しAPI | POST /system/role/changeStatus |
| 遷移先 | - |

### 9-状態切替（無効化）

| 項目 | 内容 |
|------|------|
| トリガー | 有効状態（toggle-on）アイコンクリック時 |
| 処理内容 | 1. 確認ダイアログ「确认要停用角色吗？」<br>2. $.operate.post()でstatus=1送信<br>3. テーブル再描画 |
| 呼び出しAPI | POST /system/role/changeStatus |
| 遷移先 | - |

### 10-データ権限設定

| 項目 | 内容 |
|------|------|
| トリガー | 「更多操作」→「数据权限」クリック時 |
| 処理内容 | $.modal.open()でデータ権限設定画面をモーダル表示 |
| 呼び出しAPI | GET /system/role/authDataScope/{roleId} |
| 遷移先 | データ権限設定画面 |

### 11-ユーザー割当

| 項目 | 内容 |
|------|------|
| トリガー | 「更多操作」→「分配用户」クリック時 |
| 処理内容 | $.modal.openTab()で新規タブにユーザー割当画面表示 |
| 呼び出しAPI | GET /system/role/authUser/{roleId} |
| 遷移先 | ユーザー割当画面 |

### 12-Excelエクスポート

| 項目 | 内容 |
|------|------|
| トリガー | 「导出」ボタン押下時 |
| 処理内容 | 1. $.table.exportExcel()で現在の検索条件でエクスポート<br>2. ExcelUtilでファイル生成 |
| 呼び出しAPI | POST /system/role/export |
| 遷移先 | - |

## データスコープ（dataScope）表示

| dataScope値 | 表示（Badge） | 説明 |
|-------------|--------------|------|
| 1 | 全部数据权限（badge-primary） | 全データアクセス可 |
| 2 | 自定义数据权限（badge-success） | カスタム部門データ |
| 3 | 本部门数据权限（badge-info） | 所属部門のみ |
| 4 | 本部门及以下数据权限（badge-warning） | 所属部門と配下 |
| 5 | 仅本人数据权限（badge-danger） | 自分のデータのみ |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | sys_role | DELETE | ロール削除（論理削除：del_flag='2'） |
| 削除 | sys_role_menu | DELETE | ロール-メニュー関連削除 |
| 削除 | sys_role_dept | DELETE | ロール-部門関連削除 |
| 状態変更 | sys_role | UPDATE | status更新 |

## メッセージ仕様

| No | 種別 | メッセージ | 表示条件 |
|----|------|----------|----------|
| 1 | 成功 | 操作成功 | 削除/状態変更成功時 |
| 2 | 確認 | 确认要停用角色吗？ | 無効化前 |
| 3 | 確認 | 确认要启用角色吗？ | 有効化前 |
| 4 | エラー | 超级管理员不允许操作 | roleId=1を操作しようとした場合 |

## 例外処理

| 例外パターン | 対応処理 |
|------------|---------|
| 管理者ロール操作 | roleId=1の編集/削除/状態変更は拒否 |
| データスコープ違反 | ユーザーのデータ権限外のロール操作を拒否 |
| ロール使用中削除 | ユーザーに割当済みのロール削除時エラー |

## 備考

- roleId=1（超级管理员）は操作ボタンを非表示
- 「更多操作」はPopoverで表示（data-toggle="popover"）
- roleSortで初期ソート
- 辞書（sys_normal_disable）で状態選択肢を取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysRoleController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` | role(), list(), remove(), changeStatus()メソッド |

**主要処理フロー**:
1. **49-54行目**: `role()` メソッド - 画面表示
2. **56-64行目**: `list()` メソッド - 一覧データ取得（ページネーション対応）
3. **177-184行目**: `remove()` メソッド - ロール削除
4. **217-227行目**: `changeStatus()` メソッド - 状態変更

#### Step 2: 画面テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | role.html | `ruoyi-admin/src/main/resources/templates/system/role/role.html` | 検索フォーム、テーブル定義 |

**主要処理フロー**:
- **10-37行目**: 検索フォーム（roleName, roleKey, status, params[beginTime/endTime]）
- **40-53行目**: ツールバー（新規/編集/削除/エクスポート）
- **67-151行目**: Bootstrap Table columns定義
- **94-113行目**: dataScope formatter（Badge表示）
- **133-149行目**: 操作ボタン formatter（roleId != 1でボタン表示）
- **154-164行目**: authDataScope(), authUser()関数
- **166-187行目**: statusTools(), disable(), enable()関数

### プログラム呼び出し階層図

```
サイドメニュー [角色管理]
    │
    └─ SysRoleController.role()                ← GET /system/role
           └─ role.html 表示
                  │
                  ├─ $.table.init()
                  │      └─ Ajax POST → SysRoleController.list()
                  │             └─ roleService.selectRoleList()
                  │                    └─ SysRoleMapper.selectRoleList
                  │
                  ├─ [搜索] → $.table.search() → list()再実行
                  │
                  ├─ [新增] → $.operate.add()
                  │      └─ SysRoleController.add()  ← GET /role/add
                  │
                  ├─ [编辑] → $.operate.edit(roleId)
                  │      └─ SysRoleController.edit()  ← GET /role/edit/{id}
                  │
                  ├─ [删除] → $.operate.remove(roleId)
                  │      └─ SysRoleController.remove()  ← POST /role/remove
                  │             └─ roleService.deleteRoleByIds()
                  │
                  ├─ [状態切替] → enable()/disable()
                  │      └─ SysRoleController.changeStatus()  ← POST /role/changeStatus
                  │             └─ roleService.changeStatus()
                  │
                  ├─ [数据权限] → authDataScope(roleId)
                  │      └─ SysRoleController.authDataScope()  ← GET /role/authDataScope/{id}
                  │
                  ├─ [分配用户] → authUser(roleId)
                  │      └─ SysRoleController.authUser()  ← GET /role/authUser/{id}
                  │
                  └─ [导出] → $.table.exportExcel()
                         └─ SysRoleController.export()  ← POST /role/export
                                └─ ExcelUtil.exportExcel()
```

### データフロー図

```
[入力]                    [処理]                            [出力]

検索条件
(roleName, roleKey,      SysRoleController.list()
status, beginTime,           │
endTime)                     ├─ startPage()  ← ページネーション設定
     │                       │
     └─────────▶ roleService.selectRoleList()
                             │
                             └─ SysRoleMapper.selectRoleList ─▶ TableDataInfo
                                                                   │
                                                                   ▼
                                                              Bootstrap Table
                                                              (JSON データ)

roleId                   SysRoleController.changeStatus()
     │                       │
     └─────────▶ roleService.changeStatus()
                             │
                             └─ sys_role.status UPDATE ──────▶ AjaxResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysRoleController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` | コントローラー | ロール管理API |
| role.html | `ruoyi-admin/src/main/resources/templates/system/role/role.html` | テンプレート | ロール一覧画面UI |
| ISysRoleService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java` | インターフェース | ロールサービス定義 |
| SysRoleServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysRoleServiceImpl.java` | サービス実装 | ロールサービス実装 |
| SysRoleMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysRoleMapper.xml` | Mapper | ロールSQL |
| SysRole.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java` | エンティティ | ロールエンティティ |
| ry.js | `ruoyi-admin/src/main/resources/static/ruoyi/js/ry-ui.js` | JavaScript | $.table, $.operate等の共通関数 |
