# 画面設計書 2-ユーザー登録画面

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「ユーザー登録画面」の設計仕様を定義する。

### 本画面の処理概要

新規ユーザーがシステムに自己登録を行うための画面である。ユーザー名、パスワード、確認パスワード、認証コード（キャプチャ）を入力し、利用規約に同意の上で登録を完了する。

**業務上の目的・背景**：本システムでは、管理者によるユーザー登録だけでなく、ユーザー自身による自己登録機能を提供している。これにより、管理者の運用負荷を軽減しつつ、新規ユーザーのオンボーディングを効率化する。ただし、セキュリティ上の理由から、この機能はシステム設定により有効/無効を切り替えることができ、デフォルトでは無効となっている。

**画面へのアクセス方法**：ログイン画面の「立即注册」リンクをクリックするか、直接 `/register` URLにアクセスする。ただし、システム設定でユーザー登録が無効になっている場合は、この画面にアクセスしても登録処理は実行できない。

**主要な操作・処理内容**：
1. ユーザー名の入力（2文字以上、必須）
2. パスワードの入力（5文字以上、必須）
3. 確認パスワードの入力（パスワードと一致、必須）
4. 認証コードの入力（キャプチャが有効な場合は必須）
5. 利用規約への同意チェック
6. 登録ボタン押下による新規ユーザー登録処理の実行

**画面遷移**：
- 遷移元：ログイン画面の「立即注册」リンク
- 遷移先：登録成功時→ログイン画面、「直接登录」リンク→ログイン画面

**権限による表示制御**：本画面は未認証ユーザー専用であり、認証済みユーザーがアクセスした場合はシステム首頁にリダイレクトされる。登録機能自体がシステム設定（sys.account.registerUser）で無効化されている場合、登録処理はエラーとなる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | ユーザー登録 | 主機能 | 新規ユーザー情報入力と登録処理 |
| 21 | キャプチャ生成 | 補助機能 | 画像認証コードの表示・検証処理 |

## 画面種別

登録

## URL/ルーティング

- GET `/register` - ユーザー登録画面の表示
- POST `/register` - ユーザー登録処理（Ajax）
- GET `/captcha/captchaImage` - キャプチャ画像取得

## 入出力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 入出力 | 説明 |
|--------|--------|-----|------|--------|--------|------|
| ユーザー名 | username (loginName) | String | ○ | 20 | 入力 | ログインアカウント（2文字以上） |
| パスワード | password | String | ○ | 20 | 入力 | ログインパスワード（5文字以上） |
| 確認パスワード | confirmPassword | String | ○ | 20 | 入力 | パスワード確認用 |
| 認証コード | validateCode | String | △ | 5 | 入力 | キャプチャ有効時は必須 |
| 利用規約同意 | acceptTerm | Boolean | - | - | 入力 | 利用規約への同意 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| システムロゴ | 若依ロゴ画像 |
| システム名 | 「若依 後台管理系统」 |
| 技術スタック | SpringBoot, Mybatis, Shiro, Thymeleaf, Bootstrap |
| 認証コード画像 | キャプチャ画像（クリックで更新可能） |
| ログインリンク | 「直接登录」 |
| 利用規約リンク | GiteeのREADMEへのリンク |
| コピーライト | 2018-2026 All Rights Reserved. RuoYi |

## イベント仕様

### 1-登録ボタン押下

1. クライアント側でjQuery Validateによる入力検証を実行
2. ユーザー名（2文字以上）・パスワード（5文字以上）の必須チェック
3. 確認パスワードと入力パスワードの一致チェック
4. キャプチャ有効時は認証コードの入力チェック
5. 検証通過後、AjaxでPOST `/register` にリクエスト送信
6. サーバー側で登録機能の有効性チェック
7. ユーザー名の重複チェック
8. 登録成功時：成功メッセージを表示後、ログイン画面にリダイレクト
9. 登録失敗時：エラーメッセージ表示、キャプチャ画像を更新

### 2-認証コード画像クリック

1. 新しいキャプチャ画像をGET `/captcha/captchaImage` から取得
2. 乱数パラメータを付与してキャッシュを回避
3. 画像要素のsrc属性を更新して新しいキャプチャを表示

### 3-ログインリンククリック

1. `/login` 画面に遷移

### 4-利用規約リンククリック

1. 新しいタブでGiteeのREADME.mdを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 登録ボタン押下（成功） | sys_user | INSERT | 新規ユーザーレコードの作成 |

### テーブル別更新項目詳細

#### sys_user

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | 自動採番 | 主キー |
| INSERT | dept_id | NULL | 部門未設定 |
| INSERT | login_name | 入力されたユーザー名 | 一意制約あり |
| INSERT | user_name | 入力されたユーザー名 | userName未設定時はloginNameと同じ |
| INSERT | user_type | '00' | 通常ユーザー |
| INSERT | email | NULL | 未設定 |
| INSERT | phonenumber | NULL | 未設定 |
| INSERT | sex | '0' | 男性（デフォルト） |
| INSERT | avatar | NULL | 未設定 |
| INSERT | password | 暗号化されたパスワード | SHA256 + Salt |
| INSERT | salt | ランダム生成されたソルト | - |
| INSERT | status | '0' | 正常 |
| INSERT | del_flag | '0' | 存在 |
| INSERT | create_by | 'register' | 自己登録を示す |
| INSERT | create_time | 現在日時 | - |
| INSERT | remark | '自主注册用户' | - |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| エラー | 请输入您的用户名 | ユーザー名が未入力 |
| エラー | 用户名不能小于2个字符 | ユーザー名が2文字未満 |
| エラー | 请输入您的密码 | パスワードが未入力 |
| エラー | 密码不能小于5个字符 | パスワードが5文字未満 |
| エラー | 请再次输入您的密码 | 確認パスワードが未入力 |
| エラー | 两次密码输入不一致 | パスワードが一致しない |
| エラー | 请输入验证码 | 認証コードが未入力（キャプチャ有効時） |
| エラー | 当前系统没有开启注册功能！ | 登録機能が無効 |
| エラー | 保存用户'xxx'失败，登录账号已存在 | ユーザー名が重複 |
| 成功 | 恭喜你，您的账号 xxx 注册成功！ | 登録成功時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 登録機能無効 | エラーメッセージ「当前系统没有开启注册功能！」を表示 |
| ユーザー名重複 | エラーメッセージを表示、キャプチャ更新 |
| キャプチャ検証失敗 | エラーメッセージ表示、キャプチャ画像更新 |
| サーバーエラー | エラーメッセージ表示 |

## 備考

- ユーザー登録機能はデフォルトで無効。有効化するには sys.account.registerUser を 'true' に設定する必要がある
- パスワードは特殊文字チェック（specialSign）が適用される
- 登録されたユーザーにはロールが割り当てられないため、管理者が後からロールを設定する必要がある
- 自己登録ユーザーは create_by が 'register'、remark が '自主注册用户' となる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

登録処理で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ユーザーエンティティの構造 |
| 1-2 | AjaxResult.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java` | Ajax応答の形式 |

**読解のコツ**: SysUserのloginName, password, saltフィールドに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysRegisterController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java` | GET/POST /registerのハンドリング |

**主要処理フロー**:
1. **29-33行目**: GET /register - 登録画面の表示
2. **35-45行目**: POST /register - 登録処理、設定チェック、サービス呼び出し

#### Step 3: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | register.html | `ruoyi-admin/src/main/resources/templates/register.html` | 画面レイアウト、入力フォーム |
| 3-2 | register.js | `ruoyi-admin/src/main/resources/static/ruoyi/register.js` | 登録Ajax処理、バリデーション |

**主要処理フロー**:
- **register.js 10-48行目**: register()関数 - Ajaxで登録リクエスト送信
- **register.js 50-86行目**: validateRule()関数 - jQuery Validateによる入力検証

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysRegisterService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysRegisterService.java` | 登録ビジネスロジック |
| 4-2 | ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | ユーザー登録インターフェース |

### プログラム呼び出し階層図

```
register.js::register()
    │
    ├─ $.ajax POST /register
    │      │
    │      └─ SysRegisterController.ajaxRegister()
    │             │
    │             ├─ configService.selectConfigByKey() - 登録可否チェック
    │             │
    │             └─ registerService.register()
    │                    │
    │                    ├─ userService.checkLoginNameUnique()
    │                    │
    │                    ├─ ShiroUtils.randomSalt()
    │                    │
    │                    ├─ passwordService.encryptPassword()
    │                    │
    │                    └─ userService.insertUser()
    │
    └─ 成功時: layer.alert() → location.href = ctx + 'login'
```

### データフロー図

```
[入力]               [処理]                    [出力]

loginName ──────┐
                │
password ───────┼──▶ SysRegisterController ──▶ AjaxResult {code, msg}
                │         │
confirmPassword─┤         │
                │         ├──▶ SysRegisterService
validateCode ───┘                │
                                 └──▶ sys_user (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| register.html | `ruoyi-admin/src/main/resources/templates/register.html` | テンプレート | 登録画面のHTML |
| register.js | `ruoyi-admin/src/main/resources/static/ruoyi/register.js` | JavaScript | クライアント側ロジック |
| SysRegisterController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java` | コントローラー | 登録エンドポイント |
| SysRegisterService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysRegisterService.java` | サービス | 登録ビジネスロジック |
| ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | サービス | ユーザー操作 |
| SysUserMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` | MyBatis | SQL定義 |
| login.min.css | `ruoyi-admin/src/main/resources/static/css/login.min.css` | スタイル | 登録画面CSS（ログインと共通） |
| jquery.validate.extend.js | `ruoyi-admin/src/main/resources/static/ajax/libs/validate/jquery.validate.extend.js` | JavaScript | バリデーション拡張 |
