# 画面設計書 23-ロールユーザー割当

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「ロールユーザー割当」画面の設計仕様を定義するものである。特定のロールに対してユーザーを割り当て・解除するための画面で、割当済みユーザーの一覧表示と管理機能を提供する。

### 本画面の処理概要

この画面では、選択したロールに割り当てられているユーザーの一覧を表示し、新規ユーザーの追加や既存割当の解除を行う。ロールベースアクセス制御（RBAC）の中核となる機能であり、ユーザーとロールの多対多関係を管理する。

**業務上の目的・背景**：組織内の役割分担に応じて、各ユーザーに適切なロールを割り当てる必要がある。この画面により、管理者はロール単位でユーザーを一括管理でき、新入社員のロール付与や異動に伴うロール変更を効率的に行える。

**画面へのアクセス方法**：ロール管理一覧画面から対象ロールの「ユーザー割当」ボタンをクリック、またはロールを選択して「その他」メニューから「分配用户」を選択することで、新しいページタブとして表示される。

**主要な操作・処理内容**：
1. 割当済みユーザー一覧の表示（検索、ページング、ソート）
2. ログイン名称・手機番号による検索
3. 新規ユーザーの追加（ユーザー選択ダイアログ経由）
4. 単一ユーザーの割当解除
5. 複数ユーザーの一括割当解除
6. 画面を閉じて一覧に戻る

**画面遷移**：ロール管理一覧画面から遷移。「添加用户」ボタンでユーザー選択ダイアログ（No.24）を表示。「关闭」ボタンで画面を閉じる。

**権限による表示制御**：`system:role:edit`権限を持つユーザーのみアクセス可能。`system:role:add`権限がないと「添加用户」ボタンは非表示。`system:role:remove`権限がないと「批量取消授权」ボタンと「取消授权」リンクは非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | ロール管理 | 主機能 | ロールへのユーザー割当・解除処理 |
| 1 | ユーザー管理 | API連携 | 割当済み・未割当ユーザー一覧の取得 |

## 画面種別

一覧（ページタブ）

## URL/ルーティング

- 画面表示: `GET /system/role/authUser/{roleId}`
- 割当済みユーザー一覧: `POST /system/role/authUser/allocatedList`
- 単一ユーザー割当解除: `POST /system/role/authUser/cancel`
- 一括割当解除: `POST /system/role/authUser/cancelAll`
- ユーザー選択ダイアログ: `GET /system/role/authUser/selectUser/{roleId}`

## 入出力項目

### 検索条件入力項目

| 項目名 | 物理名 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ロールID | roleId | Long | - | hidden項目、自動設定 |
| ログイン名称 | loginName | String | - | 部分一致検索 |
| 手機番号 | phonenumber | String | - | 部分一致検索 |

### 出力項目（一覧表示）

| 項目名 | 物理名 | 型 | ソート | 説明 |
|--------|--------|-----|--------|------|
| チェックボックス | - | - | - | 一括操作用の選択 |
| ユーザーID | userId | Long | - | 非表示カラム |
| ログイン名称 | loginName | String | 可 | ユーザーのログイン名 |
| ユーザー名称 | userName | String | - | ユーザーの表示名 |
| 邮箱 | email | String | - | メールアドレス |
| 手機 | phonenumber | String | - | 電話番号 |
| ユーザー状態 | status | String | - | 正常/停用（辞書変換） |
| 創建時間 | createTime | DateTime | 可 | 作成日時（デフォルトソート降順） |
| 操作 | - | - | - | 取消授権リンク |

## 表示項目

| 表示項目 | 説明 | 初期値/条件 |
|----------|------|-------------|
| ログイン名称検索欄 | テキスト入力 | 空 |
| 手機番号検索欄 | テキスト入力 | 空 |
| 搜索ボタン | 検索実行 | - |
| 重置ボタン | 検索条件クリア | - |
| 添加用户ボタン | ユーザー追加ダイアログ表示 | system:role:add権限必要 |
| 批量取消授权ボタン | 一括解除（disabled状態） | system:role:remove権限必要、選択時有効 |
| 关闭ボタン | 画面タブを閉じる | - |
| ユーザー一覧テーブル | Bootstrap Table | ページサイズ10/25/50 |

## イベント仕様

### 1-画面表示

ロールユーザー割当画面をページタブとして表示する。

**処理フロー**：
1. `SysRoleController.authUser()`がroleIdを受け取る
2. `roleService.checkRoleDataScope()`でデータスコープ権限を検証
3. `roleService.selectRoleById()`でロール情報を取得
4. ModelMapにロール情報を設定
5. Thymeleafテンプレートを描画
6. JavaScript初期化処理でBootstrap Tableを初期化
7. 割当済みユーザー一覧をAjax取得

### 2-検索実行

検索条件に基づいてユーザー一覧を再取得する。

**処理フロー**：
1. 「搜索」ボタンクリックで`$.table.search()`が呼び出される
2. queryParams関数で検索パラメータを構築
3. roleIdを検索パラメータに追加
4. POST /system/role/authUser/allocatedListを呼び出し
5. 結果をテーブルに表示

### 3-検索条件リセット

検索条件をクリアして全件表示する。

**処理フロー**：
1. 「重置」ボタンクリックで`$.form.reset()`が呼び出される
2. 検索フォームの入力値をクリア
3. テーブルを再検索

### 4-ユーザー追加

ユーザー選択ダイアログを表示する。

**処理フロー**：
1. 「添加用户」ボタンクリックで`selectUser()`関数が呼び出される
2. `$.modal.open()`でユーザー選択ダイアログをモーダル表示
3. ダイアログでユーザー選択・保存後、親画面のテーブルが更新される

### 5-単一ユーザー割当解除

特定ユーザーのロール割当を解除する。

**処理フロー**：
1. 「取消授权」リンククリックで`cancelAuthUser(userId)`が呼び出される
2. 確認ダイアログ「确认要取消该用户角色吗？」を表示
3. OK押下で`$.operate.post()`でサーバーに送信
4. `POST /system/role/authUser/cancel`でroleIdとuserIdを送信
5. 成功時はテーブルを更新

### 6-一括割当解除

選択した複数ユーザーのロール割当を一括解除する。

**処理フロー**：
1. 「批量取消授权」ボタンクリックで`cancelAuthUserAll()`が呼び出される
2. `$.table.selectFirstColumns()`で選択されたuserIdを取得
3. 選択なしの場合、「请至少选择一条记录」警告を表示
4. 確認ダイアログ「确认要删除选中的N条数据吗?」を表示
5. OK押下で`$.operate.submit()`でサーバーに送信
6. `POST /system/role/authUser/cancelAll`でroleIdとuserIds（カンマ区切り）を送信
7. 成功時はテーブルを更新

### 7-画面クローズ

画面タブを閉じてロール一覧に戻る。

**処理フロー**：
1. 「关闭」ボタンクリックで`closeItem()`が呼び出される
2. 現在のタブを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 単一ユーザー割当解除 | sys_user_role | DELETE | 指定ユーザーとロールの関連を削除 |
| 一括割当解除 | sys_user_role | DELETE | 複数ユーザーとロールの関連を一括削除 |

### テーブル別更新項目詳細

#### sys_user_role

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | user_id = 対象ユーザーID AND role_id = 対象ロールID | 単一解除 |
| DELETE | - | user_id IN (選択ユーザーID) AND role_id = 対象ロールID | 一括解除 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 警告 | 请至少选择一条记录 | 一括操作で選択なしの場合 |
| 確認 | 确认要取消该用户角色吗？ | 単一解除時 |
| 確認 | 确认要删除选中的{N}条数据吗? | 一括解除時 |
| 成功 | 操作成功 | 解除成功時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| データスコープ外のロール | ServiceExceptionをスローし、アクセス拒否 |
| 通信エラー | エラーメッセージを表示 |
| セッションタイムアウト | ログイン画面へリダイレクト |

## 備考

- ユーザー状態の表示は辞書（sys_normal_disable）から変換される
- 一覧のデフォルトソートは作成日時の降順
- チェックボックスでの複数選択が可能
- 「批量取消授权」ボタンは選択がない状態ではdisabled

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ユーザーエンティティの構造を理解する |
| 1-2 | SysUserRole.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserRole.java` | ユーザー-ロール関連エンティティの構造を理解する |

**読解のコツ**: SysUserRoleはuser_idとrole_idの複合主キーを持つ中間テーブルのエンティティである。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysRoleController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` | authUser()、allocatedList()、cancelAuthUser()、cancelAuthUserAll()メソッドを理解する |

**主要処理フロー**:
1. **232-239行目**: authUser()メソッド - 画面表示処理
2. **244-252行目**: allocatedList()メソッド - 割当済みユーザー一覧取得
3. **257-264行目**: cancelAuthUser()メソッド - 単一解除
4. **269-276行目**: cancelAuthUserAll()メソッド - 一括解除

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | selectAllocatedList()メソッドの定義 |
| 3-2 | ISysRoleService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java` | deleteAuthUser()、deleteAuthUsers()メソッドの定義（147-156行目） |
| 3-3 | SysRoleServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysRoleServiceImpl.java` | 解除処理の実装詳細 |

#### Step 4: データアクセス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysUserMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` | selectAllocatedList SQLの詳細 |
| 4-2 | SysUserRoleMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserRoleMapper.java` | deleteUserRoleInfo()、deleteUserRoleInfos()メソッド |

#### Step 5: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | authUser.html | `ruoyi-admin/src/main/resources/templates/system/role/authUser.html` | 画面構造とJavaScript処理を理解する |

**主要処理フロー**:
- **52-107行目**: Bootstrap Tableの初期化とカラム定義
- **109-113行目**: queryParams関数 - 検索パラメータ構築
- **116-119行目**: selectUser関数 - ユーザー選択ダイアログ表示
- **122-132行目**: cancelAuthUserAll関数 - 一括解除処理
- **135-139行目**: cancelAuthUser関数 - 単一解除処理

### プログラム呼び出し階層図

```
[画面表示] authUser.html
    │
    ├─ SysRoleController.authUser()
    │      ├─ roleService.checkRoleDataScope()
    │      └─ roleService.selectRoleById()
    │
    ├─ [Ajax] allocatedList
    │      └─ SysRoleController.allocatedList()
    │             └─ userService.selectAllocatedList()
    │                    └─ SysUserMapper.selectAllocatedList()
    │
    ├─ [単一解除] cancelAuthUser()
    │      └─ SysRoleController.cancelAuthUser()
    │             └─ roleService.deleteAuthUser()
    │                    └─ SysUserRoleMapper.deleteUserRoleInfo()
    │
    └─ [一括解除] cancelAuthUserAll()
           └─ SysRoleController.cancelAuthUserAll()
                  └─ roleService.deleteAuthUsers()
                         └─ SysUserRoleMapper.deleteUserRoleInfos()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

roleId(hidden) ─────┐
loginName ──────────┼───▶ userService.selectAllocatedList() ───▶ ユーザー一覧(JSON)
phonenumber ────────┘

roleId + userId ────────▶ roleService.deleteAuthUser() ───────▶ sys_user_role (DELETE)

roleId + userIds[] ─────▶ roleService.deleteAuthUsers() ──────▶ sys_user_role (DELETE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| authUser.html | `ruoyi-admin/src/main/resources/templates/system/role/authUser.html` | テンプレート | ロールユーザー割当画面のHTML/JavaScript |
| SysRoleController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` | コントローラー | HTTPリクエストの処理 |
| ISysRoleService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java` | インターフェース | ロールサービスの定義 |
| ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | インターフェース | ユーザーサービスの定義 |
| SysUserRoleMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserRoleMapper.java` | マッパー | ユーザー-ロール関連のデータアクセス |
| SysUserRole.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserRole.java` | エンティティ | ユーザー-ロール関連データモデル |
| SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | エンティティ | ユーザーデータモデル |
