# 画面設計書 24-ユーザー選択ダイアログ

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「ユーザー選択ダイアログ」画面の設計仕様を定義するものである。ロールユーザー割当画面から呼び出され、ロールに未割当のユーザーを検索・選択して一括登録するためのモーダルダイアログである。

### 本画面の処理概要

この画面では、選択したロールにまだ割り当てられていないユーザーの一覧を表示し、複数ユーザーを選択してロールへの一括割当を実行する。ロールベースアクセス制御（RBAC）において、効率的なユーザー割当作業を支援する補助機能である。

**業務上の目的・背景**：新入社員の入社時や組織変更時など、複数ユーザーに同一ロールを一括付与する必要がある。この画面により、管理者はロール未割当のユーザーを素早く検索・選択し、効率的に権限を付与できる。

**画面へのアクセス方法**：ロールユーザー割当画面（No.23）の「添加用户」ボタンをクリックすることで、モーダルダイアログとして表示される。

**主要な操作・処理内容**：
1. 未割当ユーザー一覧の表示（検索、ページング、ソート）
2. ログイン名称・手機番号による検索
3. 複数ユーザーの選択（チェックボックス選択、記憶機能付き）
4. 選択したユーザーの一括ロール割当
5. ダイアログを閉じて親画面に戻る

**画面遷移**：ロールユーザー割当画面からモーダルとして表示。保存成功時は自動でダイアログを閉じ、親画面のテーブルを更新。

**権限による表示制御**：`system:role:list`権限を持つユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ユーザー管理 | 主機能 | ユーザー検索と選択処理 |
| 2 | ロール管理 | 補助機能 | ロールへのユーザー一括追加処理 |

## 画面種別

一覧（モーダルダイアログ）

## URL/ルーティング

- 画面表示: `GET /system/role/authUser/selectUser/{roleId}`
- 未割当ユーザー一覧: `POST /system/role/authUser/unallocatedList`
- 一括割当: `POST /system/role/authUser/selectAll`

## 入出力項目

### 検索条件入力項目

| 項目名 | 物理名 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ロールID | roleId | Long | - | hidden項目、自動設定 |
| ログイン名称 | loginName | String | - | 部分一致検索 |
| 手機番号 | phonenumber | String | - | 部分一致検索 |

### 出力項目（一覧表示）

| 項目名 | 物理名 | 型 | ソート | 説明 |
|--------|--------|-----|--------|------|
| チェックボックス | state | - | - | 選択用（クリックで選択、記憶機能付き） |
| ユーザーID | userId | Long | - | 非表示カラム |
| ログイン名称 | loginName | String | 可 | ユーザーのログイン名 |
| ユーザー名称 | userName | String | - | ユーザーの表示名 |
| 邮箱 | email | String | - | メールアドレス |
| 手機 | phonenumber | String | - | 電話番号 |
| ユーザー状態 | status | String | - | 正常/停用（辞書変換） |
| 創建時間 | createTime | DateTime | 可 | 作成日時（デフォルトソート降順） |

## 表示項目

| 表示項目 | 説明 | 初期値/条件 |
|----------|------|-------------|
| ログイン名称検索欄 | テキスト入力 | 空 |
| 手機番号検索欄 | テキスト入力 | 空 |
| 搜索ボタン | 検索実行 | - |
| 重置ボタン | 検索条件クリア | - |
| ユーザー一覧テーブル | Bootstrap Table（簡易モード） | ページサイズ10 |

### テーブル設定（特徴）

- showSearch: false - 検索バー非表示
- showRefresh: false - 更新ボタン非表示
- showToggle: false - 表示切替ボタン非表示
- showColumns: false - カラム選択ボタン非表示
- clickToSelect: true - 行クリックで選択
- rememberSelected: true - 選択状態を記憶（ページ遷移しても維持）

## イベント仕様

### 1-画面表示

モーダルダイアログとしてユーザー選択画面を表示する。

**処理フロー**：
1. 親画面から`$.modal.open()`で呼び出される
2. `SysRoleController.selectUser()`がroleIdを受け取る
3. `roleService.selectRoleById()`でロール情報を取得
4. ModelMapにロール情報を設定
5. Thymeleafテンプレートを描画
6. JavaScript初期化処理でBootstrap Tableを初期化
7. 未割当ユーザー一覧をAjax取得

### 2-検索実行

検索条件に基づいてユーザー一覧を再取得する。

**処理フロー**：
1. 「搜索」ボタンクリックで`$.table.search()`が呼び出される
2. queryParams関数で検索パラメータを構築
3. roleIdを検索パラメータに追加
4. POST /system/role/authUser/unallocatedListを呼び出し
5. 結果をテーブルに表示
6. 選択状態は維持される（rememberSelected: true）

### 3-検索条件リセット

検索条件をクリアして全件表示する。

**処理フロー**：
1. 「重置」ボタンクリックで`$.form.reset()`が呼び出される
2. 検索フォームの入力値をクリア
3. テーブルを再検索

### 4-ユーザー選択

ユーザーを選択状態にする。

**処理フロー**：
1. 行クリックまたはチェックボックスクリックで選択
2. 選択状態がBootstrap Tableの内部状態に保存される
3. ページ遷移しても選択状態は維持される

### 5-保存（一括割当）

選択したユーザーをロールに一括割当する。

**処理フロー**：
1. モーダルの確定ボタンで`submitHandler()`関数が呼び出される
2. `$.table.selectFirstColumns()`で選択されたuserIdを取得
3. 選択なしの場合、「请至少选择一条记录」警告を表示して中断
4. `$.operate.save()`でサーバーに送信
5. `POST /system/role/authUser/selectAll`でroleIdとuserIds（カンマ区切り）を送信
6. サーバー側で`checkRoleDataScope()`を実行
7. `roleService.insertAuthUsers()`でDB登録
8. 成功時はモーダルを閉じて親画面のテーブルを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存（一括割当） | sys_user_role | INSERT | 選択したユーザーとロールの関連を登録 |

### テーブル別更新項目詳細

#### sys_user_role

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | 選択されたユーザーID | ユーザーID |
| INSERT | role_id | 対象ロールID | ロールID |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 警告 | 请至少选择一条记录 | 保存時に選択なしの場合 |
| 成功 | 操作成功 | 保存成功時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| データスコープ外のロール | ServiceExceptionをスローし、アクセス拒否 |
| 通信エラー | エラーメッセージを表示 |
| セッションタイムアウト | ログイン画面へリダイレクト |

## 備考

- ユーザー状態の表示は辞書（sys_normal_disable）から変換される
- 一覧のデフォルトソートは作成日時の降順
- rememberSelected機能により、複数ページにまたがる選択が可能
- clickToSelect機能により、行のどこをクリックしても選択可能
- モーダルダイアログのため、ツールバーボタンは表示されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ユーザーエンティティの構造を理解する |
| 1-2 | SysUserRole.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserRole.java` | ユーザー-ロール関連エンティティの構造を理解する |

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysRoleController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` | selectUser()、unallocatedList()、selectAuthUserAll()メソッドを理解する |

**主要処理フロー**:
1. **281-287行目**: selectUser()メソッド - 画面表示処理
2. **292-300行目**: unallocatedList()メソッド - 未割当ユーザー一覧取得
3. **305-313行目**: selectAuthUserAll()メソッド - 一括割当処理

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | selectUnallocatedList()メソッドの定義 |
| 3-2 | ISysRoleService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java` | insertAuthUsers()メソッドの定義（159-165行目） |
| 3-3 | SysRoleServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysRoleServiceImpl.java` | 一括割当処理の実装詳細 |

#### Step 4: データアクセス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysUserMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` | selectUnallocatedList SQLの詳細 |
| 4-2 | SysUserRoleMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserRoleMapper.java` | batchUserRole()メソッド |

#### Step 5: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | selectUser.html | `ruoyi-admin/src/main/resources/templates/system/role/selectUser.html` | 画面構造とJavaScript処理を理解する |

**主要処理フロー**:
- **40-93行目**: Bootstrap Tableの初期化とカラム定義
- **46-51行目**: テーブルオプション（簡易モード、選択記憶）
- **95-99行目**: queryParams関数 - 検索パラメータ構築
- **102-110行目**: submitHandler関数 - 一括割当処理

### プログラム呼び出し階層図

```
[親画面] authUser.html
    │
    └─ $.modal.open() → [ダイアログ] selectUser.html
                              │
                              ├─ SysRoleController.selectUser()
                              │      └─ roleService.selectRoleById()
                              │
                              ├─ [Ajax] unallocatedList
                              │      └─ SysRoleController.unallocatedList()
                              │             └─ userService.selectUnallocatedList()
                              │                    └─ SysUserMapper.selectUnallocatedList()
                              │
                              └─ [保存] submitHandler()
                                     └─ SysRoleController.selectAuthUserAll()
                                            ├─ roleService.checkRoleDataScope()
                                            └─ roleService.insertAuthUsers()
                                                   └─ SysUserRoleMapper.batchUserRole()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

roleId(hidden) ─────┐
loginName ──────────┼───▶ userService.selectUnallocatedList() ───▶ ユーザー一覧(JSON)
phonenumber ────────┘

roleId + userIds[] ─────▶ roleService.insertAuthUsers() ──────▶ sys_user_role (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| selectUser.html | `ruoyi-admin/src/main/resources/templates/system/role/selectUser.html` | テンプレート | ユーザー選択ダイアログのHTML/JavaScript |
| SysRoleController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` | コントローラー | HTTPリクエストの処理 |
| ISysRoleService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java` | インターフェース | ロールサービスの定義 |
| ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | インターフェース | ユーザーサービスの定義 |
| SysUserRoleMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserRoleMapper.java` | マッパー | ユーザー-ロール関連のデータアクセス |
| SysUserRole.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserRole.java` | エンティティ | ユーザー-ロール関連データモデル |
| SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | エンティティ | ユーザーデータモデル |
