# 画面設計書 28-メニューツリー選択

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「メニューツリー選択」画面の設計仕様を定義するものである。メニュー新規登録・編集画面から呼び出され、親メニューを階層構造のツリーから選択するためのモーダルダイアログである。

### 本画面の処理概要

この画面では、システムに登録されている全メニューを階層構造のツリー形式で表示し、親メニューとして設定するメニューを選択できる。zTreeライブラリを使用したツリービューで、展開・折叠・キーワード検索機能を備えている。

**業務上の目的・背景**：メニューの階層構造を視覚的に把握しながら、適切な親メニューを選択する必要がある。この画面により、管理者はメニューの親子関係を直感的に設定できる。

**画面へのアクセス方法**：メニュー新規登録画面またはメニュー編集画面の「上級菜単」欄をクリックすることで、モーダルダイアログとして表示される。

**主要な操作・処理内容**：
1. メニューツリーの表示（全メニュー階層構造）
2. ツリーの展開/折叠操作
3. キーワードによるメニュー検索
4. ツリーノードのクリックによる選択
5. 選択結果の親画面への反映

**画面遷移**：メニュー新規登録/編集画面からモーダルとして表示。ノード選択後、親画面のコールバックで選択値を反映し、ダイアログを閉じる。

**権限による表示制御**：親画面（メニュー新規登録/編集）のアクセス権限に依存する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | メニュー管理 | 主機能 | 親メニュー選択のための補助機能 |

## 画面種別

選択ダイアログ（モーダル）

## URL/ルーティング

- 画面表示: `GET /system/menu/selectMenuTree/{menuId}`
- メニューツリーデータ取得: `GET /system/menu/menuTreeData`

## 入出力項目

### 入力項目（パスパラメータ）

| 項目名 | 物理名 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| メニューID | menuId | Long | 必須 | 現在選択中の親メニューID |

### 出力項目（初期表示）

| 項目名 | 物理名 | 型 | 説明 |
|--------|--------|-----|------|
| メニュー情報 | menu | SysMenu | 現在の親メニュー情報（menuId, menuName） |

### 出力項目（ツリーデータ）

| 項目名 | 物理名 | 型 | 説明 |
|--------|--------|-----|------|
| ツリーノードリスト | - | List<Ztree> | zTree形式のメニュー階層データ |

## 表示項目

| 表示項目 | 説明 | 初期値/条件 |
|----------|------|-------------|
| 検索表示切替ボタン | 検索エリアの表示/非表示切替 | 表示状態 |
| キーワード検索欄 | テキスト入力（最大50文字） | 空 |
| 搜索ボタン | キーワード検索実行 | - |
| 展開リンク | ツリー全展開 | - |
| 折叠リンク | ツリー全折叠 | - |
| メニューツリー | zTreeによる階層表示 | 1階層展開状態（expandLevel: 1） |

### hidden項目

| 項目名 | 物理名 | 説明 |
|--------|--------|------|
| 選択メニューID | treeId | 選択されたメニューのID |
| 選択メニュー名 | treeName | 選択されたメニューの名称 |

## イベント仕様

### 1-画面表示

モーダルダイアログとしてメニューツリー選択画面を表示する。

**処理フロー**：
1. 親画面から`$.modal.openOptions()`で呼び出される
2. `SysMenuController.selectMenuTree()`がmenuIdを受け取る
3. `menuService.selectMenuById()`で現在の親メニュー情報を取得
4. ModelMapにメニュー情報を設定
5. Thymeleafテンプレートを描画
6. JavaScript初期化処理で`$.tree.init()`を呼び出し
7. `GET /system/menu/menuTreeData`でツリーデータをAjax取得
8. zTreeライブラリでツリーを描画（1階層展開）

### 2-ツリーノードクリック

メニューノードをクリックして選択する。

**処理フロー**：
1. ツリーノードをクリック
2. `zOnClick(event, treeId, treeNode)`イベントハンドラが呼び出される
3. treeNodeからid（メニューID）とname（メニュー名）を取得
4. hidden項目の#treeIdと#treeNameに値を設定
5. 親画面の`doSubmit()`コールバックでダイアログを閉じる際、これらの値が読み取られる

### 3-ツリー展開

ツリー全体を展開する。

**処理フロー**：
1. 「展開」リンクをクリック
2. `$.tree.expand()`関数が呼び出される
3. zTreeのexpandAll(true)でツリー全体を展開

### 4-ツリー折叠

ツリー全体を折叠する。

**処理フロー**：
1. 「折叠」リンクをクリック
2. `$.tree.collapse()`関数が呼び出される
3. zTreeのexpandAll(false)でツリー全体を折叠

### 5-キーワード検索

キーワードでメニューを検索・ハイライトする。

**処理フロー**：
1. キーワード入力後「搜索」ボタンをクリック
2. `$.tree.searchNode()`関数が呼び出される
3. 入力キーワードに一致するノードをハイライト表示
4. 一致するノードの親ノードを自動展開

### 6-検索エリア表示切替

検索入力エリアの表示/非表示を切り替える。

**処理フロー**：
1. 切替ボタン（︾/︽）をクリック
2. `$.tree.toggleSearch()`関数が呼び出される
3. #searchエリアの表示/非表示を切替
4. ボタンラベルを切替（#btnShow / #btnHide）

## データベース更新仕様

この画面はデータベースの更新を行わない（参照のみ）。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| - | - | この画面では特別なメッセージ表示はない |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 通信エラー | ツリーが表示されない |
| セッションタイムアウト | ログイン画面へリダイレクト |

## 備考

- zTreeライブラリを使用したツリー表示
- 初期展開レベルは1（第1階層のみ展開）
- ツリーデータはログインユーザーのuserIdに基づいてフィルタリングされる
- 選択結果は親画面の`doSubmit()`コールバック経由で反映される
- メニュー新規登録/編集の両画面で共用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Ztree.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` | zTree用データ構造を理解する |
| 1-2 | SysMenu.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java` | メニューエンティティの構造を理解する |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysMenuController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java` | selectMenuTree()、menuTreeData()メソッドを理解する |

**主要処理フロー**:
1. **203-209行目**: selectMenuTree()メソッド - 画面表示処理
2. **192-199行目**: menuTreeData()メソッド - ツリーデータ取得API

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysMenuService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysMenuService.java` | menuTreeData()メソッドの定義 |
| 3-2 | SysMenuServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysMenuServiceImpl.java` | ツリーデータ生成の実装詳細 |

#### Step 4: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tree.html | `ruoyi-admin/src/main/resources/templates/system/menu/tree.html` | 画面構造とzTree初期化を理解する |

**主要処理フロー**:
- **12-13行目**: hidden項目（treeId, treeName）
- **14-27行目**: 検索・展開折叠UI
- **30-38行目**: zTree初期化（$.tree.init）
- **41-46行目**: zOnClick関数 - ノードクリック時の処理

### プログラム呼び出し階層図

```
[親画面] add.html / edit.html
    │
    └─ $.modal.openOptions() → [ダイアログ] tree.html
                                     │
                                     ├─ SysMenuController.selectMenuTree()
                                     │      └─ menuService.selectMenuById()
                                     │
                                     ├─ [Ajax] $.tree.init()
                                     │      └─ GET /system/menu/menuTreeData
                                     │             └─ menuService.menuTreeData()
                                     │
                                     └─ [選択] zOnClick()
                                            └─ hidden項目に値を設定
                                                   │
                                                   ▼
                                            [親画面] doSubmit()で読み取り
```

### データフロー図

```
[入力]                    [処理]                              [出力]

menuId(パス) ───────────▶ menuService.selectMenuById() ──────▶ menu情報(hidden初期値)

userId(セッション) ─────▶ menuService.menuTreeData() ────────▶ List<Ztree>(JSON)
                                                                     │
                                                                     ▼
                                                              zTree表示

[ノード選択] ─────────────▶ zOnClick() ─────────────────────▶ hidden項目更新
                                                                     │
                                                                     ▼
                                                              親画面へ反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tree.html | `ruoyi-admin/src/main/resources/templates/system/menu/tree.html` | テンプレート | メニューツリー選択ダイアログのHTML/JavaScript |
| SysMenuController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java` | コントローラー | HTTPリクエストの処理 |
| ISysMenuService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysMenuService.java` | インターフェース | メニューサービスの定義 |
| SysMenuServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysMenuServiceImpl.java` | サービス実装 | ツリーデータ生成の実装 |
| Ztree.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` | ドメイン | zTree用データ構造 |
| SysMenu.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java` | エンティティ | メニューデータモデル |
| add.html | `ruoyi-admin/src/main/resources/templates/system/menu/add.html` | 呼び出し元 | メニュー新規登録画面 |
| edit.html | `ruoyi-admin/src/main/resources/templates/system/menu/edit.html` | 呼び出し元 | メニュー編集画面 |
