# 画面設計書 29-アイコン選択

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「アイコン選択」画面の設計仕様を定義するものである。メニュー新規登録・編集画面の図標入力欄から呼び出され、Font Awesomeアイコンをビジュアルに選択するためのドロップダウンパネルである。

### 本画面の処理概要

この画面では、Font Awesomeライブラリで提供されている多数のアイコンをグリッド形式で表示し、視覚的にアイコンを選択できる。約450種類のアイコンから選択可能で、選択したアイコンのクラス名が親画面の入力欄に設定される。

**業務上の目的・背景**：メニューのアイコンを設定する際、アイコンのクラス名を手入力するのは困難である。この画面により、管理者はアイコンを視覚的に確認しながら選択できる。

**画面へのアクセス方法**：メニュー新規登録画面またはメニュー編集画面の「図標」入力欄にフォーカスすることで、ドロップダウンパネルとして表示される。

**主要な操作・処理内容**：
1. アイコン一覧の表示（グリッド形式）
2. アイコンのホバーでハイライト表示
3. アイコンクリックで選択・親画面反映

**画面遷移**：メニュー新規登録/編集画面から図標入力欄フォーカスで表示。アイコン選択または入力欄外クリックでドロップダウンを非表示。

**権限による表示制御**：親画面（メニュー新規登録/編集）のアクセス権限に依存する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | メニュー管理 | 主機能 | メニューアイコン選択のための補助機能 |

## 画面種別

選択パネル（インラインドロップダウン）

## URL/ルーティング

- 単独表示: `GET /system/menu/icon`
- インクルード: `data-th-include="system/menu/icon"`

## 入出力項目

この画面はスタンドアロンの入出力を持たない。親画面にインクルードされて使用される。

## 表示項目

| 表示項目 | 説明 | 初期値/条件 |
|----------|------|-------------|
| アイコングリッド | Font Awesomeアイコン一覧（約450種類） | 非表示（初期状態） |

### アイコン一覧（抜粋）

アイコンはFont Awesome 4.xの豊富なアイコンセットから選択可能。主なカテゴリ：

- Webアプリケーション用: `fa-home`, `fa-user`, `fa-cog`, `fa-search`
- ファイル・フォルダ: `fa-file`, `fa-folder`, `fa-folder-open`
- コミュニケーション: `fa-envelope`, `fa-comment`, `fa-phone`
- ナビゲーション: `fa-bars`, `fa-sitemap`, `fa-list`
- データ: `fa-database`, `fa-table`, `fa-bar-chart`
- アクション: `fa-plus`, `fa-edit`, `fa-trash`, `fa-refresh`

## イベント仕様

### 1-ドロップダウン表示

図標入力欄フォーカス時にアイコン選択パネルを表示する。

**処理フロー**（親画面のJavaScriptによる制御）：
1. 図標入力欄（`input[name='icon']`）にフォーカス
2. `.icon-drop`のdisplayをshowに設定
3. アイコン一覧が表示される（最大高さ200px、スクロール可能）

### 2-アイコンホバー

アイコンにマウスオーバーでハイライト表示する。

**処理フロー**：
1. アイコン要素（`.fa`）にマウスオーバー
2. CSS `:hover`により背景色（#1d9d74）と文字色（白）が変更
3. カーソルがpointerに変更

### 3-アイコン選択

アイコンをクリックして選択し、親画面に反映する。

**処理フロー**（親画面のJavaScriptによる制御）：
1. アイコン要素（`.ico-list i`）をクリック
2. クリックされた要素のclassを取得（`$(this).attr('class')`）
3. 親画面の#icon入力欄に値を設定
4. ドロップダウンは自動では閉じない（入力欄外クリックで閉じる）

### 4-ドロップダウン非表示

入力欄以外をクリックでドロップダウンを閉じる。

**処理フロー**（親画面のJavaScriptによる制御）：
1. フォーム内でクリックイベント発生
2. クリック対象が`input[name='icon']`以外の場合
3. `.icon-drop`のdisplayをhideに設定

## データベース更新仕様

この画面はデータベースの更新を行わない（表示のみ）。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| - | - | この画面では特別なメッセージ表示はない |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| CSSロードエラー | アイコンが表示されない |

## 備考

- Font Awesome 4.xのアイコンセットを使用
- 約450種類のアイコンが選択可能
- アイコンサイズは18px、パディング5px
- 最大高さ200pxでスクロール表示
- ホバー時の背景色は#1d9d74（緑系）
- このHTMLはThymeleafのth:include/data-th-includeで親画面にインクルードされる
- 単独でのアクセスも可能（GET /system/menu/icon）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: アイコン一覧を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | icon.html | `ruoyi-admin/src/main/resources/templates/system/menu/icon.html` | Font Awesomeアイコン一覧とCSSスタイルを理解する |

**主要処理フロー**:
- **6行目**: Font Awesome CSSのインクルード
- **8-20行目**: アイコンのスタイル定義（サイズ、パディング、ホバー効果）
- **23-926行目**: 約450種類のアイコン要素（`<i class="fa fa-xxx">`）

#### Step 2: 親画面での制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | add.html | `ruoyi-admin/src/main/resources/templates/system/menu/add.html` | アイコン選択のJavaScript制御を理解する |
| 2-2 | edit.html | `ruoyi-admin/src/main/resources/templates/system/menu/edit.html` | アイコン選択のJavaScript制御を理解する |

**add.htmlの主要処理フロー**:
- **77-81行目**: icon.htmlのインクルード
- **137-149行目**: フォーカス/クリックイベントハンドラ

**edit.htmlの主要処理フロー**:
- **66-70行目**: icon.htmlのインクルード
- **146-159行目**: フォーカス/クリックイベントハンドラ

#### Step 3: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysMenuController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java` | icon()メソッドを理解する |

**主要処理フロー**:
- **161-165行目**: icon()メソッド - 単独表示用のエンドポイント

### プログラム呼び出し階層図

```
[親画面] add.html / edit.html
    │
    ├─ [インクルード] data-th-include="system/menu/icon"
    │                        │
    │                        └─ icon.html（アイコン一覧HTML）
    │
    ├─ [フォーカス] input[name='icon']
    │      └─ $(".icon-drop").show()
    │
    ├─ [クリック] .ico-list i
    │      └─ $('#icon').val($(this).attr('class'))
    │
    └─ [クリック] フォーム（icon以外）
           └─ $(".icon-drop").hide()

[単独アクセス]
    │
    └─ GET /system/menu/icon
           └─ SysMenuController.icon()
                  └─ return "system/menu/icon"
```

### データフロー図

```
[入力]                    [処理]                              [出力]

(なし) ──────────────────▶ icon.htmlの静的表示 ────────────▶ アイコングリッド

[アイコンクリック] ──────▶ $(this).attr('class') ──────────▶ 親画面 #icon入力欄
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| icon.html | `ruoyi-admin/src/main/resources/templates/system/menu/icon.html` | テンプレート | Font Awesomeアイコン一覧 |
| font-awesome.min.css | `ruoyi-admin/src/main/resources/static/css/font-awesome.min.css` | CSS | Font Awesomeスタイルシート |
| SysMenuController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java` | コントローラー | 単独表示用エンドポイント |
| add.html | `ruoyi-admin/src/main/resources/templates/system/menu/add.html` | 呼び出し元 | メニュー新規登録画面 |
| edit.html | `ruoyi-admin/src/main/resources/templates/system/menu/edit.html` | 呼び出し元 | メニュー編集画面 |
