# 画面設計書 3-画面ロック

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「画面ロック」の設計仕様を定義する。

### 本画面の処理概要

システム利用中に一時的に離席する際に画面をロックし、パスワード再入力による再認証を要求する画面である。Three.jsによる3Dパーティクルアニメーション背景とリアルタイム時刻表示が特徴的なセキュリティ画面。

**業務上の目的・背景**：後台管理システムでは機密情報を扱うことが多いため、ユーザーが離席する際にセッションを維持したまま画面をロックする機能が必要となる。この機能により、完全なログアウト・再ログインの手間を省きつつ、離席中の不正アクセスを防止できる。ログアウトとは異なり、セッション情報やワークスペースの状態を保持したまま一時的にアクセスを制限できる点が特徴。

**画面へのアクセス方法**：システム首頁の右上にある「锁屏（ロック）」アイコンをクリックするか、システムのロック機能が実行された際にこの画面に遷移する。URL直接アクセスも可能（`/lockscreen`）。

**主要な操作・処理内容**：
1. 現在のログインユーザー名とアバターの表示
2. リアルタイム時刻の表示（HH:mm:ss形式）
3. パスワードの入力
4. ロック解除ボタン押下またはEnterキーによる再認証処理
5. 「退出重新登录」リンクからのログアウト

**画面遷移**：
- 遷移元：システム首頁の「锁屏」アイコン
- 遷移先：ロック解除成功時→システム首頁（/index）、ログアウトリンク→ログイン画面

**権限による表示制御**：本画面は認証済みユーザー専用であり、セッションが有効な状態でのみ表示される。セッションタイムアウト時はログイン画面にリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ログイン | 主機能 | パスワード入力による画面ロック解除認証処理 |

## 画面種別

認証（ロック解除）

## URL/ルーティング

- GET `/lockscreen` - 画面ロック画面の表示
- POST `/unlockscreen` - ロック解除処理（Ajax）
- GET `/logout` - ログアウト処理

## 入出力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 入出力 | 説明 |
|--------|--------|-----|------|--------|--------|------|
| パスワード | password | String | ○ | - | 入力 | 現在のログインユーザーのパスワード |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 現在時刻 | リアルタイム更新（HH:mm:ss形式） |
| ユーザー名 | ログイン名 / ユーザー名 形式で表示 |
| ユーザーアバター | ユーザーのプロフィール画像（未設定時はデフォルト画像） |
| 案内メッセージ | 「系统锁屏,请输入密码登录!」 |
| ログアウトリンク | 「退出重新登录」 |
| 3Dパーティクル背景 | Three.jsによるアニメーション |

## イベント仕様

### 1-ロック解除ボタン押下（矢印アイコン）

1. パスワードの入力有無をチェック
2. パスワード未入力時はエラーメッセージ「请输入密码」を表示
3. 入力済みの場合、AjaxでPOST `/unlockscreen` にリクエスト送信
4. リクエスト前にローディングインジケータを表示
5. サーバー側でパスワード検証処理を実行
6. 検証成功時：セッションからロック状態を解除し、`/index` にリダイレクト
7. 検証失敗時：エラーメッセージ「密码不正确，请重新输入。」を表示、入力欄をクリア

### 2-Enterキー押下

1. ロック解除ボタン押下と同じ処理を実行

### 3-ログアウトリンククリック

1. `/logout` に遷移し、完全にログアウト
2. ログイン画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ロック解除（成功） | - | - | データベース更新なし（セッション操作のみ） |
| ログアウト | sys_user_online | DELETE | オンラインユーザー情報の削除 |
| ログアウト | sys_logininfor | INSERT | ログアウト履歴の記録 |

### テーブル別更新項目詳細

ロック解除処理自体はデータベースを更新せず、セッション属性の操作のみを行う。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 情報 | 系统锁屏,请输入密码登录! | 画面表示時（固定） |
| エラー | 请输入密码 | パスワードが未入力 |
| エラー | 密码不正确，请重新输入。 | パスワード検証失敗 |
| エラー | 服务器超时，请重新登录 | セッションタイムアウト |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| セッションタイムアウト | エラーメッセージ「服务器超时，请重新登录」を表示 |
| パスワード検証失敗 | エラーメッセージを表示、パスワード入力欄をクリア |
| サーバーエラー | エラーメッセージ表示 |

## 備考

- Three.jsによる3Dパーティクルアニメーションが背景に表示される
- 時刻は500msごとに更新される
- マウス移動に反応してパーティクルが動的に変化する
- セッションにLOCK_SCREEN属性がセットされることでロック状態を管理
- CSRF対策としてCSRF-Tokenがリクエストヘッダーに含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ロック解除処理で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ユーザーエンティティ（loginName, userName, avatar） |
| 1-2 | ShiroConstants.java | `ruoyi-common/src/main/java/com/ruoyi/common/constant/ShiroConstants.java` | LOCK_SCREEN, CSRF_TOKEN定数 |

**読解のコツ**: セッション属性として使用される定数名を確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | lockscreen/unlockscreenのハンドリング |

**主要処理フロー**:
1. **92-98行目**: GET /lockscreen - ロック画面表示、LOCK_SCREEN属性をセッションにセット
2. **101-116行目**: POST /unlockscreen - パスワード検証、LOCK_SCREEN属性をセッションから削除

#### Step 3: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lock.html | `ruoyi-admin/src/main/resources/templates/lock.html` | 画面レイアウト、Three.jsアニメーション |

**主要処理フロー**:
- **69-76行目**: 時刻表示の初期化とsetInterval更新
- **84-114行目**: unlock()関数 - パスワード検証Ajax処理
- **136-209行目**: Three.jsパーティクルアニメーション

#### Step 4: パスワード検証層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | matches()メソッドによるパスワード検証 |

### プログラム呼び出し階層図

```
lock.html::unlock()
    │
    ├─ $.ajax POST /unlockscreen
    │      │
    │      └─ SysIndexController.unlockscreen()
    │             │
    │             ├─ getSysUser() - 現在のユーザー取得
    │             │
    │             ├─ passwordService.matches() - パスワード検証
    │             │
    │             └─ session.removeAttribute(LOCK_SCREEN) - ロック解除
    │
    └─ 成功時: location.href = ctx + 'index'
```

### データフロー図

```
[入力]               [処理]                    [出力]

password ──────▶ SysIndexController ──▶ AjaxResult {code, msg}
                        │
                        ├──▶ SysPasswordService.matches()
                        │
                        └──▶ Session (LOCK_SCREEN属性の操作)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lock.html | `ruoyi-admin/src/main/resources/templates/lock.html` | テンプレート | ロック画面のHTML、Three.js |
| SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | コントローラー | ロック/解除エンドポイント |
| SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | サービス | パスワード検証 |
| ShiroConstants.java | `ruoyi-common/src/main/java/com/ruoyi/common/constant/ShiroConstants.java` | 定数 | セッション属性キー定義 |
| three.min.js | `ruoyi-admin/src/main/resources/static/js/three.min.js` | JavaScript | 3Dアニメーションライブラリ |
| ry-ui.js | `ruoyi-admin/src/main/resources/static/ruoyi/js/ry-ui.js` | JavaScript | 共通UIライブラリ（$.modal等） |
