# 画面設計書 30-部門管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「部門管理一覧」画面の設計仕様を定義するものである。組織の部門情報を階層構造のツリーテーブル形式で管理する画面で、部門の検索、新規登録、編集、削除機能を提供する。

### 本画面の処理概要

この画面では、システムに登録されている部門を階層構造（ツリーテーブル）形式で一覧表示し、部門の管理操作を行う。部門名称や状態での検索、展開/折叠機能を備え、効率的な部門管理を実現する。

**業務上の目的・背景**：企業の組織構造を管理するため、部門情報の登録・変更・削除が必要である。この画面により、管理者は組織の階層構造を視覚的に把握しながら部門管理を行える。

**画面へのアクセス方法**：サイドメニューの「系統管理」>「部門管理」から遷移。URLは`/system/dept`。

**主要な操作・処理内容**：
1. 部門一覧の階層表示（ツリーテーブル）
2. 部門名称・状態による検索
3. 新規部門の追加（ツールバー/行リンク）
4. 既存部門の編集（ツールバー/行リンク）
5. 部門の削除（行リンク）
6. ツリーの展開/折叠操作

**画面遷移**：
- 「新増」ボタン/リンク → 部門新規登録画面（モーダル）
- 「編輯」ボタン/リンク → 部門編集画面（モーダル）

**権限による表示制御**：`system:dept:view`権限を持つユーザーのみアクセス可能。各操作ボタンは対応する権限で制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 部門管理 | 主機能 | 部門の一覧表示、検索、CRUD操作 |

## 画面種別

一覧（ツリーテーブル）

## URL/ルーティング

- 画面表示: `GET /system/dept`
- 一覧取得: `POST /system/dept/list`
- 新規画面: `GET /system/dept/add/{parentId}`
- 編集画面: `GET /system/dept/edit/{deptId}`
- 削除: `GET /system/dept/remove/{deptId}`
- 部門名重複チェック: `POST /system/dept/checkDeptNameUnique`

## 入出力項目

### 検索条件入力項目

| 項目名 | 物理名 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 部門名称 | deptName | String | - | 部分一致検索 |
| 部門状態 | status | String | - | 辞書（sys_normal_disable）から選択 |

### 出力項目（一覧表示）

| 項目名 | 物理名 | 型 | 説明 |
|--------|--------|-----|------|
| ラジオボタン | selectItem | - | 行選択用 |
| 部門名称 | deptName | String | ツリー階層表示（左寄せ） |
| 排序 | orderNum | Integer | 表示順序 |
| 状態 | status | String | 正常/停用（辞書変換） |
| 創建時間 | createTime | DateTime | 作成日時 |
| 操作 | - | - | 編輯/新増/削除リンク |

## 表示項目

| 表示項目 | 説明 | 初期値/条件 |
|----------|------|-------------|
| 部門名称検索欄 | テキスト入力 | 空 |
| 部門状態検索欄 | ドロップダウン（所有/正常/停用） | 所有 |
| 搜索ボタン | 検索実行 | - |
| 重置ボタン | 検索条件クリア | - |
| 新増ボタン | 部門新規登録（親ID=100） | system:dept:add権限 |
| 修改ボタン | 選択行の編集 | system:dept:edit権限、行選択必須 |
| 展開/折叠ボタン | ツリーの展開/折叠切替 | - |
| ツリーテーブル | Bootstrap Tree Table | 階層表示 |

### 操作カラム表示条件

| 操作 | 表示条件 |
|------|----------|
| 編輯リンク | parentId != 0（ルート以外）かつsystem:dept:edit権限 |
| 新増リンク | parentId != 0（ルート以外）かつsystem:dept:add権限 |
| 削除リンク | parentId != 0（ルート以外）かつsystem:dept:remove権限 |

## イベント仕様

### 1-画面表示

部門一覧をツリーテーブル形式で表示する。

**処理フロー**：
1. `GET /system/dept`でHTMLを取得
2. JavaScript初期化で`$.treeTable.init()`を呼び出し
3. `POST /system/dept/list`でデータをAjax取得
4. deptId/parentIdでツリー構造を構築
5. 状態カラムは辞書（sys_normal_disable）で変換

### 2-検索実行

検索条件に基づいて部門一覧を再取得する。

**処理フロー**：
1. 「搜索」ボタンクリックで`$.treeTable.search()`が呼び出される
2. フォームから検索パラメータを収集
3. `POST /system/dept/list`を呼び出し
4. 結果でツリーテーブルを更新

### 3-検索条件リセット

検索条件をクリアして全件表示する。

**処理フロー**：
1. 「重置」ボタンクリックで`$.form.reset()`が呼び出される
2. フォームの入力値をクリア
3. ツリーテーブルを再検索

### 4-展開/折叠切替

ツリーの展開/折叠状態を切り替える。

**処理フロー**：
1. 「展開/折叠」ボタンクリック
2. expandAllBtnイベントハンドラが呼び出される
3. ツリーの展開/折叠状態をトグル

### 5-新規登録（ツールバー）

部門新規登録画面を開く（親ID=100：若依科技）。

**処理フロー**：
1. 「新増」ボタンクリックで`$.operate.add(100)`が呼び出される
2. `GET /system/dept/add/100`でモーダルを表示
3. 非管理者の場合、parentIdはログインユーザーのdeptIdに強制設定

### 6-新規登録（行リンク）

選択した部門の下位に新規部門を登録する。

**処理フロー**：
1. 行の「新増」リンクをクリック
2. `$.operate.add(deptId)`が呼び出される
3. `GET /system/dept/add/{deptId}`でモーダルを表示

### 7-編集（ツールバー）

選択した部門の編集画面を開く。

**処理フロー**：
1. 行を選択後「修改」ボタンクリック
2. `$.operate.edit()`が呼び出される
3. 選択行のdeptIdを取得
4. `GET /system/dept/edit/{deptId}`でモーダルを表示

### 8-編集（行リンク）

部門編集画面を開く。

**処理フロー**：
1. 行の「編輯」リンクをクリック
2. `$.operate.edit(deptId)`が呼び出される
3. `GET /system/dept/edit/{deptId}`でモーダルを表示

### 9-削除

部門を削除する。

**処理フロー**：
1. 行の「削除」リンクをクリック
2. `$.operate.remove(deptId)`が呼び出される
3. 確認ダイアログを表示
4. 確認後、`GET /system/dept/remove/{deptId}`を呼び出し
5. サーバー側で下位部門存在チェック
6. サーバー側でユーザー存在チェック
7. データスコープチェック後、削除実行
8. 成功時はツリーテーブルを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | sys_dept | DELETE（論理） | del_flag=2に更新 |

### テーブル別更新項目詳細

#### sys_dept（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | del_flag | 2 | 論理削除フラグ |
| UPDATE | update_by | ログインユーザー名 | 更新者 |
| UPDATE | update_time | sysdate() | 更新日時 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 警告 | 存在下级部门,不允许删除 | 下位部門が存在する場合 |
| 警告 | 部门存在用户,不允许删除 | 部門にユーザーが割り当てられている場合 |
| 成功 | 操作成功 | 削除成功時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 下位部門存在 | 警告メッセージを表示して削除中断 |
| ユーザー存在 | 警告メッセージを表示して削除中断 |
| データスコープ外 | ServiceExceptionをスローし、アクセス拒否 |
| 通信エラー | エラーメッセージを表示 |
| セッションタイムアウト | ログイン画面へリダイレクト |

## 備考

- 部門状態の選択肢は辞書（sys_normal_disable）から取得される
- ツリーテーブルのコードはdeptId、親コードはparentId
- ルート部門（parentId=0）には操作リンクが表示されない
- 非管理者ユーザーは新規登録時、自分の所属部門配下にのみ追加可能
- データスコープにより、アクセス可能な部門が制限される
- 削除は論理削除（del_flag=2）で実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDept.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` | 部門エンティティの構造、各フィールドのバリデーションを理解する |

**主要フィールド**:
- **21-55行目**: エンティティフィールド定義（deptId, parentId, ancestors, deptName, orderNum, leader, phone, email, status, delFlag）
- **87-88行目**: deptNameは@NotBlank、最大30文字
- **99-100行目**: orderNumは@NotNull

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysDeptController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java` | dept()、list()、remove()メソッドを理解する |

**主要処理フロー**:
1. **38-43行目**: dept()メソッド - 画面表示
2. **45-52行目**: list()メソッド - 一覧データ取得
3. **133-149行目**: remove()メソッド - 削除処理（下位部門・ユーザー存在チェック）

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysDeptService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDeptService.java` | サービスインターフェースの定義 |
| 3-2 | SysDeptServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` | 削除・重複チェック処理の実装 |

#### Step 4: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | dept.html | `ruoyi-admin/src/main/resources/templates/system/dept/dept.html` | 画面構造とツリーテーブル初期化を理解する |

**主要処理フロー**:
- **10-28行目**: 検索フォーム（deptName, status）
- **31-41行目**: ツールバーボタン（新増、修改、展開/折叠）
- **49-52行目**: 権限フラグ変数の設定
- **55-109行目**: ツリーテーブル初期化とカラム定義
- **96-104行目**: 操作カラムのformatter（parentId!=0の場合のみ表示）

### プログラム呼び出し階層図

```
[画面表示] dept.html
    │
    ├─ SysDeptController.dept()
    │
    ├─ [Ajax] $.treeTable.init()
    │      └─ POST /system/dept/list
    │             └─ deptService.selectDeptList()
    │
    ├─ [新規] $.operate.add(parentId)
    │      └─ GET /system/dept/add/{parentId}
    │
    ├─ [編集] $.operate.edit(deptId)
    │      └─ GET /system/dept/edit/{deptId}
    │
    └─ [削除] $.operate.remove(deptId)
           └─ GET /system/dept/remove/{deptId}
                  └─ SysDeptController.remove()
                         ├─ deptService.selectDeptCount()
                         ├─ deptService.checkDeptExistUser()
                         ├─ deptService.checkDeptDataScope()
                         └─ deptService.deleteDeptById()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

deptName ─────────┐
                  ├───▶ deptService.selectDeptList() ───────▶ 部門一覧(JSON)
status ───────────┘                                               │
                                                                  ▼
                                                          ツリーテーブル表示

deptId ─────────────────▶ deptService.deleteDeptById() ────▶ sys_dept (UPDATE del_flag=2)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dept.html | `ruoyi-admin/src/main/resources/templates/system/dept/dept.html` | テンプレート | 部門管理一覧画面のHTML/JavaScript |
| SysDeptController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java` | コントローラー | HTTPリクエストの処理 |
| ISysDeptService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDeptService.java` | インターフェース | 部門サービスの定義 |
| SysDeptServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` | サービス実装 | 部門サービスの実装 |
| SysDeptMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDeptMapper.xml` | マッパー | 部門データアクセスSQL |
| SysDept.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` | エンティティ | 部門データモデル |
