# 画面設計書 33-部門ツリー選択

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「部門ツリー選択」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、部門をツリー形式で表示し、ユーザーが親部門を選択するための補助画面である。部門新規登録・編集画面からモーダルダイアログとして呼び出され、選択した部門の情報を呼び出し元画面に返す。

**業務上の目的・背景**：組織の部門階層は多層構造となることが多く、リスト形式での選択は困難である。ツリー形式で視覚的に階層構造を表示することで、ユーザーが直感的に目的の部門を見つけ、選択できるようにする必要がある。また、部門編集時には自部門と配下部門を除外することで、循環参照を防止する。

**画面へのアクセス方法**：部門新規登録画面または部門編集画面の「上級部門」入力欄をクリックすることで、本画面がモーダルダイアログとして表示される。

**主要な操作・処理内容**：
1. 部門ツリーの表示（ztree.jsによる階層表示）
2. キーワード検索（部門名でのフィルタリング）
3. ツリーの展開/折りたたみ操作
4. 部門ノードをクリックして選択
5. 選択した部門情報を呼び出し元画面に返却

**画面遷移**：部門新規登録画面または部門編集画面からモーダルとして表示される。部門ノードを選択し、呼び出し元画面の「確定」ボタンをクリックすることで、選択情報が反映されダイアログが閉じる。

**権限による表示制御**：`system:dept:list`権限を持つユーザーのみが本画面にアクセス可能。また、データスコープによる部門フィルタリングが適用される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 部門管理 | 主機能 | 親部門選択用ツリー表示処理 |

## 画面種別

選択（モーダルダイアログ形式）

## URL/ルーティング

- 画面表示：`GET /system/dept/selectDeptTree/{deptId}` または `GET /system/dept/selectDeptTree/{deptId}/{excludeId}`
- ツリーデータ取得：`GET /system/dept/treeData/{excludeId}`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力形式 | 備考 |
|--------|--------|-----|------|----------|------|
| 選択部門ID | treeId | Long | - | hidden | 選択した部門のID |
| 選択部門名 | treeName | String | - | hidden | 選択した部門の名称 |
| 検索キーワード | keyword | String | - | テキスト | 部門名で検索 |

## 表示項目

| 項目名 | 表示形式 | 初期値 | 備考 |
|--------|----------|--------|------|
| 検索入力欄 | テキストボックス | 空 | 部門名で検索 |
| 搜索ボタン | ボタン | - | 検索実行 |
| 展開/折叠リンク | リンク | - | ツリー全展開/全折りたたみ |
| 部門ツリー | ztreeコンポーネント | 全部門表示 | 階層構造で表示 |

## イベント仕様

### 1-部門ノードクリック

ツリー上の部門ノードをクリックすると、その部門の情報がhiddenフィールドに設定される。

**処理フロー**：
1. クリックイベント（zOnClick）が発火
2. treeNode.idからdeptIdを取得
3. treeNode.nameからdeptNameを取得
4. #treeIdフィールドに選択した部門IDを設定
5. #treeNameフィールドに選択した部門名を設定

### 2-検索ボタンクリック

検索ボタンをクリックすると、キーワードでツリーをフィルタリングする。

**処理フロー**：
1. $.tree.searchNode()を呼び出し
2. #keywordフィールドの値を取得
3. ztreeの検索機能でマッチするノードをハイライト

### 3-展開リンククリック

「展開」リンクをクリックすると、ツリーのすべてのノードを展開する。

**処理フロー**：
1. $.tree.expand()を呼び出し
2. ztree.expandAll(true)を実行

### 4-折叠リンククリック

「折叠」リンクをクリックすると、ツリーのすべてのノードを折りたたむ。

**処理フロー**：
1. $.tree.collapse()を呼び出し
2. ztree.expandAll(false)を実行

### 5-検索表示/非表示切替

検索エリアの表示/非表示を切り替える。

**処理フロー**：
1. $.tree.toggleSearch()を呼び出し
2. #searchエリアのvisibilityを切替
3. btnShow/btnHideラベルの表示を切替

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ツリーデータ取得 | sys_dept | SELECT | 部門一覧を取得 |

### テーブル別更新項目詳細

本画面はデータ参照のみでデータベース更新は行わない。

#### sys_dept（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | dept_id | del_flag = '0' | 削除されていない部門 |
| SELECT | parent_id | - | 親部門ID |
| SELECT | dept_name | - | 部門名称 |
| SELECT | ancestors | excludeIdでフィルタ | 配下除外用 |
| SELECT | status | '0'(正常)のみ | 停用部門は除外 |

## メッセージ仕様

本画面固有のメッセージはない。

## 例外処理

| 例外パターン | 発生条件 | 処理内容 |
|-------------|----------|----------|
| 権限不足 | system:dept:list権限なし | 画面アクセス拒否 |
| データなし | 表示対象の部門が0件 | 空のツリーを表示 |
| 通信エラー | Ajaxリクエスト失敗 | エラーメッセージ表示 |

## 備考

- excludeIdが指定された場合、そのIDと配下の部門はツリーから除外される
- 停用状態（status='1'）の部門はツリーに表示されない
- ツリーの初期展開レベルは2（expandLevel: 2）
- ztree.jsライブラリを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Ztree.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` | ztreeコンポーネント用データ構造 |

**読解のコツ**: Ztreeクラスはid, pId, name, titleなどのプロパティを持ち、ztree.jsが要求する形式に対応している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tree.html | `ruoyi-admin/src/main/resources/templates/system/dept/tree.html` | 画面構成、ztree初期化処理 |

**主要処理フロー**:
1. **行12-13**: 選択値保持用hiddenフィールド（treeId, treeName）
2. **行30-42**: ztree初期化、expandLevel設定、onClickハンドラ設定
3. **行44-49**: zOnClick関数で選択値をhiddenにセット

#### Step 3: コントローラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDeptController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java` | selectDeptTree, treeDataExcludeChildメソッド |

**主要処理フロー**:
- **行167-174**: selectDeptTree()メソッド - 画面表示、excludeIdをModelに設定
- **行179-188**: treeDataExcludeChild()メソッド - 配下除外したツリーデータ取得

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysDeptServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` | selectDeptTreeExcludeChild, initZtreeメソッド |

**主要処理フロー**:
- **行67-79**: selectDeptTreeExcludeChild()メソッド - excludeIdと配下を除外
- **行111-145**: initZtree()メソッド - SysDeptリストをZtreeリストに変換

### プログラム呼び出し階層図

```
tree.html（画面表示）
    │
    ├─ $.tree.init() [JavaScript]
    │      └─ GET /system/dept/treeData/{excludeId}
    │             │
    │             └─ SysDeptController.treeDataExcludeChild() [行179-188]
    │                    │
    │                    └─ deptService.selectDeptTreeExcludeChild()
    │                           └─ SysDeptServiceImpl.selectDeptTreeExcludeChild() [行67-79]
    │                                  ├─ deptMapper.selectDeptList() [行72]
    │                                  ├─ 配下除外処理 [行73-76]
    │                                  └─ initZtree() [行77]
    │
    └─ zOnClick() [行44-49]
           └─ hiddenフィールド更新
```

### データフロー図

```
[入力]                   [処理]                              [出力]

excludeId ──────────▶ treeDataExcludeChild()
                              │
                              ├─▶ selectDeptList()
                              │         └─▶ sys_dept SELECT
                              │
                              ├─▶ 配下除外フィルタ
                              │
                              └─▶ initZtree()
                                      └─▶ Ztreeリスト ──────▶ JSON Response
                                                                  │
                                                                  ▼
                                                           ztree.js描画
                                                                  │
ノードクリック ──────────────────────────────────────────────────▶ hidden更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tree.html | `ruoyi-admin/src/main/resources/templates/system/dept/tree.html` | テンプレート | 画面表示 |
| SysDeptController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java` | コントローラー | リクエスト処理 |
| SysDeptServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` | サービス | ビジネスロジック |
| Ztree.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` | エンティティ | ツリーデータモデル |
| SysDeptMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDeptMapper.xml` | 設定 | SQLマッピング |
| ztree.js | `ruoyi-admin/src/main/resources/static/ruoyi/js/ry-ui.js`（組込） | ライブラリ | ツリーUI |
